/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.core.action.ActionListener;
import org.opensearch.tasks.Task;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.caching.CacheBuffer;
import org.opensearch.timeseries.caching.CacheProvider;
import org.opensearch.timeseries.caching.PriorityCache;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.IntermediateResult;
import org.opensearch.timeseries.ml.ModelColdStart;
import org.opensearch.timeseries.ml.ModelManager;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.ml.Sample;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IndexableResult;
import org.opensearch.timeseries.ratelimit.CheckpointMaintainWorker;
import org.opensearch.timeseries.ratelimit.CheckpointReadWorker;
import org.opensearch.timeseries.ratelimit.CheckpointWriteWorker;
import org.opensearch.timeseries.ratelimit.ColdStartWorker;
import org.opensearch.timeseries.ratelimit.FeatureRequest;
import org.opensearch.timeseries.ratelimit.RateLimitedRequestWorker;
import org.opensearch.timeseries.ratelimit.RequestPriority;
import org.opensearch.timeseries.ratelimit.ResultWriteRequest;
import org.opensearch.timeseries.ratelimit.ResultWriteWorker;
import org.opensearch.timeseries.ratelimit.SaveResultStrategy;
import org.opensearch.timeseries.stats.Stats;
import org.opensearch.timeseries.transport.ResultBulkRequest;
import org.opensearch.timeseries.transport.ResultBulkResponse;
import org.opensearch.timeseries.transport.SingleStreamResultRequest;
import org.opensearch.timeseries.transport.handler.IndexMemoryPressureAwareResultHandler;
import org.opensearch.timeseries.util.ExceptionUtil;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.transport.TransportService;

public abstract class AbstractSingleStreamResultTransportAction<RCFModelType extends ThresholdedRandomCutForest, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CheckpointWriterType extends CheckpointWriteWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType>, CheckpointMaintainerType extends CheckpointMaintainWorker, CacheBufferType extends CacheBuffer<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, CheckpointMaintainerType>, PriorityCacheType extends PriorityCache<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, CheckpointMaintainerType, CacheBufferType>, CacheProviderType extends CacheProvider<RCFModelType, PriorityCacheType>, ResultType extends IndexableResult, RCFResultType extends IntermediateResult<ResultType>, ColdStarterType extends ModelColdStart<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType>, ModelManagerType extends ModelManager<RCFModelType, ResultType, RCFResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, ColdStarterType>, CacheType extends TimeSeriesCache<RCFModelType>, SaveResultStrategyType extends SaveResultStrategy<ResultType, RCFResultType>, ColdStartWorkerType extends ColdStartWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, ColdStarterType, CacheType, ResultType, RCFResultType, ModelManagerType, SaveResultStrategyType>, CheckpointReadWorkerType extends CheckpointReadWorker<RCFModelType, ResultType, RCFResultType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, ColdStarterType, ModelManagerType, CacheType, SaveResultStrategyType, ColdStartWorkerType>, ResultWriteRequestType extends ResultWriteRequest<ResultType>, BatchRequestType extends ResultBulkRequest<ResultType, ResultWriteRequestType>, ResultHandlerType extends IndexMemoryPressureAwareResultHandler<ResultType, ResultWriteRequestType, BatchRequestType, ResultBulkResponse, IndexType, IndexManagementType>, ResultWriteWorkerType extends ResultWriteWorker<ResultType, ResultWriteRequestType, BatchRequestType, IndexType, IndexManagementType, ResultHandlerType>>
extends HandledTransportAction<SingleStreamResultRequest, AcknowledgedResponse> {
    private static final Logger LOG = LogManager.getLogger(AbstractSingleStreamResultTransportAction.class);
    protected CircuitBreakerService circuitBreakerService;
    protected CacheProviderType cache;
    protected final NodeStateManager stateManager;
    protected CheckpointReadWorkerType checkpointReadQueue;
    protected ModelManagerType modelManager;
    protected IndexManagementType indexUtil;
    protected ResultWriteWorkerType resultWriteQueue;
    protected Stats stats;
    protected ColdStartWorkerType coldStartWorker;
    protected IndexType resultIndex;
    protected AnalysisType analysisType;
    private String modelCorrptionStat;

    public AbstractSingleStreamResultTransportAction(TransportService transportService, ActionFilters actionFilters, CircuitBreakerService circuitBreakerService, CacheProviderType cache, NodeStateManager stateManager, CheckpointReadWorkerType checkpointReadQueue, ModelManagerType modelManager, IndexManagementType indexUtil, ResultWriteWorkerType resultWriteQueue, Stats stats, ColdStartWorkerType coldStartQueue, String resultAction, IndexType resultIndex, AnalysisType analysisType, String modelCorrptionStat) {
        super(resultAction, transportService, actionFilters, SingleStreamResultRequest::new);
        this.circuitBreakerService = circuitBreakerService;
        this.cache = cache;
        this.stateManager = stateManager;
        this.checkpointReadQueue = checkpointReadQueue;
        this.modelManager = modelManager;
        this.indexUtil = indexUtil;
        this.resultWriteQueue = resultWriteQueue;
        this.stats = stats;
        this.coldStartWorker = coldStartQueue;
        this.resultIndex = resultIndex;
        this.analysisType = analysisType;
        this.modelCorrptionStat = modelCorrptionStat;
    }

    protected void doExecute(Task task, SingleStreamResultRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (this.circuitBreakerService.isOpen().booleanValue()) {
            listener.onFailure((Exception)new LimitExceededException(request.getConfigId(), "The total OpenSearch memory usage exceeds our threshold, opening the memory circuit.", false));
            return;
        }
        try {
            String configId = request.getConfigId();
            Optional<Exception> previousException = this.stateManager.fetchExceptionAndClear(configId);
            if (previousException.isPresent()) {
                EndRunException endRunException;
                Exception exception = previousException.get();
                LOG.error("Previous exception of {}: {}", (Object)configId, (Object)exception);
                if (exception instanceof EndRunException && (endRunException = (EndRunException)exception).isEndNow()) {
                    listener.onFailure(exception);
                    return;
                }
                listener = ExceptionUtil.wrapListener(listener, exception, configId);
            }
            this.stateManager.getConfig(configId, this.analysisType, this.onGetConfig(listener, configId, request, previousException));
        }
        catch (Exception exception) {
            LOG.error("fail to get result", (Throwable)exception);
            listener.onFailure(exception);
        }
    }

    public ActionListener<Optional<? extends Config>> onGetConfig(ActionListener<AcknowledgedResponse> listener, String configId, SingleStreamResultRequest request, Optional<Exception> prevException) {
        return ActionListener.wrap(configOptional -> {
            if (!configOptional.isPresent()) {
                listener.onFailure((Exception)new EndRunException(configId, "Config " + configId + " is not available.", false));
                return;
            }
            Config config = (Config)configOptional.get();
            Instant executionStartTime = Instant.now();
            String modelId = request.getModelId();
            double[] datapoint = request.getDataPoint();
            ModelState modelState = ((PriorityCache)((CacheProvider)this.cache).get()).get(modelId, config);
            if (modelState == null) {
                ((RateLimitedRequestWorker)this.checkpointReadQueue).put((FeatureRequest)new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, RequestPriority.MEDIUM, request.getModelId(), datapoint, request.getStart(), request.getTaskId()));
            } else {
                try {
                    Object result = ((ModelManager)this.modelManager).getResult(new Sample(datapoint, Instant.ofEpochMilli(request.getStart()), Instant.ofEpochMilli(request.getEnd())), modelState, modelId, config, request.getTaskId());
                    if (((IntermediateResult)result).getRcfScore() > 0.0) {
                        List indexableResults = ((IntermediateResult)result).toIndexableResults(config, Instant.ofEpochMilli(request.getStart()), Instant.ofEpochMilli(request.getEnd()), executionStartTime, Instant.now(), ParseUtils.getFeatureData(datapoint, config), Optional.empty(), ((IndexManagement)this.indexUtil).getSchemaVersion(this.resultIndex), modelId, null, null);
                        for (IndexableResult r : indexableResults) {
                            ((RateLimitedRequestWorker)this.resultWriteQueue).put(this.createResultWriteRequest(config, r));
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    LOG.error((Message)new ParameterizedMessage("Likely model corruption for [{}]", (Object)modelId), (Throwable)e);
                    this.stats.getStat(this.modelCorrptionStat).increment();
                    ((PriorityCache)((CacheProvider)this.cache).get()).removeModel(configId, modelId);
                    ((RateLimitedRequestWorker)this.coldStartWorker).put((FeatureRequest)new FeatureRequest(System.currentTimeMillis() + config.getIntervalInMilliseconds(), configId, RequestPriority.MEDIUM, modelId, datapoint, request.getStart(), request.getTaskId()));
                }
            }
            if (prevException.isPresent()) {
                listener.onFailure((Exception)prevException.get());
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }, exception -> {
            LOG.error((Message)new ParameterizedMessage("fail to get entity's result for config [{}]: start: [{}], end: [{}]", new Object[]{configId, request.getStart(), request.getEnd()}), (Throwable)exception);
            listener.onFailure(exception);
        });
    }

    public abstract ResultWriteRequestType createResultWriteRequest(Config var1, ResultType var2);
}

