/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.indices;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.ExceptionsHelper;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.rollover.RolloverRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsAction;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.cluster.LocalNodeClusterManagerListener;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.InjectSecurity;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.constant.CommonValue;
import org.opensearch.timeseries.function.BiCheckedFunction;
import org.opensearch.timeseries.function.ExecutorFunction;
import org.opensearch.timeseries.indices.TimeSeriesIndex;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.timeseries.util.RestHandlerUtils;

public abstract class IndexManagement<IndexType extends Enum<IndexType>>
implements LocalNodeClusterManagerListener {
    private static final Logger logger = LogManager.getLogger(IndexManagement.class);
    public static int minJobIndexReplicas = 1;
    public static int maxJobIndexReplicas = 20;
    public static final String META = "_meta";
    public static final String SCHEMA_VERSION = "schema_version";
    protected ClusterService clusterService;
    protected final Client client;
    protected final AdminClient adminClient;
    protected final ThreadPool threadPool;
    protected DiscoveryNodeFilterer nodeFilter;
    protected final Settings settings;
    protected final int maxUpdateRunningTimes;
    protected boolean allMappingUpdated;
    protected boolean allSettingUpdated;
    protected final AtomicBoolean updateRunning;
    protected int updateRunningTimes;
    private final Class<IndexType> indexType;
    protected EnumMap<IndexType, IndexState> indexStates;
    protected int maxPrimaryShards;
    private Scheduler.Cancellable scheduledRollover = null;
    protected volatile TimeValue historyRolloverPeriod;
    protected volatile Long historyMaxDocs;
    protected volatile TimeValue historyRetentionPeriod;
    private Map<String, Object> RESULT_FIELD_CONFIGS;
    private String resultMapping;
    private NamedXContentRegistry xContentRegistry;
    protected BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser;
    protected String customResultIndexPrefix;

    protected IndexManagement(Client client, ClusterService clusterService, ThreadPool threadPool, Settings settings, DiscoveryNodeFilterer nodeFilter, int maxUpdateRunningTimes, Class<IndexType> indexType, int maxPrimaryShards, TimeValue historyRolloverPeriod, Long historyMaxDocs, TimeValue historyRetentionPeriod, String resultMapping, NamedXContentRegistry xContentRegistry, BiCheckedFunction<XContentParser, String, ? extends Config, IOException> configParser, String customResultIndexPrefix) throws IOException {
        this.client = client;
        this.adminClient = client.admin();
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.clusterService.addLocalNodeClusterManagerListener((LocalNodeClusterManagerListener)this);
        this.nodeFilter = nodeFilter;
        this.settings = Settings.builder().put("index.hidden", true).build();
        this.maxUpdateRunningTimes = maxUpdateRunningTimes;
        this.indexType = indexType;
        this.maxPrimaryShards = maxPrimaryShards;
        this.historyRolloverPeriod = historyRolloverPeriod;
        this.historyMaxDocs = historyMaxDocs;
        this.historyRetentionPeriod = historyRetentionPeriod;
        this.allMappingUpdated = false;
        this.allSettingUpdated = false;
        this.updateRunning = new AtomicBoolean(false);
        this.updateRunningTimes = 0;
        this.resultMapping = resultMapping;
        this.xContentRegistry = xContentRegistry;
        this.configParser = configParser;
        this.customResultIndexPrefix = customResultIndexPrefix;
    }

    public boolean doesAliasExist(String alias) {
        return this.clusterService.state().metadata().hasAlias(alias);
    }

    public static Integer parseSchemaVersion(String mapping) {
        try {
            XContentParser xcp = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mapping);
            while (!xcp.isClosed()) {
                XContentParser.Token token = xcp.currentToken();
                if (token != null && token != XContentParser.Token.END_OBJECT && token != XContentParser.Token.START_OBJECT) {
                    if (xcp.currentName() != META) {
                        xcp.nextToken();
                        xcp.skipChildren();
                    } else {
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            if (xcp.currentName().equals(SCHEMA_VERSION)) {
                                Integer version = xcp.intValue();
                                if (version < 0) {
                                    version = CommonValue.NO_SCHEMA_VERSION;
                                }
                                return version;
                            }
                            xcp.nextToken();
                        }
                    }
                }
                xcp.nextToken();
            }
            return CommonValue.NO_SCHEMA_VERSION;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static Integer getIntegerSetting(GetSettingsResponse settingsResponse, String settingKey) {
        Settings settings;
        Integer value = null;
        Iterator iterator = settingsResponse.getIndexToSettings().values().iterator();
        while (iterator.hasNext() && (value = (settings = (Settings)iterator.next()).getAsInt(settingKey, null)) == null) {
        }
        return value;
    }

    protected static String getStringSetting(GetSettingsResponse settingsResponse, String settingKey) {
        Settings settings;
        String value = null;
        Iterator iterator = settingsResponse.getIndexToSettings().values().iterator();
        while (iterator.hasNext() && (value = (settings = (Settings)iterator.next()).get(settingKey, null)) == null) {
        }
        return value;
    }

    public boolean doesIndexExist(String indexName) {
        return this.clusterService.state().metadata().hasIndex(indexName);
    }

    protected static String getMappings(String mappingFileRelativePath) throws IOException {
        URL url = IndexManagement.class.getClassLoader().getResource(mappingFileRelativePath);
        return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
    }

    protected void choosePrimaryShards(CreateIndexRequest request, boolean hiddenIndex) {
        request.settings(Settings.builder().put("index.number_of_shards", this.getNumberOfPrimaryShards()).put("index.number_of_replicas", 1).put("index.hidden", hiddenIndex));
    }

    protected void deleteOldHistoryIndices(String indexPattern, TimeValue historyRetentionPeriod) {
        HashSet candidates = new HashSet();
        ClusterStateRequest clusterStateRequest = ((ClusterStateRequest)new ClusterStateRequest().clear().indices(new String[]{indexPattern}).metadata(true).local(true)).indicesOptions(IndicesOptions.strictExpand());
        this.adminClient.cluster().state(clusterStateRequest, ActionListener.wrap(clusterStateResponse -> {
            String latestToDelete = null;
            long latest = Long.MIN_VALUE;
            for (IndexMetadata indexMetaData : clusterStateResponse.getState().metadata().indices().values()) {
                long creationTime = indexMetaData.getCreationDate();
                long indexAgeMillis = Instant.now().toEpochMilli() - creationTime;
                if (indexAgeMillis <= historyRetentionPeriod.millis()) continue;
                String indexName = indexMetaData.getIndex().getName();
                candidates.add(indexName);
                if (latest >= creationTime) continue;
                latest = creationTime;
                latestToDelete = indexName;
            }
            if (candidates.size() > 1) {
                candidates.remove(latestToDelete);
                String[] toDelete = candidates.toArray(Strings.EMPTY_ARRAY);
                DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(toDelete);
                this.adminClient.indices().delete(deleteIndexRequest, ActionListener.wrap(deleteIndexResponse -> {
                    if (!deleteIndexResponse.isAcknowledged()) {
                        logger.error("Could not delete one or more result indices: {}. Retrying one by one.", (Object)Arrays.toString(toDelete));
                        this.deleteIndexIteration(toDelete);
                    } else {
                        logger.info("Succeeded in deleting expired result indices: {}.", (Object)Arrays.toString(toDelete));
                    }
                }, exception -> {
                    logger.error("Failed to delete expired result indices: {}.", (Object)Arrays.toString(toDelete));
                    this.deleteIndexIteration(toDelete);
                }));
            }
        }, exception -> logger.error("Fail to delete result indices", (Throwable)exception)));
    }

    protected void deleteIndexIteration(String[] toDelete) {
        for (String index : toDelete) {
            DeleteIndexRequest singleDeleteRequest = new DeleteIndexRequest(index);
            this.adminClient.indices().delete(singleDeleteRequest, ActionListener.wrap(singleDeleteResponse -> {
                if (!singleDeleteResponse.isAcknowledged()) {
                    logger.error("Retrying deleting {} does not succeed.", (Object)index);
                }
            }, exception -> {
                if (exception instanceof IndexNotFoundException) {
                    logger.info("{} was already deleted.", (Object)index);
                } else {
                    logger.error((Message)new ParameterizedMessage("Retrying deleting {} does not succeed.", (Object)index), (Throwable)exception);
                }
            }));
        }
    }

    protected void shouldUpdateConcreteIndex(String concreteIndex, Integer newVersion, ActionListener<Boolean> thenDo) {
        Map metaMapping;
        Object schemaVersion;
        IndexMetadata indexMeataData = (IndexMetadata)this.clusterService.state().getMetadata().indices().get(concreteIndex);
        if (indexMeataData == null) {
            thenDo.onResponse((Object)Boolean.FALSE);
            return;
        }
        Integer oldVersion = CommonValue.NO_SCHEMA_VERSION;
        Map indexMapping = indexMeataData.mapping().getSourceAsMap();
        Object meta = indexMapping.get(META);
        if (meta != null && meta instanceof Map && (schemaVersion = (metaMapping = (Map)meta).get(SCHEMA_VERSION)) instanceof Integer) {
            oldVersion = (Integer)schemaVersion;
        }
        thenDo.onResponse((Object)(newVersion > oldVersion ? 1 : 0));
    }

    protected void updateJobIndexSettingIfNecessary(String indexName, IndexState jobIndexState, ActionListener<Void> listener) {
        GetSettingsRequest getSettingsRequest = new GetSettingsRequest().indices(new String[]{indexName}).names(new String[]{"index.number_of_shards", "index.number_of_replicas", "index.auto_expand_replicas"});
        this.client.execute((ActionType)GetSettingsAction.INSTANCE, (ActionRequest)getSettingsRequest, ActionListener.wrap(settingResponse -> {
            String autoExpandReplica = IndexManagement.getStringSetting(settingResponse, "index.auto_expand_replicas");
            if (autoExpandReplica != null) {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s setting up-to-date", (Object)indexName));
                listener.onResponse(null);
                return;
            }
            Integer primaryShardsNumber = IndexManagement.getIntegerSetting(settingResponse, "index.number_of_shards");
            Integer replicaNumber = IndexManagement.getIntegerSetting(settingResponse, "index.number_of_replicas");
            if (primaryShardsNumber == null || replicaNumber == null) {
                logger.error((Message)new ParameterizedMessage("Fail to find job index's primary or replica shard number: primary [{}], replica [{}]", (Object)primaryShardsNumber, (Object)replicaNumber));
                listener.onResponse(null);
                return;
            }
            int maxExpectedReplicas = Math.max(maxJobIndexReplicas / primaryShardsNumber, minJobIndexReplicas);
            Settings updatedSettings = Settings.builder().put("index.auto_expand_replicas", minJobIndexReplicas + "-" + maxExpectedReplicas).build();
            UpdateSettingsRequest updateSettingsRequest = new UpdateSettingsRequest(new String[]{indexName}).settings(updatedSettings);
            this.client.admin().indices().updateSettings(updateSettingsRequest, ActionListener.wrap(response -> {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s setting up-to-date", (Object)indexName));
                listener.onResponse(null);
            }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                jobIndexState.settingUpToDate = true;
                logger.info((Message)new ParameterizedMessage("Mark [{}]'s setting up-to-date", (Object)indexName));
                listener.onResponse(null);
            } else {
                listener.onFailure(e);
            }
        }));
    }

    public void initConfigIndexIfAbsent(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        if (!this.doesConfigIndexExist()) {
            this.initConfigIndex(actionListener);
        }
    }

    public void initConfigIndex(ActionListener<CreateIndexResponse> actionListener) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detectors").mapping(IndexManagement.getConfigMappings(), XContentType.JSON).settings(this.settings);
        this.adminClient.indices().create(request, actionListener);
    }

    public boolean doesConfigIndexExist() {
        return this.doesIndexExist(".opendistro-anomaly-detectors");
    }

    public boolean doesJobIndexExist() {
        return this.doesIndexExist(".opendistro-anomaly-detector-jobs");
    }

    public static String getConfigMappings() throws IOException {
        return IndexManagement.getMappings("mappings/config.json");
    }

    public static String getJobMappings() throws IOException {
        return IndexManagement.getMappings("mappings/job.json");
    }

    public void initJobIndex(ActionListener<CreateIndexResponse> actionListener) {
        try {
            CreateIndexRequest request = new CreateIndexRequest(".opendistro-anomaly-detector-jobs").mapping(IndexManagement.getJobMappings(), XContentType.JSON);
            request.settings(Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", minJobIndexReplicas + "-" + maxJobIndexReplicas).put("index.hidden", true));
            this.adminClient.indices().create(request, actionListener);
        }
        catch (IOException e) {
            logger.error("Fail to init AD job index", (Throwable)e);
            actionListener.onFailure((Exception)e);
        }
    }

    public <T> void validateResultIndexAndExecute(String resultIndexOrAlias, ExecutorFunction function, boolean mappingValidated, ActionListener<T> listener) {
        if (!mappingValidated) {
            this.validateResultIndexMapping(resultIndexOrAlias, (ActionListener<Boolean>)ActionListener.wrap(validMapping -> {
                if (validMapping.booleanValue()) {
                    this.executeAfterValidateResultIndexMapping(resultIndexOrAlias, function, listener);
                } else {
                    logger.warn("Can't create analysis with custom result index {} as its mapping is invalid", (Object)resultIndexOrAlias);
                    listener.onFailure((Exception)new IllegalArgumentException(CommonMessages.INVALID_RESULT_INDEX_MAPPING + resultIndexOrAlias));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            try {
                this.executeAfterValidateResultIndexMapping(resultIndexOrAlias, function, listener);
            }
            catch (Exception e) {
                logger.error("Failed to validate custom result index " + resultIndexOrAlias, (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private <T> void executeAfterValidateResultIndexMapping(String resultIndexOrAlias, ExecutorFunction function, ActionListener<T> listener) throws IOException {
        IndexRequest indexRequest = this.createDummyIndexRequest(resultIndexOrAlias);
        this.client.index(indexRequest, ActionListener.wrap(response -> {
            logger.debug("Successfully wrote dummy result to result index {}", (Object)resultIndexOrAlias);
            this.client.delete(this.createDummyDeleteRequest(resultIndexOrAlias), ActionListener.wrap(deleteResponse -> {
                logger.debug("Successfully deleted dummy result from result index {}", (Object)resultIndexOrAlias);
                function.execute();
            }, ex -> {
                logger.error("Failed to delete dummy result from result index " + resultIndexOrAlias, (Throwable)ex);
                listener.onFailure(ex);
            }));
        }, exception -> {
            logger.error("Failed to write dummy result to result index " + resultIndexOrAlias, (Throwable)exception);
            listener.onFailure(exception);
        }));
    }

    public void update() {
        if (this.allMappingUpdated && this.allSettingUpdated || this.updateRunningTimes >= this.maxUpdateRunningTimes || this.updateRunning.get()) {
            return;
        }
        this.updateRunning.set(true);
        ++this.updateRunningTimes;
        GroupedActionListener groupListeneer = new GroupedActionListener(ActionListener.wrap(r -> this.updateRunning.set(false), exception -> {
            this.updateRunning.set(false);
            logger.error("Fail to update time series indices", (Throwable)exception);
        }), 2);
        this.updateMappingIfNecessary((GroupedActionListener<Void>)groupListeneer);
        this.updateSettingIfNecessary((GroupedActionListener<Void>)groupListeneer);
    }

    private void updateSettingIfNecessary(GroupedActionListener<Void> delegateListeneer) {
        if (this.allSettingUpdated) {
            delegateListeneer.onResponse(null);
            return;
        }
        ArrayList<Enum> updates = new ArrayList<Enum>();
        for (Enum index : (Enum[])this.indexType.getEnumConstants()) {
            Boolean updated = this.indexStates.computeIfAbsent(index, (Function<Enum, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateSettingIfNecessary$16(java.lang.Enum ), (Ljava/lang/Enum;)Lorg/opensearch/timeseries/indices/IndexManagement$IndexState;)((IndexManagement)this)).settingUpToDate;
            if (!Boolean.FALSE.equals(updated)) continue;
            updates.add(index);
        }
        if (updates.size() == 0) {
            this.allSettingUpdated = true;
            delegateListeneer.onResponse(null);
            return;
        }
        GroupedActionListener conglomerateListeneer = new GroupedActionListener(ActionListener.wrap(r -> delegateListeneer.onResponse(null), exception -> {
            delegateListeneer.onResponse(null);
            logger.error("Fail to update time series indices' settings", (Throwable)exception);
        }), updates.size());
        for (Enum timeseriesIndex : updates) {
            logger.info((Message)new ParameterizedMessage("Check [{}]'s setting", (Object)((TimeSeriesIndex)((Object)timeseriesIndex)).getIndexName()));
            if (((TimeSeriesIndex)((Object)timeseriesIndex)).isJobIndex() && this.doesIndexExist(((TimeSeriesIndex)((Object)timeseriesIndex)).getIndexName())) {
                this.updateJobIndexSettingIfNecessary(((TimeSeriesIndex)((Object)timeseriesIndex)).getIndexName(), this.indexStates.computeIfAbsent(timeseriesIndex, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping())), (ActionListener<Void>)conglomerateListeneer);
                continue;
            }
            IndexState indexState = this.indexStates.computeIfAbsent(timeseriesIndex, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping()));
            indexState.settingUpToDate = true;
            logger.info((Message)new ParameterizedMessage("Mark [{}]'s setting up-to-date", (Object)((TimeSeriesIndex)((Object)timeseriesIndex)).getIndexName()));
            conglomerateListeneer.onResponse(null);
        }
    }

    private void updateMappingIfNecessary(GroupedActionListener<Void> delegateListeneer) {
        if (this.allMappingUpdated) {
            delegateListeneer.onResponse(null);
            return;
        }
        ArrayList<Enum> updates = new ArrayList<Enum>();
        for (Enum index : (Enum[])this.indexType.getEnumConstants()) {
            Boolean updated = this.indexStates.computeIfAbsent(index, (Function<Enum, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateMappingIfNecessary$21(java.lang.Enum ), (Ljava/lang/Enum;)Lorg/opensearch/timeseries/indices/IndexManagement$IndexState;)((IndexManagement)this)).mappingUpToDate;
            if (!Boolean.FALSE.equals(updated)) continue;
            updates.add(index);
        }
        if (updates.size() == 0) {
            this.allMappingUpdated = true;
            delegateListeneer.onResponse(null);
            return;
        }
        GroupedActionListener conglomerateListeneer = new GroupedActionListener(ActionListener.wrap(r -> delegateListeneer.onResponse(null), exception -> {
            delegateListeneer.onResponse(null);
            logger.error("Fail to update time series indices' mappings", (Throwable)exception);
        }), updates.size());
        for (Enum index : updates) {
            if (((TimeSeriesIndex)((Object)index)).isCustomResultIndex()) {
                this.updateCustomResultIndexMapping(index, (GroupedActionListener<Void>)conglomerateListeneer);
                continue;
            }
            logger.info((Message)new ParameterizedMessage("Check [{}]'s mapping", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()));
            this.shouldUpdateIndex(index, (ActionListener<Boolean>)ActionListener.wrap(shouldUpdate -> {
                if (shouldUpdate.booleanValue()) {
                    this.adminClient.indices().putMapping(new PutMappingRequest().indices(new String[]{((TimeSeriesIndex)((Object)index)).getIndexName()}).source(((TimeSeriesIndex)((Object)index)).getMapping(), (MediaType)XContentType.JSON), ActionListener.wrap(putMappingResponse -> {
                        if (putMappingResponse.isAcknowledged()) {
                            logger.info((Message)new ParameterizedMessage("Succeeded in updating [{}]'s mapping", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()));
                            this.markMappingUpdated(index);
                        } else {
                            logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()));
                        }
                        conglomerateListeneer.onResponse(null);
                    }, exception -> {
                        logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping due to [{}]", (Object)((TimeSeriesIndex)((Object)index)).getIndexName(), (Object)exception.getMessage()));
                        conglomerateListeneer.onFailure(exception);
                    }));
                } else {
                    logger.info((Message)new ParameterizedMessage("We don't need to update [{}]'s mapping", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()));
                    this.markMappingUpdated(index);
                    conglomerateListeneer.onResponse(null);
                }
            }, exception -> {
                logger.error((Message)new ParameterizedMessage("Fail to check whether we should update [{}]'s mapping", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()), (Throwable)exception);
                conglomerateListeneer.onFailure(exception);
            }));
        }
    }

    private void updateCustomResultIndexMapping(IndexType customIndex, GroupedActionListener<Void> delegateListeneer) {
        this.getConfigsWithCustomResultIndexAlias((ActionListener<List<Config>>)ActionListener.wrap(candidateResultAliases -> {
            if (candidateResultAliases == null || candidateResultAliases.size() == 0) {
                logger.info("candidate custom result indices are empty.");
                this.markMappingUpdated(customIndex);
                delegateListeneer.onResponse(null);
                return;
            }
            GroupedActionListener customIndexMappingUpdateListener = new GroupedActionListener(ActionListener.wrap(mappingUpdateResponse -> {
                this.markMappingUpdated(customIndex);
                delegateListeneer.onResponse(null);
            }, exception -> {
                delegateListeneer.onResponse(null);
                logger.error("Fail to update result indices' mappings", (Throwable)exception);
            }), candidateResultAliases.size());
            this.processResultIndexMappingIteration(0, this.getSchemaVersion(customIndex), ((TimeSeriesIndex)((Object)customIndex)).getMapping(), (List<Config>)candidateResultAliases, (GroupedActionListener<Void>)customIndexMappingUpdateListener);
        }, e -> delegateListeneer.onFailure((Exception)new TimeSeriesException("Fail to update custom result indices' mapping.", (Throwable)e))));
    }

    private void getConfigsWithCustomResultIndexAlias(ActionListener<List<Config>> listener) {
        Enum configIndex = null;
        for (Enum timeseriesIndex : (Enum[])this.indexType.getEnumConstants()) {
            if (!((TimeSeriesIndex)((Object)timeseriesIndex)).isConfigIndex() || !this.doesIndexExist(((TimeSeriesIndex)((Object)timeseriesIndex)).getIndexName())) continue;
            configIndex = timeseriesIndex;
            break;
        }
        if (configIndex == null || ((TimeSeriesIndex)((Object)configIndex)).getIndexName() == null) {
            listener.onResponse(new ArrayList());
            return;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder shouldQueries = new BoolQueryBuilder();
        shouldQueries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"result_index", (String)(this.customResultIndexPrefix + "*")));
        if (!shouldQueries.should().isEmpty()) {
            boolQuery.filter((QueryBuilder)shouldQueries);
        }
        SearchRequest searchRequest = new SearchRequest().indices(new String[]{((TimeSeriesIndex)((Object)configIndex)).getIndexName()}).source(new SearchSourceBuilder().size(10000).query((QueryBuilder)boolQuery));
        this.client.search(searchRequest, ActionListener.wrap(r -> {
            if (r == null || r.getHits().getTotalHits() == null || r.getHits().getTotalHits().value == 0L) {
                logger.info("no config available.");
                listener.onResponse(new ArrayList());
                return;
            }
            Iterator iterator = r.getHits().iterator();
            ArrayList<Config> candidateConfigs = new ArrayList<Config>();
            while (iterator.hasNext()) {
                SearchHit searchHit = (SearchHit)iterator.next();
                try {
                    XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, searchHit.getSourceRef());
                    try {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        Config config = this.configParser.apply(parser, searchHit.getId());
                        String indexOrAlias = config.getCustomResultIndexOrAlias();
                        if (!this.doesAliasExist(indexOrAlias)) continue;
                        candidateConfigs.add(config);
                    }
                    finally {
                        if (parser == null) continue;
                        parser.close();
                    }
                }
                catch (Exception e) {
                    logger.error("failed to parse config " + searchHit.getId(), (Throwable)e);
                }
            }
            listener.onResponse(candidateConfigs);
        }, e -> listener.onFailure((Exception)new TimeSeriesException("Fail to update custom result indices' mapping.", (Throwable)e))));
    }

    private void processResultIndexMappingIteration(int indexPos, Integer newestSchemaVersion, String mappingSource, List<Config> candidateResultIndices, GroupedActionListener<Void> conglomerateListeneer) {
        if (indexPos >= candidateResultIndices.size()) {
            return;
        }
        String index = candidateResultIndices.get(indexPos).getCustomResultIndexOrAlias();
        logger.info((Message)new ParameterizedMessage("Check [{}]'s mapping", (Object)index));
        this.shouldUpdateIndex(index, true, newestSchemaVersion, (ActionListener<Boolean>)ActionListener.wrap(shouldUpdate -> {
            if (shouldUpdate.booleanValue()) {
                this.adminClient.indices().putMapping(new PutMappingRequest().indices(new String[]{index}).source(mappingSource, (MediaType)XContentType.JSON), ActionListener.wrap(putMappingResponse -> {
                    if (putMappingResponse.isAcknowledged()) {
                        logger.info((Message)new ParameterizedMessage("Succeeded in updating [{}]'s mapping", (Object)index));
                    } else {
                        logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping", (Object)index));
                    }
                    conglomerateListeneer.onResponse(null);
                    this.processResultIndexMappingIteration(indexPos + 1, newestSchemaVersion, mappingSource, candidateResultIndices, conglomerateListeneer);
                }, exception -> {
                    logger.error((Message)new ParameterizedMessage("Fail to update [{}]'s mapping due to [{}]", (Object)index, (Object)exception.getMessage()));
                    conglomerateListeneer.onFailure(exception);
                    this.processResultIndexMappingIteration(indexPos + 1, newestSchemaVersion, mappingSource, candidateResultIndices, conglomerateListeneer);
                }));
            } else {
                logger.info((Message)new ParameterizedMessage("We don't need to update [{}]'s mapping", (Object)index));
                conglomerateListeneer.onResponse(null);
                this.processResultIndexMappingIteration(indexPos + 1, newestSchemaVersion, mappingSource, candidateResultIndices, conglomerateListeneer);
            }
        }, exception -> {
            logger.error((Message)new ParameterizedMessage("Fail to check whether we should update [{}]'s mapping", (Object)index), (Throwable)exception);
            conglomerateListeneer.onFailure(exception);
            this.processResultIndexMappingIteration(indexPos + 1, newestSchemaVersion, mappingSource, candidateResultIndices, conglomerateListeneer);
        }));
    }

    private void markMappingUpdated(IndexType adIndex) {
        IndexState indexState = this.indexStates.computeIfAbsent(adIndex, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping()));
        if (Boolean.FALSE.equals(indexState.mappingUpToDate)) {
            indexState.mappingUpToDate = Boolean.TRUE;
            logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)((TimeSeriesIndex)adIndex).getIndexName()));
        }
    }

    private void shouldUpdateIndex(IndexType index, ActionListener<Boolean> thenDo) {
        Integer newVersion = this.indexStates.computeIfAbsent(index, (Function<Enum, IndexState>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$shouldUpdateIndex$39(java.lang.Enum ), (Ljava/lang/Enum;)Lorg/opensearch/timeseries/indices/IndexManagement$IndexState;)((IndexManagement)this)).schemaVersion;
        this.shouldUpdateIndex(((TimeSeriesIndex)index).getIndexName(), ((TimeSeriesIndex)index).isAlias(), newVersion, thenDo);
    }

    private void shouldUpdateIndex(String indexOrAliasName, boolean isAlias, Integer newVersion, ActionListener<Boolean> thenDo) {
        boolean exists = false;
        exists = isAlias ? this.doesAliasExist(indexOrAliasName) : this.doesIndexExist(indexOrAliasName);
        if (!exists) {
            thenDo.onResponse((Object)Boolean.FALSE);
            return;
        }
        if (isAlias) {
            GetAliasesRequest getAliasRequest = new GetAliasesRequest().aliases(new String[]{indexOrAliasName}).indicesOptions(IndicesOptions.lenientExpandOpenHidden());
            this.adminClient.indices().getAliases(getAliasRequest, ActionListener.wrap(getAliasResponse -> {
                String concreteIndex = null;
                for (Map.Entry entry : getAliasResponse.getAliases().entrySet()) {
                    if (((List)entry.getValue()).isEmpty()) continue;
                    concreteIndex = (String)entry.getKey();
                    break;
                }
                if (concreteIndex == null) {
                    thenDo.onResponse((Object)Boolean.FALSE);
                    return;
                }
                this.shouldUpdateConcreteIndex(concreteIndex, newVersion, thenDo);
            }, exception -> logger.error((Message)new ParameterizedMessage("Fail to get [{}]'s alias", (Object)indexOrAliasName), (Throwable)exception)));
        } else {
            this.shouldUpdateConcreteIndex(indexOrAliasName, newVersion, thenDo);
        }
    }

    protected void getConcreteIndex(String indexOrAliasName, ActionListener<String> thenDo) {
        if (this.doesAliasExist(indexOrAliasName)) {
            GetAliasesRequest getAliasRequest = new GetAliasesRequest().aliases(new String[]{indexOrAliasName}).indicesOptions(IndicesOptions.lenientExpandOpenHidden());
            this.adminClient.indices().getAliases(getAliasRequest, ActionListener.wrap(getAliasResponse -> {
                String concreteIndex = null;
                for (Map.Entry entry : getAliasResponse.getAliases().entrySet()) {
                    if (((List)entry.getValue()).isEmpty()) continue;
                    concreteIndex = (String)entry.getKey();
                    break;
                }
                thenDo.onResponse(concreteIndex);
            }, exception -> logger.error((Message)new ParameterizedMessage("Fail to get [{}]'s alias", (Object)indexOrAliasName), (Throwable)exception)));
        } else {
            thenDo.onResponse((Object)indexOrAliasName);
        }
    }

    public int getSchemaVersion(IndexType index) {
        IndexState indexState = this.indexStates.computeIfAbsent(index, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping()));
        return indexState.schemaVersion;
    }

    public <T> void initCustomResultIndexAndExecute(String resultIndexOrAlias, ExecutorFunction function, ActionListener<T> listener) {
        if (!this.doesIndexExist(resultIndexOrAlias) && !this.doesAliasExist(resultIndexOrAlias)) {
            this.initCustomResultIndexDirectly(resultIndexOrAlias, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    logger.info("Successfully created result index {}", (Object)resultIndexOrAlias);
                    this.validateResultIndexAndExecute(resultIndexOrAlias, function, false, listener);
                } else {
                    String error = "Creating result index with mappings call not acknowledged: " + resultIndexOrAlias;
                    logger.error(error);
                    listener.onFailure((Exception)new EndRunException(error, false));
                }
            }, exception -> {
                if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                    this.validateResultIndexAndExecute(resultIndexOrAlias, function, false, listener);
                } else {
                    logger.error("Failed to create result index " + resultIndexOrAlias, (Throwable)exception);
                    listener.onFailure(exception);
                }
            }));
        } else {
            this.validateResultIndexAndExecute(resultIndexOrAlias, function, false, listener);
        }
    }

    public <T> void validateCustomIndexForBackendJob(String resultIndexOrAlias, String securityLogId, String user, List<String> roles, ExecutorFunction function, ActionListener<T> listener) {
        if (!this.doesIndexExist(resultIndexOrAlias) && !this.doesAliasExist(resultIndexOrAlias)) {
            this.initCustomResultIndexDirectly(resultIndexOrAlias, (ActionListener<CreateIndexResponse>)ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.executeOnCustomIndex(resultIndexOrAlias, securityLogId, user, roles, function, listener);
                } else {
                    String error = "Creating custom result index with mappings call not acknowledged";
                    logger.error(error);
                    listener.onFailure((Exception)new TimeSeriesException(error));
                }
            }, exception -> {
                if (ExceptionsHelper.unwrapCause((Throwable)exception) instanceof ResourceAlreadyExistsException) {
                    this.executeOnCustomIndex(resultIndexOrAlias, securityLogId, user, roles, function, listener);
                } else {
                    listener.onFailure(exception);
                }
            }));
        } else {
            this.validateResultIndexMapping(resultIndexOrAlias, (ActionListener<Boolean>)ActionListener.wrap(validMapping -> {
                if (validMapping.booleanValue()) {
                    this.executeOnCustomIndex(resultIndexOrAlias, securityLogId, user, roles, function, listener);
                } else {
                    listener.onFailure((Exception)new EndRunException("Result index mapping is not correct", true));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private <T> void executeOnCustomIndex(String resultIndexOrAlias, String securityLogId, String user, List<String> roles, ExecutorFunction function, ActionListener<T> listener) {
        try (InjectSecurity injectSecurity = new InjectSecurity(securityLogId, this.settings, this.client.threadPool().getThreadContext());){
            injectSecurity.inject(user, roles);
            ActionListener wrappedListener = ActionListener.wrap(r -> listener.onResponse(r), e -> {
                injectSecurity.close();
                listener.onFailure(e);
            });
            this.validateResultIndexAndExecute(resultIndexOrAlias, () -> {
                injectSecurity.close();
                function.execute();
            }, true, wrappedListener);
        }
        catch (Exception e2) {
            logger.error("Failed to validate custom index for backend job " + securityLogId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    protected int getNumberOfPrimaryShards() {
        return Math.min(this.nodeFilter.getNumberOfEligibleDataNodes(), this.maxPrimaryShards);
    }

    public void onClusterManager() {
        try {
            this.rolloverAndDeleteHistoryIndex();
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteHistoryIndex(), this.historyRolloverPeriod, this.executorName());
        }
        catch (Exception e) {
            logger.error("Error rollover result indices. Can't rollover result until clusterManager node is restarted.", (Throwable)e);
        }
    }

    public void offClusterManager() {
        if (this.scheduledRollover != null) {
            this.scheduledRollover.cancel();
        }
    }

    private String executorName() {
        return "management";
    }

    protected void rescheduleRollover() {
        if (this.clusterService.state().getNodes().isLocalNodeElectedClusterManager()) {
            if (this.scheduledRollover != null) {
                this.scheduledRollover.cancel();
            }
            this.scheduledRollover = this.threadPool.scheduleWithFixedDelay(() -> this.rolloverAndDeleteHistoryIndex(), this.historyRolloverPeriod, this.executorName());
        }
    }

    private void initResultMapping() throws IOException {
        if (this.RESULT_FIELD_CONFIGS != null) {
            return;
        }
        Map asMap = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(this.resultMapping), (boolean)false, (XContentType)XContentType.JSON).v2();
        Object properties = asMap.get("properties");
        if (properties instanceof Map) {
            this.RESULT_FIELD_CONFIGS = (Map)properties;
        } else {
            logger.error("Fail to read result mapping file.");
        }
    }

    public void validateResultIndexMapping(String resultIndexOrAlias, ActionListener<Boolean> thenDo) {
        this.getConcreteIndex(resultIndexOrAlias, (ActionListener<String>)ActionListener.wrap(concreteIndex -> {
            try {
                String propertyName;
                IndexMetadata indexMetadata;
                Map indexMapping;
                this.initResultMapping();
                if (this.RESULT_FIELD_CONFIGS == null) {
                    thenDo.onResponse((Object)false);
                }
                if (!(indexMapping = (indexMetadata = this.clusterService.state().metadata().index(concreteIndex)).mapping().sourceAsMap()).containsKey(propertyName = "properties") || !(indexMapping.get(propertyName) instanceof LinkedHashMap)) {
                    thenDo.onResponse((Object)false);
                }
                LinkedHashMap mapping = (LinkedHashMap)indexMapping.get(propertyName);
                boolean correctResultIndexMapping = true;
                for (String fieldName : this.RESULT_FIELD_CONFIGS.keySet()) {
                    Object defaultSchema = this.RESULT_FIELD_CONFIGS.get(fieldName);
                    if (!mapping.containsKey(fieldName)) {
                        logger.warn("mapping mismatch due to missing {}", (Object)fieldName);
                        correctResultIndexMapping = false;
                        break;
                    }
                    Object actualSchema = mapping.get(fieldName);
                    if (this.isSchemaSuperset(actualSchema, defaultSchema)) continue;
                    logger.warn("mapping mismatch due to {}", (Object)fieldName);
                    correctResultIndexMapping = false;
                    break;
                }
                thenDo.onResponse((Object)correctResultIndexMapping);
            }
            catch (Exception e) {
                logger.error("Failed to validate result index mapping for index " + concreteIndex, (Throwable)e);
                thenDo.onResponse((Object)false);
            }
        }, arg_0 -> thenDo.onFailure(arg_0)));
    }

    private boolean isSchemaSuperset(Object schema1, Object schema2) {
        if (schema1 == schema2) {
            return true;
        }
        if (schema1 == null || schema2 == null) {
            return false;
        }
        if (schema1 instanceof Map && schema2 instanceof Map) {
            Map map1 = (Map)schema1;
            Map map2 = (Map)schema2;
            for (Map.Entry entry : map2.entrySet()) {
                Object key = entry.getKey();
                if (!map1.containsKey(key)) {
                    return false;
                }
                if (this.isSchemaSuperset(map1.get(key), entry.getValue())) continue;
                return false;
            }
            return true;
        }
        return schema1.equals(schema2);
    }

    public void initDefaultResultIndexIfAbsent(ActionListener<CreateIndexResponse> actionListener) {
        if (!this.doesDefaultResultIndexExist()) {
            this.initDefaultResultIndexDirectly(actionListener);
        }
    }

    protected ActionListener<CreateIndexResponse> markMappingUpToDate(IndexType index, ActionListener<CreateIndexResponse> followingListener) {
        return ActionListener.wrap(createdResponse -> {
            if (createdResponse.isAcknowledged()) {
                IndexState indexStatetate = this.indexStates.computeIfAbsent(index, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping()));
                if (Boolean.FALSE.equals(indexStatetate.mappingUpToDate)) {
                    indexStatetate.mappingUpToDate = Boolean.TRUE;
                    logger.info((Message)new ParameterizedMessage("Mark [{}]'s mapping up-to-date", (Object)((TimeSeriesIndex)((Object)index)).getIndexName()));
                }
            }
            followingListener.onResponse(createdResponse);
        }, exception -> followingListener.onFailure(exception));
    }

    protected void rolloverAndDeleteHistoryIndex(String resultIndexAlias, String allResultIndicesPattern, String rolloverIndexPattern, IndexType resultIndex) {
        if (this.doesDefaultResultIndexExist()) {
            RolloverRequest defaultResultIndexRolloverRequest = this.buildRolloverRequest(resultIndexAlias, rolloverIndexPattern);
            defaultResultIndexRolloverRequest.addMaxIndexDocsCondition(this.historyMaxDocs * (long)this.getNumberOfPrimaryShards());
            this.proceedWithDefaultRolloverAndDelete(resultIndexAlias, defaultResultIndexRolloverRequest, allResultIndicesPattern, resultIndex);
        }
        this.getConfigsWithCustomResultIndexAlias((ActionListener<List<Config>>)ActionListener.wrap(candidateResultAliases -> {
            if (candidateResultAliases == null || candidateResultAliases.isEmpty()) {
                logger.info("Candidate custom result indices are empty.");
                return;
            }
            candidateResultAliases.forEach(config -> this.handleCustomResultIndex((Config)config, resultIndex));
        }, e -> logger.error("Failed to get configs with custom result index alias.", (Throwable)e)));
    }

    private void handleCustomResultIndex(Config config, IndexType resultIndex) {
        RolloverRequest rolloverRequest = this.buildRolloverRequest(config.getCustomResultIndexOrAlias(), this.getCustomResultIndexPattern(config.getCustomResultIndexOrAlias()));
        if (config.getCustomResultIndexMinAge() != null) {
            rolloverRequest.addMaxIndexAgeCondition(TimeValue.timeValueDays((long)config.getCustomResultIndexMinAge().intValue()));
        }
        if (config.getCustomResultIndexMinSize() != null) {
            rolloverRequest.addMaxIndexSizeCondition(new ByteSizeValue((long)config.getCustomResultIndexMinSize().intValue(), ByteSizeUnit.MB));
        }
        this.proceedWithRolloverAndDelete(config.getCustomResultIndexOrAlias(), rolloverRequest, IndexManagement.getAllCustomResultIndexPattern(config.getCustomResultIndexOrAlias()), resultIndex, config.getCustomResultIndexTTL());
    }

    private void proceedWithDefaultRolloverAndDelete(String resultIndexAlias, RolloverRequest rolloverRequest, String allResultIndicesPattern, IndexType resultIndex) {
        this.proceedWithRolloverAndDelete(resultIndexAlias, rolloverRequest, allResultIndicesPattern, resultIndex, null);
    }

    private RolloverRequest buildRolloverRequest(String resultIndexAlias, String rolloverIndexPattern) {
        RolloverRequest rollOverRequest = new RolloverRequest(resultIndexAlias, null);
        CreateIndexRequest createRequest = rollOverRequest.getCreateIndexRequest();
        createRequest.index(rolloverIndexPattern).mapping(this.resultMapping, XContentType.JSON);
        if (resultIndexAlias.startsWith(this.customResultIndexPrefix)) {
            this.choosePrimaryShards(createRequest, false);
        } else {
            this.choosePrimaryShards(createRequest, true);
        }
        return rollOverRequest;
    }

    private void proceedWithRolloverAndDelete(String resultIndexAlias, RolloverRequest rollOverRequest, String allResultIndicesPattern, IndexType resultIndex, Integer customResultIndexTtl) {
        if (rollOverRequest.getConditions().size() == 0) {
            return;
        }
        this.adminClient.indices().rolloverIndex(rollOverRequest, ActionListener.wrap(response -> {
            if (!response.isRolledOver()) {
                logger.warn("{} not rolled over. Conditions were: {}", (Object)resultIndexAlias, (Object)response.getConditionStatus());
            } else {
                IndexState indexState = this.indexStates.computeIfAbsent(resultIndex, k -> new IndexState(((TimeSeriesIndex)((Object)k)).getMapping()));
                indexState.mappingUpToDate = true;
                logger.info("{} rolled over. Conditions were: {}", (Object)resultIndexAlias, (Object)response.getConditionStatus());
                if (resultIndexAlias.startsWith(this.customResultIndexPrefix)) {
                    if (customResultIndexTtl != null) {
                        this.deleteOldHistoryIndices(allResultIndicesPattern, TimeValue.timeValueHours((long)(customResultIndexTtl * 24)));
                    }
                } else {
                    this.deleteOldHistoryIndices(allResultIndicesPattern, this.historyRetentionPeriod);
                }
            }
        }, exception -> logger.error("Fail to roll over result index", (Throwable)exception)));
    }

    protected void initResultIndexDirectly(String resultIndexName, String alias, boolean hiddenIndex, boolean defaultResultIndex, IndexType resultIndex, ActionListener<CreateIndexResponse> actionListener) {
        CreateIndexRequest request = new CreateIndexRequest(resultIndexName).mapping(this.resultMapping, XContentType.JSON);
        if (alias != null) {
            request.alias(new Alias(alias));
        }
        this.choosePrimaryShards(request, hiddenIndex);
        if (defaultResultIndex) {
            this.adminClient.indices().create(request, this.markMappingUpToDate(resultIndex, actionListener));
        } else {
            this.adminClient.indices().create(request, actionListener);
        }
    }

    protected String getCustomResultIndexPattern(String customResultIndexAlias) {
        return String.format(Locale.ROOT, "<%s-history-{now/d}-1>", customResultIndexAlias);
    }

    public static String getAllCustomResultIndexPattern(String customResultIndexAlias) {
        return String.format(Locale.ROOT, "%s*", customResultIndexAlias);
    }

    public abstract boolean doesCheckpointIndexExist();

    public abstract void initCheckpointIndex(ActionListener<CreateIndexResponse> var1);

    public abstract boolean doesDefaultResultIndexExist();

    public abstract boolean doesStateIndexExist();

    public abstract void initDefaultResultIndexDirectly(ActionListener<CreateIndexResponse> var1);

    protected abstract IndexRequest createDummyIndexRequest(String var1) throws IOException;

    protected abstract DeleteRequest createDummyDeleteRequest(String var1) throws IOException;

    protected abstract void rolloverAndDeleteHistoryIndex();

    public abstract void initCustomResultIndexDirectly(String var1, ActionListener<CreateIndexResponse> var2);

    public abstract void initStateIndex(ActionListener<CreateIndexResponse> var1);

    private /* synthetic */ IndexState lambda$shouldUpdateIndex$39(Enum k) {
        return new IndexState(((TimeSeriesIndex)((Object)k)).getMapping());
    }

    private /* synthetic */ IndexState lambda$updateMappingIfNecessary$21(Enum k) {
        return new IndexState(((TimeSeriesIndex)((Object)k)).getMapping());
    }

    private /* synthetic */ IndexState lambda$updateSettingIfNecessary$16(Enum k) {
        return new IndexState(((TimeSeriesIndex)((Object)k)).getMapping());
    }

    protected class IndexState {
        public Boolean mappingUpToDate = false;
        public Boolean settingUpToDate = false;
        public Integer schemaVersion;

        public IndexState(String mappingFile) {
            this.schemaVersion = IndexManagement.parseSchemaVersion(mappingFile);
        }
    }
}

