/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.DeleteAnomalyDetectorAction;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.DeleteConfigRequest;

public class RestDeleteAnomalyDetectorAction
extends BaseRestHandler {
    public static final String DELETE_ANOMALY_DETECTOR_ACTION = "delete_anomaly_detector";

    public String getName() {
        return DELETE_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorId = request.param("detectorID");
        DeleteConfigRequest deleteAnomalyDetectorRequest = new DeleteConfigRequest(detectorId);
        return channel -> client.execute((ActionType)DeleteAnomalyDetectorAction.INSTANCE, (ActionRequest)deleteAnomalyDetectorRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID"), RestRequest.Method.DELETE, String.format(Locale.ROOT, "%s/{%s}", "/_opendistro/_anomaly_detection/detectors", "detectorID")));
    }
}

