/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.rerank;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

public enum RerankType {
    ML_OPENSEARCH("ml_opensearch");

    private final String label;
    private static final Map<String, RerankType> LABEL_MAP;

    private RerankType(String label) {
        this.label = label;
    }

    public static RerankType from(String label) {
        RerankType ans = LABEL_MAP.get(label);
        if (ans == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Wrong rerank type name: %s", label));
        }
        return ans;
    }

    public static Map<String, RerankType> labelMap() {
        return LABEL_MAP;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    static {
        HashMap<String, RerankType> labelMap = new HashMap<String, RerankType>();
        for (RerankType type : RerankType.values()) {
            labelMap.put(type.getLabel(), type);
        }
        LABEL_MAP = Collections.unmodifiableMap(labelMap);
    }
}

