/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.validation;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import org.opensearch.common.Nullable;
import org.opensearch.common.ValidationException;
import org.opensearch.knn.index.Parameter;

public final class ParameterValidator {
    @Nullable
    public static ValidationException validateParameters(Map<String, Parameter<?>> validParameters, Map<String, Object> requestParameters) {
        if (validParameters == null) {
            throw new IllegalArgumentException("validParameters cannot be null");
        }
        if (requestParameters == null || requestParameters.isEmpty()) {
            return null;
        }
        ArrayList<CallSite> errorMessages = new ArrayList<CallSite>();
        for (Map.Entry<String, Object> parameter : requestParameters.entrySet()) {
            if (validParameters.containsKey(parameter.getKey())) {
                ValidationException parameterValidation = validParameters.get(parameter.getKey()).validate(parameter.getValue());
                if (parameterValidation == null) continue;
                errorMessages.addAll(parameterValidation.validationErrors());
                continue;
            }
            errorMessages.add((CallSite)((Object)("Unknown parameter '" + parameter.getKey() + "' found")));
        }
        if (errorMessages.isEmpty()) {
            return null;
        }
        ValidationException validationException = new ValidationException();
        validationException.addValidationErrors(errorMessages);
        return validationException;
    }
}

