/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.analysis;

import java.util.List;
import org.opensearch.sql.datasource.DataSourceService;

public class DataSourceSchemaIdentifierNameResolver {
    public static final String DEFAULT_DATASOURCE_NAME = "@opensearch";
    public static final String DEFAULT_SCHEMA_NAME = "default";
    public static final String INFORMATION_SCHEMA_NAME = "information_schema";
    private String dataSourceName = "@opensearch";
    private String schemaName = "default";
    private String identifierName;
    private DataSourceService dataSourceService;
    private static final String DOT = ".";

    public DataSourceSchemaIdentifierNameResolver(DataSourceService dataSourceService, List<String> parts) {
        this.dataSourceService = dataSourceService;
        List<String> remainingParts = this.captureSchemaName(this.captureDataSourceName(parts));
        this.identifierName = String.join((CharSequence)DOT, remainingParts);
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    private List<String> captureDataSourceName(List<String> parts) {
        if (parts.size() > 1 && this.dataSourceService.dataSourceExists(parts.get(0)).booleanValue()) {
            this.dataSourceName = parts.get(0);
            return parts.subList(1, parts.size());
        }
        return parts;
    }

    private List<String> captureSchemaName(List<String> parts) {
        if (parts.size() > 1 && (DEFAULT_SCHEMA_NAME.equals(parts.get(0)) || INFORMATION_SCHEMA_NAME.contains(parts.get(0)))) {
            this.schemaName = parts.get(0);
            return parts.subList(1, parts.size());
        }
        return parts;
    }
}

