/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.securityconf.impl.v7;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.opensearch.security.securityconf.Hideable;
import org.opensearch.security.securityconf.StaticDefinable;
import org.opensearch.security.securityconf.impl.v6.ActionGroupsV6;

public class ActionGroupsV7
implements Hideable,
StaticDefinable {
    private boolean reserved;
    private boolean hidden;
    @JsonProperty(value="static")
    private boolean _static;
    private List<String> allowed_actions = Collections.emptyList();
    private String type;
    private String description;

    public ActionGroupsV7() {
    }

    public ActionGroupsV7(String agName, ActionGroupsV6 ag6) {
        this.reserved = ag6.isReserved();
        this.hidden = ag6.isHidden();
        this.allowed_actions = ag6.getPermissions();
        this.type = agName.toLowerCase().contains("cluster") ? "cluster" : "index";
        this.description = "Migrated from v6";
    }

    public ActionGroupsV7(String key, List<String> allowed_actions) {
        this.allowed_actions = allowed_actions;
        this.type = "unknown";
        this.description = "Migrated from v6 (legacy)";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isReserved() {
        return this.reserved;
    }

    public void setReserved(boolean reserved) {
        this.reserved = reserved;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List<String> getAllowed_actions() {
        return this.allowed_actions;
    }

    public void setAllowed_actions(List<String> allowed_actions) {
        this.allowed_actions = allowed_actions;
    }

    @Override
    @JsonProperty(value="static")
    public boolean isStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(boolean _static) {
        this._static = _static;
    }

    public String toString() {
        return "ActionGroupsV7 [reserved=" + this.reserved + ", hidden=" + this.hidden + ", _static=" + this._static + ", allowed_actions=" + String.valueOf(this.allowed_actions) + ", type=" + this.type + ", description=" + this.description + "]";
    }
}

