/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.exporter;

import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.plugin.insights.core.exporter.LocalIndexExporter;
import org.opensearch.plugin.insights.core.exporter.QueryInsightsExporter;

public enum SinkType {
    DEBUG("debug"),
    LOCAL_INDEX("local_index");

    private final String type;

    private SinkType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    public static SinkType parse(String type) {
        return SinkType.valueOf(type.toUpperCase(Locale.ROOT));
    }

    public static Set<SinkType> allSinkTypes() {
        return Arrays.stream(SinkType.values()).collect(Collectors.toSet());
    }

    public static SinkType getSinkTypeFromExporter(QueryInsightsExporter exporter) {
        if (exporter.getClass().equals(LocalIndexExporter.class)) {
            return LOCAL_INDEX;
        }
        return DEBUG;
    }
}

