/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.feature;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ThreadedActionListener;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.core.action.ActionListener;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.EndRunException;
import org.opensearch.timeseries.dataprocessor.Imputer;
import org.opensearch.timeseries.feature.Features;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;

public class FeatureManager {
    private static final Logger logger = LogManager.getLogger(FeatureManager.class);
    private final SearchFeatureDao searchFeatureDao;
    public final Imputer imputer;
    private final int trainSampleTimeRangeInHours;
    private final int minTrainSamples;
    private final double maxMissingPointsRate;
    private final int maxNeighborDistance;
    private final double previewSampleRate;
    private final int maxPreviewSamples;
    private final ThreadPool threadPool;

    public FeatureManager(SearchFeatureDao searchFeatureDao, Imputer imputer, int trainSampleTimeRangeInHours, int minTrainSamples, double maxMissingPointsRate, int maxNeighborDistance, double previewSampleRate, int maxPreviewSamples, ThreadPool threadPool) {
        this.searchFeatureDao = searchFeatureDao;
        this.imputer = imputer;
        this.trainSampleTimeRangeInHours = trainSampleTimeRangeInHours;
        this.minTrainSamples = minTrainSamples;
        this.maxMissingPointsRate = maxMissingPointsRate;
        this.maxNeighborDistance = maxNeighborDistance;
        this.previewSampleRate = previewSampleRate;
        this.maxPreviewSamples = maxPreviewSamples;
        this.threadPool = threadPool;
    }

    public void getCurrentFeatures(Config config, long startTime, long endTime, AnalysisType context, ActionListener<Optional<double[]>> listener) {
        List<Map.Entry<Long, Long>> missingRanges = Collections.singletonList(new AbstractMap.SimpleImmutableEntry<Long, Long>(startTime, endTime));
        try {
            this.searchFeatureDao.getFeatureSamplesForPeriods(config, missingRanges, context, (ActionListener<List<Optional<double[]>>>)ActionListener.wrap(points -> {
                if (points.size() == 1) {
                    Optional point = (Optional)points.get(0);
                    listener.onResponse((Object)point);
                } else {
                    listener.onResponse(Optional.empty());
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (IOException e) {
            listener.onFailure((Exception)new EndRunException(config.getId(), "Invalid search query.", e, true));
        }
    }

    public void getColdStartData(AnomalyDetector detector, ActionListener<Optional<double[][]>> listener) {
        ActionListener latestTimeListener = ActionListener.wrap(latest -> this.getColdStartSamples((Optional<Long>)latest, detector, AnalysisType.AD, listener), arg_0 -> listener.onFailure(arg_0));
        this.searchFeatureDao.getLatestDataTime(detector, Optional.empty(), AnalysisType.AD, (ActionListener<Optional<Long>>)new ThreadedActionListener(logger, this.threadPool, "ad-threadpool", latestTimeListener, false));
    }

    private void getColdStartSamples(Optional<Long> latest, Config config, AnalysisType context, ActionListener<Optional<double[][]>> listener) {
        int shingleSize = config.getShingleSize();
        if (latest.isPresent()) {
            List<Map.Entry<Long, Long>> sampleRanges = this.getColdStartSampleRanges(config, latest.get());
            try {
                ActionListener getFeaturesListener = ActionListener.wrap(samples -> this.processColdStartSamples((List<Optional<double[]>>)samples, shingleSize, listener), arg_0 -> listener.onFailure(arg_0));
                this.searchFeatureDao.getFeatureSamplesForPeriods(config, sampleRanges, context, (ActionListener<List<Optional<double[]>>>)new ThreadedActionListener(logger, this.threadPool, "ad-threadpool", getFeaturesListener, false));
            }
            catch (IOException e) {
                listener.onFailure((Exception)new EndRunException(config.getId(), "Invalid search query.", e, true));
            }
        } else {
            listener.onResponse(Optional.empty());
        }
    }

    private void processColdStartSamples(List<Optional<double[]>> samples, int shingleSize, ActionListener<Optional<double[][]>> listener) {
        ArrayList shingles = new ArrayList();
        LinkedList<Optional<double[]>> currentShingle = new LinkedList<Optional<double[]>>();
        for (Optional<double[]> sample : samples) {
            currentShingle.addLast(sample);
            if (currentShingle.size() != shingleSize) continue;
            sample.ifPresent(s -> this.fillAndShingle(currentShingle, shingleSize).ifPresent(shingles::add));
            currentShingle.remove();
        }
        listener.onResponse(Optional.of((double[][])shingles.toArray((T[])new double[0][0])).filter(results -> ((double[][])results).length > 0));
    }

    private Optional<double[]> fillAndShingle(LinkedList<Optional<double[]>> shingle, int shingleSize) {
        Optional<double[]> result = null;
        if (shingle.stream().filter(s -> s.isPresent()).count() >= (long)(shingleSize - this.getMaxMissingPoints(shingleSize))) {
            TreeMap<Integer, double[]> search = new TreeMap<Integer, double[]>(IntStream.range(0, shingleSize).filter(i -> ((Optional)shingle.get(i)).isPresent()).boxed().collect(Collectors.toMap(i -> i, i -> (double[])((Optional)shingle.get((int)i)).get())));
            result = Optional.of((double[][])IntStream.range(0, shingleSize).mapToObj(i -> {
                Optional after = Optional.ofNullable(search.ceilingEntry(i));
                Optional before = Optional.ofNullable(search.floorEntry(i));
                return after.filter(a -> Math.abs(i - (Integer)a.getKey()) <= before.map(b -> Math.abs(i - (Integer)b.getKey())).orElse(Integer.MAX_VALUE)).map(Optional::of).orElse(before).filter(e -> Math.abs(i - (Integer)e.getKey()) <= this.maxNeighborDistance).map(Map.Entry::getValue).orElse(null);
            }).filter(d -> d != null).toArray(x$0 -> new double[x$0][])).filter(d -> ((double[][])d).length == shingleSize).map(d -> this.batchShingle((double[][])d, shingleSize)[0]);
        } else {
            result = Optional.empty();
        }
        return result;
    }

    private List<Map.Entry<Long, Long>> getColdStartSampleRanges(Config detector, long endMillis) {
        long interval = detector.getIntervalInMilliseconds();
        int numSamples = Math.max((int)(Duration.ofHours(this.trainSampleTimeRangeInHours).toMillis() / interval), this.minTrainSamples);
        return IntStream.rangeClosed(1, numSamples).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Long, Long>(endMillis - (long)(numSamples - i + 1) * interval, endMillis - (long)(numSamples - i) * interval)).collect(Collectors.toList());
    }

    public double[][] batchShingle(double[][] points, int shingleSize) {
        if (points.length == 0 || points[0].length == 0 || points.length < shingleSize || shingleSize < 1) {
            throw new IllegalArgumentException("Invalid data for shingling.");
        }
        int numPoints = points.length;
        int dimPoint = points[0].length;
        int numShingles = numPoints - shingleSize + 1;
        int dimShingle = dimPoint * shingleSize;
        double[][] shingles = new double[numShingles][dimShingle];
        for (int i = 0; i < numShingles; ++i) {
            for (int j = 0; j < shingleSize; ++j) {
                System.arraycopy(points[i + j], 0, shingles[i], j * dimPoint, dimPoint);
            }
        }
        return shingles;
    }

    public void getPreviewEntities(AnomalyDetector detector, long startTime, long endTime, ActionListener<List<Entity>> listener) {
        this.searchFeatureDao.getHighestCountEntities(detector, startTime, endTime, listener);
    }

    public void getPreviewFeaturesForEntity(AnomalyDetector detector, Entity entity, long startMilli, long endMilli, ActionListener<Features> listener) throws IOException {
        Map.Entry<List<Map.Entry<Long, Long>>, Integer> sampleRangeResults = this.getSampleRanges(detector, startMilli, endMilli);
        List<Map.Entry<Long, Long>> sampleRanges = sampleRangeResults.getKey();
        int stride = sampleRangeResults.getValue();
        int shingleSize = detector.getShingleSize();
        this.getPreviewSamplesInRangesForEntity(detector, sampleRanges, entity, this.getFeatureSamplesListener(stride, shingleSize, listener));
    }

    private ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> getFeatureSamplesListener(int stride, int shingleSize, ActionListener<Features> listener) {
        return ActionListener.wrap(samples -> {
            List searchTimeRange = (List)samples.getKey();
            if (searchTimeRange.size() == 0) {
                listener.onFailure((Exception)new IllegalArgumentException("No data to preview anomaly detection."));
                return;
            }
            double[][] sampleFeatures = (double[][])samples.getValue();
            List<Map.Entry<Long, Long>> previewRanges = this.getPreviewRanges(searchTimeRange, stride);
            double[][] previewFeatures = this.getPreviewFeatures(sampleFeatures, stride);
            listener.onResponse((Object)new Features(previewRanges, previewFeatures));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    public void getPreviewFeatures(AnomalyDetector detector, long startMilli, long endMilli, ActionListener<Features> listener) throws IOException {
        Map.Entry<List<Map.Entry<Long, Long>>, Integer> sampleRangeResults = this.getSampleRanges(detector, startMilli, endMilli);
        List<Map.Entry<Long, Long>> sampleRanges = sampleRangeResults.getKey();
        int stride = sampleRangeResults.getValue();
        int shingleSize = detector.getShingleSize();
        this.getSamplesForRanges(detector, sampleRanges, this.getFeatureSamplesListener(stride, shingleSize, listener));
    }

    private Map.Entry<List<Map.Entry<Long, Long>>, Integer> getSampleRanges(AnomalyDetector detector, long startMilli, long endMilli) {
        long start = this.truncateToMinute(startMilli);
        long end = this.truncateToMinute(endMilli);
        long bucketSize = detector.getIntervalInMilliseconds();
        int numBuckets = (int)Math.floor((double)(end - start) / (double)bucketSize);
        int numSamples = (int)Math.max(Math.min((double)numBuckets * this.previewSampleRate, (double)this.maxPreviewSamples), 1.0);
        int stride = (int)Math.max(1.0, Math.floor((double)numBuckets / (double)numSamples));
        int numStrides = (int)Math.ceil((double)numBuckets / (double)stride);
        List sampleRanges = Stream.iterate(start, i -> i + (long)stride * bucketSize).limit(numStrides).map(time -> new AbstractMap.SimpleImmutableEntry<Long, Long>((Long)time, time + bucketSize)).collect(Collectors.toList());
        return new AbstractMap.SimpleImmutableEntry<List<Map.Entry<Long, Long>>, Integer>(sampleRanges, stride);
    }

    void getPreviewSamplesInRangesForEntity(AnomalyDetector detector, List<Map.Entry<Long, Long>> sampleRanges, Entity entity, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) throws IOException {
        this.searchFeatureDao.getColdStartSamplesForPeriods(detector, sampleRanges, Optional.ofNullable(entity), true, AnalysisType.AD, this.getSamplesRangesListener(sampleRanges, listener));
    }

    private ActionListener<List<Optional<double[]>>> getSamplesRangesListener(List<Map.Entry<Long, Long>> sampleRanges, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) {
        return ActionListener.wrap(featureSamples -> {
            ArrayList ranges = new ArrayList(featureSamples.size());
            ArrayList samples = new ArrayList(featureSamples.size());
            for (int i = 0; i < featureSamples.size(); ++i) {
                Map.Entry currentRange = (Map.Entry)sampleRanges.get(i);
                ((Optional)featureSamples.get(i)).ifPresent(sample -> {
                    ranges.add(currentRange);
                    samples.add(sample);
                });
            }
            listener.onResponse(new AbstractMap.SimpleImmutableEntry(ranges, (double[][])samples.toArray((T[])new double[0][0])));
        }, arg_0 -> listener.onFailure(arg_0));
    }

    void getSamplesForRanges(AnomalyDetector detector, List<Map.Entry<Long, Long>> sampleRanges, ActionListener<Map.Entry<List<Map.Entry<Long, Long>>, double[][]>> listener) throws IOException {
        this.searchFeatureDao.getFeatureSamplesForPeriods(detector, sampleRanges, AnalysisType.AD, this.getSamplesRangesListener(sampleRanges, listener));
    }

    private List<Map.Entry<Long, Long>> getPreviewRanges(List<Map.Entry<Long, Long>> ranges, int stride) {
        double[] rangeStarts = ranges.stream().mapToDouble(Map.Entry::getKey).toArray();
        double[] rangeEnds = ranges.stream().mapToDouble(Map.Entry::getValue).toArray();
        double[] previewRangeStarts = this.imputer.singleFeatureImpute(rangeStarts, stride * (ranges.size() - 1) + 1);
        double[] previewRangeEnds = this.imputer.singleFeatureImpute(rangeEnds, stride * (ranges.size() - 1) + 1);
        List<Map.Entry<Long, Long>> previewRanges = IntStream.range(0, previewRangeStarts.length).mapToObj(i -> new AbstractMap.SimpleImmutableEntry<Long, Long>((long)previewRangeStarts[i], (long)previewRangeEnds[i])).collect(Collectors.toList());
        return previewRanges;
    }

    private double[][] getPreviewFeatures(double[][] samples, int stride) {
        double[][] unprocessed = Optional.of(samples).map(m -> this.imputer.impute((double[][])m, stride * (samples.length - 1) + 1)).map(m -> (double[][])Arrays.copyOfRange(m, 0, ((double[][])m).length)).get();
        return unprocessed;
    }

    private long truncateToMinute(long epochMillis) {
        return Instant.ofEpochMilli(epochMillis).truncatedTo(ChronoUnit.MINUTES).toEpochMilli();
    }

    private int getMaxMissingPoints(int shingleSize) {
        return (int)Math.floor((double)shingleSize * this.maxMissingPointsRate);
    }

    public void getFeatureDataPointsByBatch(AnomalyDetector detector, Entity entity, long startTime, long endTime, ActionListener<Map<Long, Optional<double[]>>> listener) {
        try {
            this.searchFeatureDao.getFeaturesForPeriodByBatch(detector, entity, startTime, endTime, (ActionListener<Map<Long, Optional<double[]>>>)ActionListener.wrap(points -> {
                logger.debug("features size: {}", (Object)points.size());
                listener.onResponse(points);
            }, arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            logger.error("Failed to get features for detector: " + detector.getId());
            listener.onFailure(e);
        }
    }

    private List<Long> getFullTrainingDataEndTimes(long endTime, long intervalMilli, long startTime) {
        return LongStream.iterate(startTime, i -> i + intervalMilli).takeWhile(i -> i <= endTime).boxed().collect(Collectors.toList());
    }
}

