/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.transfer;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.cli.transfer.AbstractMavenTransferListener;
import org.apache.maven.cli.transfer.TransferResourceIdentifier;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;

public class ConsoleMavenTransferListener
extends AbstractMavenTransferListener {
    private final Map<TransferResourceIdentifier, TransferResourceAndSize> transfers = Collections.synchronizedMap(new LinkedHashMap());
    private final boolean printResourceNames;
    private int lastLength;

    public ConsoleMavenTransferListener(PrintStream out, boolean printResourceNames) {
        super(out);
        this.printResourceNames = printResourceNames;
    }

    @Override
    public void transferInitiated(TransferEvent event) {
        this.overridePreviousTransfer(event);
        super.transferInitiated(event);
    }

    @Override
    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        this.overridePreviousTransfer(event);
        super.transferCorrupted(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        TransferResource resource = event.getResource();
        this.transfers.put(new TransferResourceIdentifier(resource), new TransferResourceAndSize(resource, event.getTransferredBytes()));
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("Progress (").append(this.transfers.size()).append("): ");
        Map<TransferResourceIdentifier, TransferResourceAndSize> map = this.transfers;
        synchronized (map) {
            Iterator<TransferResourceAndSize> entries = this.transfers.values().iterator();
            while (entries.hasNext()) {
                TransferResourceAndSize entry = entries.next();
                long total = entry.resource.getContentLength();
                Long complete = entry.transferredBytes;
                buffer.append(this.getStatus(entry.resource.getResourceName(), complete, total));
                if (!entries.hasNext()) continue;
                buffer.append(" | ");
            }
        }
        int pad = this.lastLength - buffer.length();
        this.lastLength = buffer.length();
        this.pad(buffer, pad);
        buffer.append('\r');
        this.out.print(buffer);
        this.out.flush();
    }

    private String getStatus(String resourceName, long complete, long total) {
        AbstractMavenTransferListener.FileSizeFormat format = new AbstractMavenTransferListener.FileSizeFormat(Locale.ENGLISH);
        StringBuilder status = new StringBuilder();
        if (this.printResourceNames) {
            status.append(this.resourceName(resourceName));
            status.append(" (");
        }
        status.append(format.formatProgress(complete, total));
        if (this.printResourceNames) {
            status.append(")");
        }
        return status.toString();
    }

    private String resourceName(String resourceName) {
        if (resourceName == null || resourceName.trim().isEmpty()) {
            return "";
        }
        int pos = resourceName.lastIndexOf("/");
        if (pos == -1 || pos == resourceName.length() - 1) {
            return "";
        }
        return resourceName.substring(pos + 1);
    }

    private void pad(StringBuilder buffer, int spaces) {
        String block = "                                        ";
        while (spaces > 0) {
            int n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
            spaces -= n;
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        this.transfers.remove(new TransferResourceIdentifier(event.getResource()));
        this.overridePreviousTransfer(event);
        super.transferSucceeded(event);
    }

    public void transferFailed(TransferEvent event) {
        this.transfers.remove(new TransferResourceIdentifier(event.getResource()));
        this.overridePreviousTransfer(event);
        super.transferFailed(event);
    }

    private void overridePreviousTransfer(TransferEvent event) {
        if (this.lastLength > 0) {
            StringBuilder buffer = new StringBuilder(128);
            this.pad(buffer, this.lastLength);
            buffer.append('\r');
            this.out.print(buffer);
            this.out.flush();
            this.lastLength = 0;
        }
    }

    private final class TransferResourceAndSize {
        private final TransferResource resource;
        private final long transferredBytes;

        private TransferResourceAndSize(TransferResource resource, long transferredBytes) {
            this.resource = resource;
            this.transferredBytes = transferredBytes;
        }
    }
}

