/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocatorKt;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.PrioritizeKt;
import org.jitsi.videobridge.cc.allocation.SingleSourceAllocation;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001BBI\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0015J\u000e\u00104\u001a\u0002022\u0006\u0010\u001f\u001a\u00020 J\u0006\u00104\u001a\u000202J\u0016\u00109\u001a\u00020$2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\bH\u0002J\u0015\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b=J\u001c\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\b2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0\bH\u0002J\u0006\u0010@\u001a\u000202J\b\u0010A\u001a\u000202H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019j\u0002`\u0018X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010*\u001a\u00020+8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006C"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator;", "T", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "", "eventHandler", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "endpointsSupplier", "Ljava/util/function/Supplier;", "", "trustBwe", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;Ljava/time/Clock;)V", "logger", "bweBps", "", "expired", "effectiveConstraints", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Ljava/util/Map;", "eventEmitter", "Lorg/jitsi/utils/event/EventEmitter;", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "lastUpdateTime", "Ljava/time/Instant;", "value", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "allocation", "getAllocation", "()Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "updateTask", "Ljava/util/concurrent/ScheduledFuture;", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "availableBandwidth", "getAvailableBandwidth", "()J", "bandwidthChanged", "", "newBandwidthBps", "update", "selectedSources", "", "getSelectedSources", "()Ljava/util/List;", "allocate", "conferenceMediaSources", "hasNonZeroEffectiveConstraints", "source", "hasNonZeroEffectiveConstraints$jitsi_videobridge", "createAllocations", "Lorg/jitsi/videobridge/cc/allocation/SingleSourceAllocation;", "expire", "rescheduleUpdate", "EventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nBandwidthAllocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BandwidthAllocator.kt\norg/jitsi/videobridge/cc/allocation/BandwidthAllocator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n468#2:397\n414#2:398\n1238#3,4:399\n1360#3:403\n1446#3,5:404\n1855#3,2:409\n766#3:411\n857#3,2:412\n1549#3:414\n1620#3,3:415\n1549#3:418\n1620#3,3:419\n1549#3:422\n1620#3,3:423\n*S KotlinDebug\n*F\n+ 1 BandwidthAllocator.kt\norg/jitsi/videobridge/cc/allocation/BandwidthAllocator\n*L\n127#1:397\n127#1:398\n127#1:399,4\n179#1:403\n179#1:404,5\n220#1:409,2\n275#1:411\n275#1:412,2\n276#1:414\n276#1:415,3\n301#1:418\n301#1:419,3\n188#1:422\n188#1:423,3\n*E\n"})
public final class BandwidthAllocator<T extends MediaSourceContainer> {
    @NotNull
    private final Supplier<List<T>> endpointsSupplier;
    @NotNull
    private final Supplier<Boolean> trustBwe;
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    private long bweBps;
    private boolean expired;
    @NotNull
    private Map<MediaSourceDesc, VideoConstraints> effectiveConstraints;
    @NotNull
    private final EventEmitter<EventHandler> eventEmitter;
    @NotNull
    private AllocationSettings allocationSettings;
    @NotNull
    private Instant lastUpdateTime;
    @NotNull
    private BandwidthAllocation allocation;
    @Nullable
    private ScheduledFuture<?> updateTask;

    /*
     * WARNING - void declaration
     */
    public BandwidthAllocator(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull Supplier<Boolean> trustBwe, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext, @NotNull Clock clock) {
        void $this$eventEmitter_u24lambda_u240;
        SyncEventEmitter syncEventEmitter;
        Intrinsics.checkNotNullParameter(eventHandler, "eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, "endpointsSupplier");
        Intrinsics.checkNotNullParameter(trustBwe, "trustBwe");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.endpointsSupplier = endpointsSupplier;
        this.trustBwe = trustBwe;
        this.diagnosticContext = diagnosticContext;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.bweBps = -1L;
        this.effectiveConstraints = MapsKt.emptyMap();
        SyncEventEmitter syncEventEmitter2 = syncEventEmitter = new SyncEventEmitter();
        BandwidthAllocator bandwidthAllocator = this;
        boolean bl = false;
        $this$eventEmitter_u24lambda_u240.addHandler(eventHandler);
        bandwidthAllocator.eventEmitter = syncEventEmitter;
        this.allocationSettings = new AllocationSettings(null, null, null, null, null, 0, new VideoConstraints(BitrateControllerConfig.config.thumbnailMaxHeightPx(), 0.0, 2, null), 0L, 191, null);
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        this.lastUpdateTime = instant;
        this.allocation = new BandwidthAllocation(SetsKt.emptySet(), false, 0L, 0L, null, 30, null);
        this.rescheduleUpdate();
    }

    @NotNull
    public final BandwidthAllocation getAllocation() {
        return this.allocation;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="We intentionally avoid synchronizing while reading fields only used in debug output.")
    @NotNull
    public final JSONObject getDebugState() {
        void $this$mapKeysTo$iv$iv;
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("trustBwe", this.trustBwe.get());
        ((Map)debugState).put("bweBps", this.bweBps);
        ((Map)debugState).put("allocation", this.allocation.getDebugState());
        ((Map)debugState).put("allocationSettings", this.allocationSettings.toJson());
        Map map = debugState;
        String string = "effectiveConstraints";
        Map<MediaSourceDesc, VideoConstraints> $this$mapKeys$iv = this.effectiveConstraints;
        boolean $i$f$mapKeys = false;
        Map<MediaSourceDesc, VideoConstraints> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = ((MediaSourceDesc)it.getKey()).getSourceName();
            Map map4 = map3;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map4.put(string2, entry);
        }
        Map map5 = destination$iv$iv;
        map.put(string, map5);
        return debugState;
    }

    private final long getAvailableBandwidth() {
        return this.trustBwe.get() != false ? this.bweBps : Long.MAX_VALUE;
    }

    public final void bandwidthChanged(long newBandwidthBps) {
        if (!BandwidthAllocatorKt.access$bweChangeIsLargerThanThreshold(this.bweBps, newBandwidthBps)) {
            this.logger.debug(() -> BandwidthAllocator.bandwidthChanged$lambda$2(newBandwidthBps, this));
        } else {
            this.logger.debug(() -> BandwidthAllocator.bandwidthChanged$lambda$3(newBandwidthBps));
            this.bweBps = newBandwidthBps;
            this.update();
        }
    }

    public final void update(@NotNull AllocationSettings allocationSettings) {
        Intrinsics.checkNotNullParameter(allocationSettings, "allocationSettings");
        this.allocationSettings = allocationSettings;
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void update() {
        boolean effectiveConstraintsChanged;
        void $this$flatMapTo$iv$iv;
        if (this.expired) {
            return;
        }
        this.lastUpdateTime = this.clock.instant();
        List<T> list = this.endpointsSupplier.get();
        Intrinsics.checkNotNullExpressionValue(list, "get(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MediaSourceContainer it = (MediaSourceContainer)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ArraysKt.toList(it.getMediaSources());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List<MediaSourceDesc> sources = CollectionsKt.toMutableList((List)destination$iv$iv);
        List<MediaSourceDesc> sortedSources = PrioritizeKt.prioritize(sources, this.getSelectedSources());
        Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints = this.effectiveConstraints;
        Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints = PrioritizeKt.getEffectiveConstraints(sortedSources, this.allocationSettings);
        this.effectiveConstraints = newEffectiveConstraints;
        this.logger.trace(() -> BandwidthAllocator.update$lambda$6(sortedSources, newEffectiveConstraints));
        BandwidthAllocation newAllocation = this.allocate(sortedSources);
        boolean allocationChanged = !this.allocation.isTheSameAs(newAllocation);
        boolean bl = effectiveConstraintsChanged = !Intrinsics.areEqual(this.effectiveConstraints, oldEffectiveConstraints);
        if (allocationChanged) {
            this.eventEmitter.fireEvent(arg_0 -> BandwidthAllocator.update$lambda$7(newAllocation, arg_0));
        }
        this.allocation = newAllocation;
        this.logger.trace(() -> BandwidthAllocator.update$lambda$8(allocationChanged, effectiveConstraintsChanged, this));
        if (effectiveConstraintsChanged) {
            this.eventEmitter.fireEvent(arg_0 -> BandwidthAllocator.update$lambda$9(oldEffectiveConstraints, this, arg_0));
        }
    }

    private final List<String> getSelectedSources() {
        List<String> selectedSources = CollectionsKt.toMutableList((Collection)this.allocationSettings.getOnStageSources());
        Iterable $this$forEach$iv = this.allocationSettings.getSelectedSources();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (selectedSources.contains(it)) continue;
            selectedSources.add(it);
        }
        return selectedSources;
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized BandwidthAllocation allocate(List<MediaSourceDesc> conferenceMediaSources) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SingleSourceAllocation it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        long l;
        List<SingleSourceAllocation> sourceBitrateAllocations = this.createAllocations(conferenceMediaSources);
        if (sourceBitrateAllocations.isEmpty()) {
            return new BandwidthAllocation(SetsKt.emptySet(), false, 0L, 0L, null, 30, null);
        }
        if (this.allocationSettings.getAssumedBandwidthBps() >= 0L) {
            this.logger.warn("Allocating with assumed bandwidth " + Bandwidth.toString-impl(BandwidthKt.getBps(this.allocationSettings.getAssumedBandwidthBps())) + ".");
            l = this.allocationSettings.getAssumedBandwidthBps();
        } else {
            l = this.getAvailableBandwidth();
        }
        long remainingBandwidth = l;
        long oldRemainingBandwidth = -1L;
        boolean oversending = false;
        block0: while (oldRemainingBandwidth != remainingBandwidth) {
            oldRemainingBandwidth = remainingBandwidth;
            int n = ((Collection)sourceBitrateAllocations).size();
            for (int i = 0; i < n; ++i) {
                SingleSourceAllocation sourceBitrateAllocation = sourceBitrateAllocations.get(i);
                if (sourceBitrateAllocation.getConstraints().isDisabled()) continue;
                if ((remainingBandwidth -= sourceBitrateAllocation.improve(remainingBandwidth, i == 0)) < 0L) {
                    oversending = true;
                }
                if (sourceBitrateAllocation.isOnStage() && !sourceBitrateAllocation.hasReachedPreferred()) continue block0;
            }
        }
        Iterable iterable = sourceBitrateAllocations;
        boolean $i$f$filter = false;
        void var11_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (SingleSourceAllocation)element$iv$iv;
            boolean bl = false;
            if (!it.isSuspended()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SingleSourceAllocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMediaSource().getSourceName());
        }
        List<String> suspendedIds = CollectionsKt.toList((List)destination$iv$iv);
        if (!((Collection)suspendedIds).isEmpty()) {
            this.logger.info("Sources suspended due to insufficient bandwidth (bwe=" + this.getAvailableBandwidth() + " bps): " + suspendedIds);
        }
        Set allocations = new LinkedHashSet();
        long targetBps = 0L;
        long idealBps = 0L;
        for (SingleSourceAllocation sourceBitrateAllocation : sourceBitrateAllocations) {
            allocations.add(sourceBitrateAllocation.getResult());
            targetBps += sourceBitrateAllocation.getTargetBitrate();
            idealBps += sourceBitrateAllocation.getIdealBitrate();
        }
        return new BandwidthAllocation(allocations, oversending, idealBps, targetBps, suspendedIds);
    }

    public final boolean hasNonZeroEffectiveConstraints$jitsi_videobridge(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        VideoConstraints videoConstraints = this.effectiveConstraints.get(source);
        if (videoConstraints == null) {
            return false;
        }
        VideoConstraints constraints = videoConstraints;
        return !constraints.isDisabled();
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized List<SingleSourceAllocation> createAllocations(List<MediaSourceDesc> conferenceMediaSources) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = conferenceMediaSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void source;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = source.getOwner();
            VideoConstraints videoConstraints = this.effectiveConstraints.get(source);
            Intrinsics.checkNotNull(videoConstraints);
            collection.add(new SingleSourceAllocation(string, (MediaSourceDesc)source, videoConstraints, this.allocationSettings.getOnStageSources().contains(source.getSourceName()), this.diagnosticContext, this.clock, this.logger));
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    public final void expire() {
        block0: {
            this.expired = true;
            ScheduledFuture<?> scheduledFuture = this.updateTask;
            if (scheduledFuture == null) break block0;
            scheduledFuture.cancel(false);
        }
    }

    private final void rescheduleUpdate() {
        long l;
        Duration period;
        if (this.expired) {
            return;
        }
        Duration timeSinceLastUpdate = Duration.between(this.lastUpdateTime, this.clock.instant());
        if (timeSinceLastUpdate.compareTo(period = BitrateControllerConfig.config.maxTimeBetweenCalculations()) > 0) {
            this.logger.debug("Running periodic re-allocation.");
            TaskPools.CPU_POOL.execute(() -> BandwidthAllocator.rescheduleUpdate$lambda$14(this));
            l = period.toMillis();
        } else {
            l = period.minus(timeSinceLastUpdate).toMillis();
        }
        long delayMs = l;
        this.updateTask = TaskPools.SCHEDULED_POOL.schedule(() -> BandwidthAllocator.rescheduleUpdate$lambda$15(this), delayMs + (long)5, TimeUnit.MILLISECONDS);
    }

    private static final String bandwidthChanged$lambda$2(long $newBandwidthBps, BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "New bwe (" + $newBandwidthBps + ") is not significantly changed from previous bwe (" + this$0.bweBps + "), ignoring.";
    }

    private static final String bandwidthChanged$lambda$3(long $newBandwidthBps) {
        return "new bandwidth is " + $newBandwidthBps + ", updating";
    }

    /*
     * WARNING - void declaration
     */
    private static final String update$lambda$6(List $sortedSources, Map $newEffectiveConstraints) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($sortedSources, "$sortedSources");
        Intrinsics.checkNotNullParameter($newEffectiveConstraints, "$newEffectiveConstraints");
        Iterable $this$map$iv = $sortedSources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MediaSourceDesc mediaSourceDesc = (MediaSourceDesc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSourceName());
        }
        return "Allocating: sortedSources=" + (List)destination$iv$iv + ",  effectiveConstraints=" + $newEffectiveConstraints;
    }

    private static final Unit update$lambda$7(BandwidthAllocation $newAllocation, EventHandler $this$fireEvent) {
        Intrinsics.checkNotNullParameter($newAllocation, "$newAllocation");
        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
        $this$fireEvent.allocationChanged($newAllocation);
        return Unit.INSTANCE;
    }

    private static final String update$lambda$8(boolean $allocationChanged, boolean $effectiveConstraintsChanged, BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Finished allocation: allocationChanged=" + $allocationChanged + ", effectiveConstraintsChanged=" + $effectiveConstraintsChanged + ", allocation=[" + this$0.allocation + "]";
    }

    private static final Unit update$lambda$9(Map $oldEffectiveConstraints, BandwidthAllocator this$0, EventHandler $this$fireEvent) {
        Intrinsics.checkNotNullParameter($oldEffectiveConstraints, "$oldEffectiveConstraints");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
        $this$fireEvent.effectiveVideoConstraintsChanged($oldEffectiveConstraints, this$0.effectiveConstraints);
        return Unit.INSTANCE;
    }

    private static final void rescheduleUpdate$lambda$14(BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.update();
    }

    private static final void rescheduleUpdate$lambda$15(BandwidthAllocator this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.rescheduleUpdate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J=\u0010\u0006\u001a\u00020\u00032\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\bH&\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "newEffectiveConstraints", "(Ljava/util/Map;Ljava/util/Map;)V", "jitsi-videobridge"})
    public static interface EventHandler {
        public void allocationChanged(@NotNull BandwidthAllocation var1);

        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> var1, @NotNull Map<MediaSourceDesc, VideoConstraints> var2);
    }
}

