/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import org.ice4j.TransportAddress;
import org.ice4j.socket.DelegatingSocket;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.SocketClosedException;
import org.jitsi.utils.logging2.Logger;

public class MergingDatagramSocket
extends DatagramSocket {
    private final Object socketContainersSyncRoot = new Object();
    private SocketContainer[] socketContainers = new SocketContainer[0];
    private final Object receiveLock = new Object();
    private int soTimeout = 0;
    protected SocketContainer active = null;
    private boolean closed = false;
    private int numDiscardedPackets = 0;
    protected final Logger logger;

    public MergingDatagramSocket() throws SocketException {
        this((Logger)null);
    }

    public MergingDatagramSocket(Logger parentLogger) throws SocketException {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.isClosed()) {
                return;
            }
            this.closed = true;
            this.logger.info("Closing.");
            Object object = this.receiveLock;
            synchronized (object) {
                this.receiveLock.notifyAll();
            }
            object = this.socketContainersSyncRoot;
            synchronized (object) {
                this.active = null;
                for (SocketContainer container : this.socketContainers) {
                    container.close(false);
                }
                this.socketContainers = new SocketContainer[0];
            }
        }
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void send(DatagramPacket pkt) throws IOException {
        SocketContainer active = this.getActiveSocket();
        if (active == null) {
            throw new IOException("No active socket.");
        }
        active.send(pkt);
    }

    public void add(DelegatingSocket socket) {
        Objects.requireNonNull(socket, "socket");
        this.logger.debug(() -> "Adding a DelegatingSocket instance: " + socket.getLocalAddress());
        this.doAdd(socket);
    }

    public void add(IceSocketWrapper wrapper) {
        Closeable socket = wrapper.getUDPSocket();
        if (socket == null) {
            socket = wrapper.getTCPSocket();
        }
        this.doAdd(socket);
    }

    public void add(DatagramSocket socket) {
        Objects.requireNonNull(socket, "socket");
        this.logger.debug(() -> "Adding a DatagramSocket instance: " + socket.getLocalAddress());
        this.doAdd(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(Object socket) {
        Objects.requireNonNull(socket, "socket");
        if (!(socket instanceof DelegatingSocket) && !(socket instanceof DatagramSocket)) {
            throw new IllegalStateException("Socket type not supported: " + socket.getClass().getName());
        }
        Object object = this.socketContainersSyncRoot;
        synchronized (object) {
            if (this.indexOf(this.socketContainers, socket) != -1) {
                this.logger.warn("Socket already added.");
                return;
            }
            SocketContainer socketContainer = socket instanceof DelegatingSocket ? new SocketContainer((DelegatingSocket)socket) : new SocketContainer((DatagramSocket)socket);
            SocketContainer[] newSocketContainers = new SocketContainer[this.socketContainers.length + 1];
            System.arraycopy(this.socketContainers, 0, newSocketContainers, 0, this.socketContainers.length);
            newSocketContainers[this.socketContainers.length] = socketContainer;
            this.socketContainers = newSocketContainers;
        }
    }

    public void remove(DatagramSocket socket) {
        this.doRemove(socket);
    }

    public void remove(DelegatingSocket socket) {
        this.doRemove(socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(Object socket) {
        SocketContainer socketContainer = null;
        Object object = this.socketContainersSyncRoot;
        synchronized (object) {
            int i = this.indexOf(this.socketContainers, socket);
            if (i >= 0) {
                socketContainer = this.socketContainers[i];
                SocketContainer[] newSockets = new SocketContainer[this.socketContainers.length - 1];
                if (i > 0) {
                    System.arraycopy(this.socketContainers, 0, newSockets, 0, i);
                }
                if (i < this.socketContainers.length - 1) {
                    System.arraycopy(this.socketContainers, i + 1, newSockets, i, this.socketContainers.length - i - 1);
                }
                this.socketContainers = newSockets;
                if (socketContainer == this.active) {
                    this.logger.warn("Removing the active socket. Won't be able to send until a new one is elected.");
                    this.active = null;
                }
            } else {
                this.logger.error("Cannot find socket to remove.");
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removed: " + socketContainer);
        }
        if (socketContainer != null) {
            socketContainer.close(false);
        }
    }

    private int indexOf(SocketContainer[] socketContainers, Object socket) {
        for (int i = 0; i < socketContainers.length; ++i) {
            if (socketContainers[i].datagramSocket != socket && socketContainers[i].delegatingSocket != socket) continue;
            return i;
        }
        return -1;
    }

    protected SocketContainer getActiveSocket() {
        return this.active;
    }

    @Override
    public InetAddress getLocalAddress() {
        SocketContainer activeSocket = this.getActiveSocket();
        return activeSocket == null ? null : activeSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        SocketContainer activeSocket = this.getActiveSocket();
        return activeSocket == null ? 0 : activeSocket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        SocketContainer activeSocket = this.getActiveSocket();
        return activeSocket == null ? null : activeSocket.getLocalSocketAddress();
    }

    protected boolean accept(DatagramPacket p) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void receive(DatagramPacket p) throws SocketTimeoutException, SocketClosedException {
        long start = System.currentTimeMillis();
        int soTimeout = this.soTimeout;
        Object object = this.receiveLock;
        synchronized (object) {
            while (true) {
                if (this.isClosed()) {
                    throw new SocketClosedException();
                }
                SocketContainer[] socketContainers = this.socketContainers;
                SocketContainer socketToReceiveFrom = null;
                long firstTime = -1L;
                for (SocketContainer socketContainer : socketContainers) {
                    long f = socketContainer.getFirstReceivedTime();
                    if (f <= 0L || firstTime != -1L && firstTime <= f) continue;
                    firstTime = f;
                    socketToReceiveFrom = socketContainer;
                }
                if (socketToReceiveFrom != null) {
                    socketToReceiveFrom.receive(p);
                    if (this.accept(p)) {
                        socketToReceiveFrom.accepted(p);
                        return;
                    }
                    ++this.numDiscardedPackets;
                    if (this.numDiscardedPackets % 100 != 1) continue;
                    this.logger.info("Discarded " + this.numDiscardedPackets + " packets. Last remote address:" + TransportAddress.redact(p.getSocketAddress()));
                    continue;
                }
                long waitTimeout = 500L;
                if (soTimeout > 0) {
                    long remaining = start + (long)soTimeout - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        throw new SocketTimeoutException();
                    }
                    waitTimeout = Math.min(waitTimeout, remaining);
                }
                try {
                    this.receiveLock.wait(waitTimeout);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeActive(IceSocketWrapper socketWrapper, TransportAddress remoteAddress) {
        Closeable socket = socketWrapper.getTCPSocket();
        if (socket == null) {
            socket = socketWrapper.getUDPSocket();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initializing the active container, socket=" + socket + "; remote address=" + TransportAddress.redact(remoteAddress));
        }
        Object object = this.socketContainersSyncRoot;
        synchronized (object) {
            if (this.active != null) {
                this.logger.warn("Active socket already initialized.");
            }
            SocketContainer newActive = null;
            for (SocketContainer container : this.socketContainers) {
                if (socket != container.datagramSocket && socket != container.delegatingSocket) continue;
                newActive = container;
                break;
            }
            if (newActive == null) {
                this.logger.error("No SocketContainer found!");
                return;
            }
            newActive.remoteAddress = remoteAddress;
            this.active = newActive;
        }
    }

    private class SocketContainer {
        private final DatagramSocket datagramSocket;
        private final DelegatingSocket delegatingSocket;
        private final ArrayBlockingQueue<Buffer> queue = new ArrayBlockingQueue(100);
        private final ArrayBlockingQueue<Buffer> pool = new ArrayBlockingQueue(10);
        private boolean closed = false;
        private SocketAddress remoteAddress = null;
        private Thread thread;

        SocketContainer(DelegatingSocket socket) {
            this.datagramSocket = null;
            this.delegatingSocket = Objects.requireNonNull(socket, "socket");
            this.init();
        }

        SocketContainer(DatagramSocket socket) {
            this.datagramSocket = Objects.requireNonNull(socket, "socket");
            this.delegatingSocket = null;
            this.init();
        }

        private void init() {
            this.thread = new Thread(){

                @Override
                public void run() {
                    SocketContainer.this.runInReaderThread();
                }
            };
            this.thread.setDaemon(true);
            this.thread.setName("MergingDatagramSocket reader thread for: " + this.getLocalSocketAddress() + " -> " + TransportAddress.redact(MergingDatagramSocket.this.getRemoteSocketAddress()));
            MergingDatagramSocket.this.logger.debug(() -> "Starting the thread for socket " + this.getLocalSocketAddress() + " -> " + TransportAddress.redact(MergingDatagramSocket.this.getRemoteSocketAddress()));
            this.thread.start();
        }

        private Buffer getFreeBuffer() {
            Buffer buffer = this.pool.poll();
            if (buffer == null) {
                buffer = new Buffer();
            }
            buffer.reset();
            return buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInReaderThread() {
            while (!this.closed && !Thread.currentThread().isInterrupted()) {
                Buffer buffer = this.getFreeBuffer();
                try {
                    if (!this.doReceive(buffer)) {
                        continue;
                    }
                }
                catch (IOException ioe) {
                    MergingDatagramSocket.this.logger.info("Failed to receive: " + ioe);
                    break;
                }
                if (this.closed || Thread.currentThread().isInterrupted()) break;
                try {
                    this.queue.put(buffer);
                    Object ioe = MergingDatagramSocket.this.receiveLock;
                    synchronized (ioe) {
                        MergingDatagramSocket.this.receiveLock.notify();
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            this.close(true);
            MergingDatagramSocket.this.logger.debug(() -> "Finished: " + this.toString());
        }

        private boolean doReceive(Buffer buffer) throws IOException {
            while (!this.closed && !Thread.currentThread().isInterrupted()) {
                try {
                    if (this.datagramSocket != null) {
                        this.datagramSocket.receive(buffer.pkt);
                    } else {
                        this.delegatingSocket.receive(buffer.pkt);
                    }
                    buffer.receivedTime = System.currentTimeMillis();
                    this.maybeUpdateActive();
                    return true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeUpdateActive() {
            SocketContainer active = MergingDatagramSocket.this.active;
            if (active != this) {
                Object object = MergingDatagramSocket.this.socketContainersSyncRoot;
                synchronized (object) {
                    MergingDatagramSocket.this.active = this;
                    MergingDatagramSocket.this.logger.debug(() -> "Switching to new active socket: " + this);
                }
            }
        }

        private void receive(DatagramPacket p) {
            Buffer buffer = this.queue.poll();
            if (buffer == null) {
                throw new IllegalStateException("Queue empty.");
            }
            byte[] dest = p.getData();
            int destOffset = p.getOffset();
            int len = Math.min(dest.length - destOffset, buffer.pkt.getLength());
            System.arraycopy(buffer.pkt.getData(), buffer.pkt.getOffset(), dest, destOffset, len);
            p.setLength(len);
            p.setSocketAddress(buffer.pkt.getSocketAddress());
            this.pool.offer(buffer);
        }

        private long getFirstReceivedTime() {
            Buffer nextBuffer = this.queue.peek();
            if (nextBuffer != null) {
                return nextBuffer.receivedTime;
            }
            return -1L;
        }

        private InetAddress getLocalAddress() {
            return this.datagramSocket != null ? this.datagramSocket.getLocalAddress() : this.delegatingSocket.getLocalAddress();
        }

        private int getLocalPort() {
            return this.datagramSocket != null ? this.datagramSocket.getLocalPort() : this.delegatingSocket.getLocalPort();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.datagramSocket != null ? this.datagramSocket.getLocalSocketAddress() : this.delegatingSocket.getLocalSocketAddress();
        }

        public String toString() {
            if (this.datagramSocket != null) {
                return this.datagramSocket.getLocalSocketAddress() + " -> " + TransportAddress.redact(this.remoteAddress);
            }
            return this.delegatingSocket.getLocalSocketAddress() + " -> " + TransportAddress.redact(this.remoteAddress);
        }

        private void send(DatagramPacket pkt) throws IOException {
            this.setTarget(pkt);
            if (this.datagramSocket != null) {
                this.datagramSocket.send(pkt);
            } else {
                this.delegatingSocket.send(pkt);
            }
        }

        private void setTarget(DatagramPacket pkt) {
            SocketAddress target = this.datagramSocket != null ? this.datagramSocket.getRemoteSocketAddress() : this.delegatingSocket.getRemoteSocketAddress();
            if (target == null) {
                target = this.remoteAddress;
            }
            pkt.setSocketAddress(target);
        }

        private void accepted(DatagramPacket pkt) {
            this.remoteAddress = pkt.getSocketAddress();
        }

        private Object getSocket() {
            return this.datagramSocket != null ? this.datagramSocket : this.delegatingSocket;
        }

        private void close(boolean remove) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.thread.interrupt();
            if (remove) {
                MergingDatagramSocket.this.doRemove(this.getSocket());
            }
        }

        private class Buffer {
            private static final int MAX_PACKET_SIZE = 1500;
            long receivedTime = -1L;
            DatagramPacket pkt = new DatagramPacket(new byte[1500], 0, 1500);

            private Buffer() {
            }

            private void reset() {
                this.receivedTime = -1L;
                this.pkt.setLength(1500);
            }
        }
    }
}

