/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.searchdemo;

import com.sun.java.help.impl.Parser;
import com.sun.java.help.impl.ParserEvent;
import com.sun.java.help.impl.ParserListener;
import com.sun.java.help.impl.Tag;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.text.BreakIterator;
import java.util.Vector;
import sunw.demo.searchdemo.Doc;
import sunw.demo.searchdemo.DocVector;
import sunw.demo.searchdemo.WordHashtable;
import sunw.demo.searchdemo.WordVector;

public class Index
implements ParserListener {
    String dbName = "JavaHelpIndex";
    PrintStream verbose;
    WordVector wordList = new WordVector(1000);
    DocVector docVec = new DocVector();
    short docNumber = 0;
    private ConfigFile config;
    private String title;
    private String header;
    private boolean firstheader = false;
    protected Vector tags;
    private WordHashtable table;
    private short wordCount;
    private Vector stopWords;
    private static boolean debugFlag = true;

    public static void main(String[] stringArray) {
        Index index = new Index();
        index.compile(stringArray);
    }

    public void compile(String[] stringArray) {
        int n;
        long l = System.currentTimeMillis();
        String string = null;
        Vector<String> vector = new Vector<String>();
        Vector vector2 = new Vector();
        String string2 = "";
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-db")) {
                if (n + 1 < stringArray.length) {
                    this.dbName = stringArray[++n];
                    continue;
                }
                System.out.println(stringArray[n] + "-db requires argument");
                continue;
            }
            if (stringArray[n].equals("-sourcepath")) {
                if (n + 1 < stringArray.length) {
                    string2 = stringArray[++n];
                    continue;
                }
                System.out.println(stringArray[n] + "-sourcepath requires argument");
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                this.verbose = System.out;
                continue;
            }
            if (stringArray[n].equals("-c")) {
                if (n + 1 < stringArray.length) {
                    string = stringArray[++n];
                    continue;
                }
                System.out.println(stringArray[n] + "-c requires argument");
                continue;
            }
            if (stringArray[n].startsWith("-")) {
                System.out.println("Unknown argument '" + stringArray[n] + "'");
                this.showUsage();
                return;
            }
            vector.addElement(stringArray[n]);
        }
        this.config = new ConfigFile(string, vector2);
        vector2 = this.config.getFiles();
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            vector2 = this.loadFiles((String)vector.elementAt(n), vector2);
        }
        this.stopWords = this.config.getStopWords();
        n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            DocFiles docFiles = (DocFiles)vector2.elementAt(n);
            System.out.println("   File: '" + docFiles.getFile() + "'");
            System.out.println("    URL: '" + docFiles.getURLString() + "'");
            this.title = null;
            this.header = null;
            this.table = new WordHashtable();
            this.firstheader = true;
            this.wordCount = 0;
            this.tags = new Vector();
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2 + docFiles.getFile()));
                Parser parser = new Parser((InputStream)bufferedInputStream);
                parser.addParserListener((ParserListener)this);
                parser.parse();
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("I/O exception occurred in file '" + string2 + docFiles.getFile() + "'");
                continue;
            }
            if (this.title == null || this.title.length() < 1) {
                this.title = this.header;
                if (this.title == null || this.title.length() < 1) {
                    this.title = "No Title";
                    Index.debug("  Title: ** No title found **");
                }
            }
            Index.debug("  Title: '" + this.title + "'");
            if (this.table.size() <= 0) continue;
            this.wordList.addWordHashtable(this.table, this.docNumber);
            this.docVec.addElement(new Doc(this.title, docFiles.getURLString()));
            int n3 = this.table.total();
            this.docNumber = (short)(this.docNumber + 1);
        }
        long l2 = System.currentTimeMillis() - l;
        if (this.wordList.size() > 0 && this.docVec.size() > 0) {
            try {
                System.out.println("Storing documents");
                FileOutputStream fileOutputStream = new FileOutputStream(this.dbName + ".dat");
                DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
                this.docVec.writeDocVector(dataOutputStream);
                dataOutputStream.flush();
                fileOutputStream.close();
                fileOutputStream = new FileOutputStream(this.dbName + ".inv");
                dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
                this.wordList.writeWordVector(dataOutputStream);
                dataOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("I/O exception occurred writing file '" + this.dbName + ".(inv,doc)");
                return;
            }
        }
        long l3 = System.currentTimeMillis() - l - l2;
        System.out.println("        Parse time: " + (double)l2 / 1000.0 + " s");
        System.out.println("      Compile time: " + (double)l3 / 1000.0 + " s");
        System.out.println("Documents compiled: " + this.docVec.size());
        System.out.println("   Word table size: " + this.wordList.size());
    }

    public void piFound(ParserEvent parserEvent) {
    }

    public void doctypeFound(ParserEvent parserEvent) {
    }

    public void tagFound(ParserEvent parserEvent) {
        Tag tag = parserEvent.getTag();
        if (tag.name.compareTo("H") == 0) {
            if (tag.isEnd) {
                this.tags.removeElement(this.tags.lastElement());
                this.firstheader = false;
                return;
            }
            this.tags.addElement(tag);
        } else if (tag.name.compareTo("TITLE") == 0) {
            if (tag.isEnd) {
                this.tags.removeElement(this.tags.lastElement());
                return;
            }
            this.tags.addElement(tag);
        }
    }

    public void textFound(ParserEvent parserEvent) {
        String string = parserEvent.getText();
        if (this.tags.size() > 0) {
            Tag tag = (Tag)this.tags.lastElement();
            if (tag.name.compareTo("TITLE") == 0) {
                if (this.title == null) {
                    this.title = string.trim();
                } else {
                    this.title.concat(string.trim());
                }
                this.parseIntoWords(string, (short)10);
            } else if (tag.name.compareTo("H") == 0) {
                if (this.firstheader) {
                    if (this.header == null) {
                        this.header = string.trim();
                    } else {
                        this.header.concat(string.trim());
                    }
                }
                this.parseIntoWords(string, (short)5);
            } else {
                this.parseIntoWords(string, (short)1);
            }
        } else {
            this.parseIntoWords(string, (short)1);
        }
    }

    private void parseIntoWords(String string, short s) {
        int n = this.stopWords.size();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != -1) {
            int n4;
            String string2 = new String(string.substring(n2, n3));
            string2 = string2.toLowerCase();
            string2 = string2.trim();
            for (n4 = 0; n4 < n; ++n4) {
                if (string2.compareTo((String)this.stopWords.elementAt(n4)) != 0) continue;
            }
            if (string2.length() > 1) {
                this.wordCount = (short)(this.wordCount + 1);
                this.table.addWord(string2, s, this.wordCount);
            } else if (string2.length() == 1 && ((n4 = Character.getType(string2.charAt(0))) == 9 || n4 == 10 || n4 == 2 || n4 == 5 || n4 == 11 || n4 == 3 || n4 == 0 || n4 == 1)) {
                this.wordCount = (short)(this.wordCount + 1);
                this.table.addWord(string2, s, this.wordCount);
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
    }

    public void commentFound(ParserEvent parserEvent) {
    }

    public void errorFound(ParserEvent parserEvent) {
        System.out.println(parserEvent.getText());
    }

    public Vector loadFiles(String string, Vector vector) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                vector = this.loadFiles(file.getPath() + File.separator + stringArray[i], vector);
            }
        } else if (string.endsWith(".html") || string.endsWith(".htm")) {
            DocFiles docFiles = new DocFiles(string, this.config.getURLString(string));
            vector.addElement(docFiles);
        }
        return vector;
    }

    public void showUsage() {
        System.out.println(" Usage:   java JavaHelp.Index options file ...");
        System.out.println(" Options: -c file   config file");
        System.out.println("          -db file  generated database file name");
        System.out.println("          -verbose  verbose documentation");
        System.out.println("Note: config file composition:");
        System.out.println("          IndexRemove /public_html/JavaHelp/demo");
        System.out.println("          IndexPrepend ..");
        System.out.println("          StopWords word1 ... wordN");
        System.out.println("          File /public_html/JavaHelp/demo/first.html");
        System.out.println("          File=/public_html/JavaHelp/demo/second.html");
        System.out.println("          ...");
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("Index: " + string);
        }
    }

    class ConfigFile {
        private String remove;
        private String prepend;
        private Vector stopWords;
        private String[] defStopWords = new String[]{"a", "about", "above", "according", "across", "actually", "adj", "after", "afterwards", "again", "against", "all", "almost", "alone", "along", "already", "also", "although", "always", "among", "amongst", "an", "and", "another", "any", "anyhow", "anyone", "anything", "anywhere", "are", "aren", "aren't", "around", "as", "at", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "begin", "beginning", "behind", "being", "below", "beside", "besides", "between", "beyond", "billion", "both", "but", "by", "can", "can't", "cannot", "caption", "co", "could", "couldn", "couldn't", "did", "didn", "didn't", "do", "does", "doesn", "doesn't", "don", "don't", "down", "during", "each", "eg", "eight", "eighty", "either", "else", "elsewhere", "end", "ending", "enough", "etc", "even", "ever", "every", "everyone", "everything", "everywhere", "except", "few", "fifty", "first", "five", "for", "former", "formerly", "forty", "found", "four", "from", "further", "had", "has", "hasn", "hasn't", "have", "haven", "haven't", "he", "hence", "her", "here", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "him", "himself", "his", "how", "however", "hundred", "ie", "i.e.", "if", "in", "inc", "inc.", "indeed", "instead", "into", "is", "isn", "isn't", "it", "its", "itself", "last", "later", "latter", "latterly", "least", "less", "let", "like", "likely", "ll", "ltd", "made", "make", "makes", "many", "maybe", "me", "meantime", "meanwhile", "might", "million", "miss", "more", "moreover", "most", "mostly", "mr", "mrs", "much", "must", "my", "myself", "namely", "neither", "never", "nevertheless", "next", "nine", "ninety", "no", "nobody", "none", "nonetheless", "noone", "nor", "not", "nothing", "now", "nowhere", "of", "off", "often", "on", "once", "one", "only", "onto", "or", "other", "others", "otherwise", "our", "ours", "ourselves", "out", "over", "overall", "own", "per", "perhaps", "rather", "re", "recent", "recently", "same", "seem", "seemed", "seeming", "seems", "seven", "seventy", "several", "she", "should", "shouldn", "shouldn't", "since", "six", "sixty", "so", "some", "somehow", "someone", "something", "sometime", "sometimes", "somewhere", "still", "stop", "such", "taking", "ten", "than", "that", "the", "their", "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "therefore", "therein", "thereupon", "these", "they", "thirty", "this", "those", "though", "thousand", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "toward", "towards", "trillion", "twenty", "two", "under", "unless", "unlike", "unlikely", "until", "up", "upon", "us", "used", "using", "ve", "very", "via", "was", "wasn", "we", "we", "well", "were", "weren", "weren't", "what", "whatever", "when", "whence", "whenever", "where", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "whoever", "whole", "whom", "whomever", "whose", "why", "will", "with", "within", "without", "won", "would", "wouldn", "wouldn't", "yes", "yet", "you", "your", "yours", "yourself", "yourselves"};
        private Vector files;

        public ConfigFile(String string, Vector vector) {
            this.files = vector;
            String string2 = new String("IndexRemove ");
            String string3 = new String("IndexPrepend ");
            String string4 = new String("File ");
            String string5 = new String("StopWords ");
            this.stopWords = new Vector();
            if (string == null) {
                return;
            }
            try {
                String string6;
                LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
                while ((string6 = lineNumberReader.readLine()) != null) {
                    String string7;
                    if (string6.startsWith(string2)) {
                        this.remove = string6.substring(string2.length(), string6.length());
                        continue;
                    }
                    if (string6.startsWith(string3)) {
                        this.prepend = string6.substring(string3.length(), string6.length());
                        continue;
                    }
                    if (string6.startsWith(string4)) {
                        string7 = string6.substring(string4.length(), string6.length());
                        String string8 = this.getURLString(string7);
                        DocFiles docFiles = new DocFiles(string7, string8);
                        vector.addElement(docFiles);
                        continue;
                    }
                    if (string6.startsWith(string5)) {
                        string7 = string6.substring(string5.length(), string6.length());
                        BreakIterator breakIterator = BreakIterator.getWordInstance();
                        breakIterator.setText(string7);
                        int n = breakIterator.first();
                        int n2 = breakIterator.next();
                        while (n2 != -1) {
                            String string9 = new String(string7.substring(n, n2));
                            string9 = string9.toLowerCase();
                            string9 = string9.trim();
                            this.stopWords.addElement(string9);
                            n = n2;
                            n2 = breakIterator.next();
                        }
                        continue;
                    }
                    System.out.println("Unknown Config Keyword at line " + lineNumberReader.getLineNumber());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getURLString(String string) {
            String string2 = this.remove != null && string.startsWith(this.remove) ? string.substring(this.remove.length(), string.length()) : string;
            if (this.prepend != null) {
                string2 = this.prepend + string2;
            }
            return string2;
        }

        public Vector getStopWords() {
            if (this.stopWords.size() == 0) {
                for (int i = 0; i < this.defStopWords.length; ++i) {
                    this.stopWords.addElement(this.defStopWords[i]);
                }
            }
            return this.stopWords;
        }

        public Vector getFiles() {
            return this.files;
        }
    }

    class DocFiles {
        private String file;
        private String url;

        public DocFiles(String string, String string2) {
            this.file = string;
            this.url = string2;
        }

        public String getFile() {
            return this.file;
        }

        public String getURLString() {
            return this.url;
        }
    }
}

