/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jde.debugger.Protocol;

public class Rep
implements Protocol {
    public static String getLocationRep(Location loc) {
        StringBuffer locationString = new StringBuffer();
        locationString.append("(list \"");
        locationString.append(loc.declaringType().name());
        locationString.append("\"");
        try {
            locationString.append(" \"");
            locationString.append(loc.sourceName());
            locationString.append("\"");
        }
        catch (AbsentInformationException ex) {
            locationString.append(" nil");
        }
        locationString.append(" ");
        locationString.append(loc.lineNumber());
        locationString.append(")");
        return locationString.toString();
    }

    static String getMethodRep(Method m) {
        List<String> l = m.argumentTypeNames();
        StringBuffer argList = new StringBuffer("(list");
        Iterator<String> it = l.iterator();
        while (it.hasNext()) {
            argList.append(" \"");
            argList.append(it.next().toString());
            argList.append("\"");
        }
        argList.append(")");
        return "(list \"" + m.declaringType().name() + "\"" + " \"" + m.name() + "\"" + " \"" + m.returnTypeName() + "\"" + Protocol.BR + argList.toString() + (m.isFinal() ? " \"final\"" : "") + (m.isStatic() ? " \"static\"" : "") + (m.isNative() ? " \"native\"" : "") + (m.isConstructor() ? " \"constructor\"" : "") + (m.isAbstract() ? " \"abstract\"" : "") + (m.isSynchronized() ? " \"synchronized\"" : "") + (m.isStaticInitializer() ? " \"static_initializer\"" : "") + ")";
    }

    public static String getLocalVariableRep(LocalVariable lv) {
        return "(list \"" + lv.name() + "\" \"" + lv.typeName() + "\")";
    }

    public static String getLocalVariableValueRep(LocalVariable lv, Value v) {
        return "(cons " + Rep.getLocalVariableRep(lv) + " " + Rep.getValueRep(v) + ")";
    }

    public static String getLocalVariableValueMapRep(Map map) {
        StringBuffer localVariablesValuesString = new StringBuffer("(list ");
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            LocalVariable localVariable = (LocalVariable)iter.next();
            Value val = (Value)map.get(localVariable);
            localVariablesValuesString.append(Protocol.BR);
            localVariablesValuesString.append(Rep.getLocalVariableValueRep(localVariable, val));
        }
        localVariablesValuesString.append(")");
        return localVariablesValuesString.toString();
    }

    static String getFieldRep(Field f) {
        return "(list \"" + f.name() + "\"" + " \"" + f.typeName() + "\"" + (f.isTransient() ? " \"transient\"" : "") + (f.isVolatile() ? " \"volatile\"" : "") + (f.isFinal() ? " \"final\"" : "") + (f.isStatic() ? " \"static\"" : "") + ")";
    }

    static String getFieldValueRep(Field f, Value v) {
        return "(cons " + Rep.getFieldRep(f) + " " + Rep.getValueRep(v) + ")";
    }

    static String getFieldValueMapRep(Map map) {
        StringBuffer fieldsValuesString = new StringBuffer("(list ");
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            Value val = (Value)map.get(field);
            fieldsValuesString.append(Protocol.BR);
            fieldsValuesString.append(Rep.getFieldValueRep(field, val));
        }
        fieldsValuesString.append(")");
        return fieldsValuesString.toString();
    }

    private static String filterFPValue(String fpValue) {
        if (fpValue.equals("NaN")) {
            return "\"NaN\"";
        }
        if (fpValue.equals("-Infinity")) {
            return "\"-Infinity\"";
        }
        if (fpValue.equals("Infinity")) {
            return "\"Infinity\"";
        }
        return fpValue;
    }

    public static String getValueRep(Value value) {
        if (value == null) {
            return "(list \"null\")";
        }
        if (value instanceof VoidValue) {
            return "(list \"void\")";
        }
        if (value instanceof ObjectReference) {
            return Rep.getObjectRep((ObjectReference)value);
        }
        PrimitiveValue v = (PrimitiveValue)value;
        if (v instanceof BooleanValue) {
            return "(list \"boolean\" \"" + v.booleanValue() + "\")";
        }
        if (v instanceof ByteValue) {
            return "(list \"byte\" \"" + v.byteValue() + "\")";
        }
        if (v instanceof CharValue) {
            return "(list \"char\" \"" + Rep.escapeString(String.valueOf(v.charValue())) + "\")";
        }
        if (v instanceof DoubleValue) {
            return "(list \"double\" " + Rep.filterFPValue(String.valueOf(v.doubleValue())) + ")";
        }
        if (v instanceof FloatValue) {
            return "(list \"float\" " + Rep.filterFPValue(String.valueOf(v.floatValue())) + ")";
        }
        if (v instanceof IntegerValue) {
            return "(list \"int\" \"" + v.intValue() + "\")";
        }
        if (v instanceof LongValue) {
            return "(list \"long\" \"" + v.longValue() + "\")";
        }
        if (v instanceof ShortValue) {
            return "(list \"short\" " + v.shortValue() + ")";
        }
        return null;
    }

    public static String getArrayRep(ArrayReference a, String elements) {
        if (a == null) {
            return "\"Error! null array reference in Rep.getArrayRep!\"";
        }
        return "(list \"" + a.referenceType().name() + "\"" + " " + a.uniqueID() + (a.isCollected() ? " 't" : " nil") + " " + a.length() + elements + ")";
    }

    public static String escapeString(String str) {
        if (str.indexOf(92) == -1 && str.indexOf(34) == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length() + 16);
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getStringRep(StringReference s) {
        if (s == null) {
            return "\"Error!\"";
        }
        return "(list \"" + s.referenceType().name() + "\"" + " " + s.uniqueID() + (s.isCollected() ? " 't" : " nil") + " \"" + Rep.escapeString(s.value()) + "\")";
    }

    public static String getObjectRep(ObjectReference o) {
        return Rep.getObjectRep(o, false);
    }

    public static String getObjectRep(ObjectReference o, boolean detailed) {
        if (o == null) {
            return "(list \"null\")";
        }
        if (detailed) {
            String fieldsValuesString;
            try {
                fieldsValuesString = Rep.getFieldValueMapRep(o.getValues(o.referenceType().visibleFields()));
            }
            catch (ClassNotPreparedException ex) {
                fieldsValuesString = "\"The class isn't prepared\"";
            }
            catch (ObjectCollectedException ex) {
                fieldsValuesString = "\"The object has already been collected\"";
            }
            catch (Exception ex) {
                fieldsValuesString = "\"Unable to access fields and values. Optimized class?\"";
            }
            return "(list \"" + o.referenceType().name() + "\"" + " " + o.uniqueID() + (o.isCollected() ? " 't" : " nil") + Protocol.BR + fieldsValuesString + ")";
        }
        return "(list \"" + o.referenceType().name() + "\"" + " " + o.uniqueID() + (o.isCollected() ? " 't" : " nil") + ")";
    }

    public static String getObjectMonitorsRep(ObjectReference o) {
        String waitingThreadsString;
        String owningThread;
        if (o == null) {
            return "null";
        }
        try {
            ThreadReference t = o.owningThread();
            owningThread = t == null ? "nil" : Rep.getThreadRep(t);
        }
        catch (IncompatibleThreadStateException ex) {
            owningThread = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            owningThread = "\"VM has no information\"";
        }
        StringBuffer waitingThreadsStringBuffer = new StringBuffer("(list");
        try {
            List<ThreadReference> waitingThreads = o.waitingThreads();
            Iterator<ThreadReference> it = waitingThreads.iterator();
            while (it.hasNext()) {
                waitingThreadsStringBuffer.append(Protocol.BR);
                waitingThreadsStringBuffer.append(Rep.getThreadRep(it.next()));
            }
            waitingThreadsStringBuffer.append(")");
            waitingThreadsString = waitingThreadsStringBuffer.toString();
        }
        catch (IncompatibleThreadStateException ex) {
            waitingThreadsString = "\"Information Not Available\"";
        }
        catch (UnsupportedOperationException ex) {
            waitingThreadsString = "\"VM has no information\"";
        }
        return "(list " + o.uniqueID() + " " + "\"" + o.referenceType().name() + "\"" + (o.isCollected() ? " 't" : " nil") + Protocol.BR + owningThread + Protocol.BR + waitingThreadsString + ")";
    }

    public static String getThreadGroupRep(ThreadGroupReference t) {
        StringBuffer rep = new StringBuffer("(list \"ThreadGroup\" ");
        rep.append(t.uniqueID());
        rep.append(" \"");
        rep.append(t.name());
        rep.append("\" ");
        List<ObjectReference> list = t.threads();
        Iterator<ObjectReference> it = list.iterator();
        rep.append(Protocol.BR);
        rep.append("(list");
        while (it.hasNext()) {
            rep.append(Protocol.BR);
            rep.append(Rep.getThreadRep(it.next()));
        }
        rep.append(")");
        list = t.threadGroups();
        it = list.iterator();
        rep.append(Protocol.BR);
        rep.append("(list");
        while (it.hasNext()) {
            rep.append(Protocol.BR);
            rep.append(Rep.getThreadGroupRep((ThreadGroupReference)it.next()));
        }
        rep.append("))");
        return rep.toString();
    }

    public static String getThreadRep(ThreadReference t) {
        return Rep.getThreadRep(t, true);
    }

    public static String getThreadRep(ThreadReference t, boolean detailed) {
        int status = t.status();
        String statusString = "unknown";
        switch (status) {
            case 3: {
                statusString = "waiting on monitor";
                break;
            }
            case 5: {
                statusString = "not started";
                break;
            }
            case 1: {
                statusString = "runnable";
                break;
            }
            case 2: {
                statusString = "sleeping";
                break;
            }
            case 4: {
                statusString = "waiting";
                break;
            }
            case 0: {
                statusString = "zombie";
                break;
            }
            case -1: {
                statusString = "unknown";
                break;
            }
        }
        String stateString = "normal";
        if (t.isAtBreakpoint()) {
            stateString = "suspended at breakpoint";
        } else if (t.suspendCount() > 0) {
            stateString = "suspended by debugger";
        }
        if (detailed) {
            String currentContendedMonitorString;
            String ownedMonitorsString;
            String stackString;
            StringBuffer stackStringBuffer = new StringBuffer("(list");
            try {
                List<StackFrame> stackFrames = t.frames();
                Iterator<StackFrame> it = stackFrames.iterator();
                int index = 0;
                while (it.hasNext()) {
                    stackStringBuffer.append(Protocol.BR);
                    stackStringBuffer.append(Rep.getStackFrameRep(it.next(), index++));
                }
                stackStringBuffer.append(")");
                stackString = stackStringBuffer.toString();
            }
            catch (IncompatibleThreadStateException ex) {
                stackString = "\"Information Not Available\"";
            }
            StringBuffer ownedMonitorsStringBuffer = new StringBuffer("(list");
            try {
                List<ObjectReference> ownedMonitors = t.ownedMonitors();
                Iterator<ObjectReference> it = ownedMonitors.iterator();
                while (it.hasNext()) {
                    ownedMonitorsStringBuffer.append(Protocol.BR);
                    ownedMonitorsStringBuffer.append(Rep.getObjectRep(it.next()));
                }
                ownedMonitorsStringBuffer.append(")");
                ownedMonitorsString = ownedMonitorsStringBuffer.toString();
            }
            catch (IncompatibleThreadStateException ex) {
                ownedMonitorsString = "\"Information Not Available\"";
            }
            catch (UnsupportedOperationException ex) {
                ownedMonitorsString = "\"VM has no information\"";
            }
            catch (ObjectCollectedException ex) {
                ownedMonitorsString = "\"The object has been collected\"";
            }
            try {
                ObjectReference o = t.currentContendedMonitor();
                currentContendedMonitorString = o == null ? "nil" : Rep.getObjectRep(o);
            }
            catch (IncompatibleThreadStateException ex) {
                currentContendedMonitorString = "\"Information Not Available\"";
            }
            catch (UnsupportedOperationException ex) {
                currentContendedMonitorString = "\"VM has no information\"";
            }
            catch (ObjectCollectedException ex) {
                currentContendedMonitorString = "\"The object has been collected\"";
            }
            return "(list \"Thread\" " + t.uniqueID() + " \"" + t.name() + "\"" + " \"" + statusString + "\"" + " \"" + stateString + "\"" + Protocol.BR + stackString + Protocol.BR + ownedMonitorsString + Protocol.BR + currentContendedMonitorString + ")";
        }
        return "(list \"Thread\" " + t.uniqueID() + " \"" + t.name() + "\"" + " \"" + statusString + "\"" + " \"" + stateString + "\")";
    }

    static String getStackFrameRep(StackFrame s, int index) {
        try {
            Location loc = s.location();
            Method method = loc.method();
            return "(list " + index + " " + "\"" + loc.declaringType().name() + "\" " + "\"" + Rep.escapeString(loc.sourceName()) + "\" " + loc.lineNumber() + " " + "\"" + method.name() + "\")";
        }
        catch (AbsentInformationException ex) {
            return "(list \"StackFrame\" " + index + " \"Information not available\")";
        }
    }
}

