from __future__ import annotations

# Standard librarary imports
from typing import Any, TypedDict

from ..common.by import _ByType
from ..common.keys import _KeySeq
from ..remote.webdriver import WebDriver

class _Point(TypedDict):
    x: int
    y: int

class _Size(TypedDict):
    width: int
    height: int

class _Rect(_Point, _Size):
    ...

class WebElement:

    @property
    def tag_name(self) -> str: ...
    @property
    def text(self) -> str: ...
    def click(self) -> None: ...
    def submit(self) -> None: ...
    def clear(self) -> None: ...
    def get_property(self, name: str) -> Any: ...
    def get_attribute(self, name: str) -> Any: ...
    def is_selected(self) -> bool: ...
    def is_enabled(self) -> bool: ...
    def find_element(self, by: _ByType, selector: str) -> WebElement: ...
    def find_elements(self, by: _ByType, selector: str) -> list[WebElement]: ...
    def send_keys(self, *value: _KeySeq) -> None: ...
    def is_displayed(self) -> bool: ...
    @property
    def location_once_scrolled_into_view(self) -> _Point: ...
    @property
    def size(self) -> _Size: ...
    def value_of_css_property(self, property_name: str) -> str: ...
    @property
    def location(self) -> _Point: ...
    @property
    def rect(self) -> _Rect: ...
    @property
    def screenshot_as_base64(self) -> bytes: ...
    @property
    def screenshot_as_png(self) -> bytes: ...
    def screenshot(self, filename: str) -> bool: ...
    @property
    def parent(self) -> WebDriver: ...
