/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0.0lf / -1.3333333333333333lf) => -0.0lf
 * (0.0lf / 0.85lf) => 0.0lf
 * (-1.3333333333333333lf / -1.3333333333333333lf) => 1.0lf
 * (-1.3333333333333333lf / 0.85lf) => -1.5686274509803921lf
 * (0.85lf / -1.3333333333333333lf) => -0.6375000000000001lf
 * (0.85lf / 0.85lf) => 1.0lf
 */
#version 400

void main()
{
  double[distance((0.0lf / -1.3333333333333333lf), -0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance((0.0lf / 0.85lf), 0.0lf) <= 0.0lf ? 1 : -1] array1;
  double[distance((-1.3333333333333333lf / -1.3333333333333333lf), 1.0lf) <= 1e-05lf ? 1 : -1] array2;
  double[distance((-1.3333333333333333lf / 0.85lf), -1.5686274509803921lf) <= 1.568627450980392e-05lf ? 1 : -1] array3;
  double[distance((0.85lf / -1.3333333333333333lf), -0.6375000000000001lf) <= 6.375000000000001e-06lf ? 1 : -1] array4;
  double[distance((0.85lf / 0.85lf), 1.0lf) <= 1e-05lf ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
