"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AlertService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend GET Alerts API.
     */
    _defineProperty(this, "getAlerts", async (context, request, response) => {
      try {
        const {
          detectorType,
          detector_id,
          sortOrder,
          size,
          startTime,
          endTime
        } = request.query;
        const defaultParams = {
          sortOrder,
          size,
          startTime,
          endTime
        };
        let params;
        if (detector_id) {
          params = {
            ...defaultParams,
            detector_id
          };
        } else if (detectorType) {
          params = {
            ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }
        const client = this.getClient(request, context);
        const getAlertsResponse = await client(_constants.CLIENT_ALERTS_METHODS.GET_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    /**
     * Calls backend POST Acknowledge Alerts API.
     */
    _defineProperty(this, "acknowledgeAlerts", async (context, request, response) => {
      try {
        const {
          detector_id
        } = request.params;
        const {
          alerts
        } = request.body;
        const body = {
          alerts: alerts
        };
        const params = {
          body,
          detector_id
        };
        const client = this.getClient(request, context);
        const acknowledgeAlertsResponse = await client(_constants.CLIENT_ALERTS_METHODS.ACKNOWLEDGE_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: acknowledgeAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - acknowledgeAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getThreatIntelAlerts", async (context, request, response) => {
      try {
        const params = request.query;
        // Delete the dataSourceId since this query param is not supported by the alerts API
        delete params['dataSourceId'];
        const client = this.getClient(request, context);
        const getAlertsResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.GET_THREAT_INTEL_ALERTS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getAlertsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - getThreatIntelAlerts:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "updateThreatIntelAlertsState", async (context, request, response) => {
      try {
        const params = request.query;
        // Delete the dataSourceId since this query param is not supported by the alerts API
        delete params['dataSourceId'];
        const client = this.getClient(request, context);
        const updateStatusResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.UPDATE_THREAT_INTEL_ALERTS_STATE, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: updateStatusResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - AlertService - updateThreatIntelAlertsState:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = AlertService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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