"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRelevancePlugin = void 0;
var _operators = require("rxjs/operators");
var _routes = require("./routes");
var _metrics_service = require("./metrics/metrics_service");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class SearchRelevancePlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "config$", void 0);
    _defineProperty(this, "logger", void 0);
    _defineProperty(this, "metricsService", void 0);
    this.config$ = this.initializerContext.config.create();
    this.logger = this.initializerContext.logger.get();
    this.metricsService = new _metrics_service.MetricsService(this.logger.get('metrics-service'));
  }
  async setup(core, {
    dataSource
  }) {
    const dataSourceEnabled = !!dataSource;
    this.logger.debug('SearchRelevance: Setup');
    const config = await this.config$.pipe((0, _operators.first)()).toPromise();
    const metricsService = this.metricsService.setup(config.metrics.metricInterval, config.metrics.windowSize);
    const router = core.http.createRouter();
    let opensearchSearchRelevanceClient = undefined;
    opensearchSearchRelevanceClient = core.opensearch.legacy.createClient('opensearch_search_relevance');

    // @ts-ignore
    core.http.registerRouteHandlerContext('searchRelevance', (context, request) => {
      return {
        logger: this.logger,
        relevancyWorkbenchClient: opensearchSearchRelevanceClient,
        metricsService: metricsService
      };
    });

    // Register server side APIs
    (0, _routes.defineRoutes)(router, core.opensearch, dataSourceEnabled);
    return {};
  }
  start(core) {
    this.logger.debug('SearchRelevance: Started');
    return {};
  }
  stop() {}
}
exports.SearchRelevancePlugin = SearchRelevancePlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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