"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
var _DataStreamService = require("./DataStreamService");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class ManagedIndexService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    // TODO: Not finished, need UI page that uses this first
    _defineProperty(this, "getManagedIndex", async (context, request, response) => {
      try {
        const {
          id
        } = request.params;
        const params = {
          id,
          index: _constants.INDEX.OPENDISTRO_ISM_CONFIG
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const results = await callWithRequest("search", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: results
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - getManagedIndex:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "getManagedIndices", async (context, request, response) => {
      try {
        const {
          from,
          size,
          sortDirection,
          sortField,
          terms,
          indices,
          dataStreams,
          showDataStreams
        } = request.query;
        const managedIndexSorts = {
          index: "managed_index.index",
          policyId: "managed_index.policy_id"
        };
        const explainParams = {
          sortField: sortField ? managedIndexSorts[sortField] : null,
          sortOrder: sortDirection,
          queryString: (0, _helpers.getSearchString)(terms, indices, dataStreams, showDataStreams),
          from: from,
          size: size
        };
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const [explainAllResponse, indexToDataStreamMapping] = await Promise.all([callWithRequest("ism.explainAll", explainParams), (0, _DataStreamService.getIndexToDataStreamMapping)(callWithRequest)]);
        const managedIndices = [];
        for (const indexName in explainAllResponse) {
          if (indexName == "total_managed_indices") continue;
          const metadata = explainAllResponse[indexName];

          // If showDataStreams is not true, then skip the managed index if it belongs to a data stream.
          const parentDataStream = indexToDataStreamMapping[metadata.index] || null;
          if (!showDataStreams && parentDataStream !== null) continue;
          let policy, seqNo, primaryTerm, getResponse;
          try {
            getResponse = await callWithRequest("ism.getPolicy", {
              policyId: metadata.policy_id
            });
          } catch (err) {
            if (err.statusCode === 404 && err.body.error.reason === "Policy not found") {
              console.log("managed index with not existing policy");
            } else {
              throw err;
            }
          }
          policy = _lodash.default.get(getResponse, "policy", null);
          seqNo = _lodash.default.get(getResponse, "_seq_no", null);
          primaryTerm = _lodash.default.get(getResponse, "_primary_term", null);
          managedIndices.push({
            index: metadata.index,
            indexUuid: metadata.index_uuid,
            dataStream: parentDataStream,
            policyId: metadata.policy_id,
            policySeqNo: seqNo,
            policyPrimaryTerm: primaryTerm,
            policy: policy,
            enabled: metadata.enabled,
            managedIndexMetaData: (0, _helpers.transformManagedIndexMetaData)(metadata)
          });
        }
        let totalManagedIndices = explainAllResponse.total_managed_indices;
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              managedIndices: managedIndices,
              totalManagedIndices: totalManagedIndices
            }
          }
        });
      } catch (err) {
        if (err.statusCode === 404 && err.body.error.type === "index_not_found_exception") {
          return response.custom({
            statusCode: 200,
            body: {
              ok: true,
              response: {
                managedIndices: [],
                totalManagedIndices: 0
              }
            }
          });
        }
        console.error("Index Management - ManagedIndexService - getManagedIndices", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "retryManagedIndexPolicy", async (context, request, response) => {
      try {
        const {
          index,
          state = null
        } = request.body;
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const params = {
          index: index.join(",")
        };
        if (state) params.body = {
          state
        };
        const retryResponse = await callWithRequest("ism.retry", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: retryResponse.failures,
              updatedIndices: retryResponse.updated_indices,
              // TODO: remove ternary after fixing retry API to return empty array even if no failures
              failedIndices: retryResponse.failed_indices ? retryResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              })) : []
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - retryManagedIndexPolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "changePolicy", async (context, request, response) => {
      try {
        const {
          indices,
          policyId,
          include,
          state
        } = request.body;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const params = {
          index: indices.join(","),
          body: {
            policy_id: policyId,
            include,
            state
          }
        };
        const changeResponse = await callWithRequest("ism.change", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: changeResponse.failures,
              updatedIndices: changeResponse.updated_indices,
              failedIndices: changeResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              }))
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - changePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    _defineProperty(this, "removePolicy", async (context, request, response) => {
      try {
        const {
          indices
        } = request.body;
        const callWithRequest = this.getClientBasedOnDataSource(context, request);
        const params = {
          index: indices.join(",")
        };
        const addResponse = await callWithRequest("ism.remove", params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              failures: addResponse.failures,
              updatedIndices: addResponse.updated_indices,
              failedIndices: addResponse.failed_indices.map(failedIndex => ({
                indexName: failedIndex.index_name,
                indexUuid: failedIndex.index_uuid,
                reason: failedIndex.reason
              }))
            }
          }
        });
      } catch (err) {
        console.error("Index Management - ManagedIndexService - removePolicy:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
  }
}
exports.default = ManagedIndexService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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