"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetAllMocks = exports.readUuidFileMock = exports.gitRevExecMock = exports.devConfigMock = exports.packageMock = exports.mockedRootDir = void 0;
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const path_1 = require("path");
const childProcessModule = jest.requireActual('child_process');
const fsModule = jest.requireActual('fs');
exports.mockedRootDir = '/root';
exports.packageMock = {
    raw: {},
};
jest.doMock(path_1.join(exports.mockedRootDir, 'package.json'), () => exports.packageMock.raw, { virtual: true });
exports.devConfigMock = {
    raw: {},
};
jest.doMock(path_1.join(exports.mockedRootDir, 'config', 'apm.dev.js'), () => exports.devConfigMock.raw, {
    virtual: true,
});
exports.gitRevExecMock = jest.fn();
jest.doMock('child_process', () => ({
    ...childProcessModule,
    execSync: (command, options) => {
        if (command.startsWith('git rev-parse')) {
            return exports.gitRevExecMock(command, options);
        }
        return childProcessModule.execSync(command, options);
    },
}));
exports.readUuidFileMock = jest.fn();
jest.doMock('fs', () => ({
    ...fsModule,
    readFileSync: (path, options) => {
        if (path.endsWith('uuid')) {
            return exports.readUuidFileMock(path, options);
        }
        return fsModule.readFileSync(path, options);
    },
}));
exports.resetAllMocks = () => {
    exports.packageMock.raw = {};
    exports.devConfigMock.raw = {};
    exports.gitRevExecMock.mockReset();
    exports.readUuidFileMock.mockReset();
    jest.resetModules();
};
