"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTextArea", {
  enumerable: true,
  get: function get() {
    return _text_area.EuiTextArea;
  }
});
Object.defineProperty(exports, "EuiCompressedTextArea", {
  enumerable: true,
  get: function get() {
    return _text_area.EuiCompressedTextArea;
  }
});
exports.OuiCompressedTextArea = exports.OuiTextArea = exports.RESIZE = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _validatable_control = require("../validatable_control");

var _text_area = require("../../../eui_components/form/text_area/text_area");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var resizeToClassNameMap = {
  vertical: 'ouiTextArea--resizeVertical',
  horizontal: 'ouiTextArea--resizeHorizontal',
  both: 'ouiTextArea--resizeBoth',
  none: 'ouiTextArea--resizeNone'
};
var RESIZE = Object.keys(resizeToClassNameMap);
exports.RESIZE = RESIZE;

var OuiTextArea = function OuiTextArea(_ref) {
  var children = _ref.children,
      className = _ref.className,
      compressed = _ref.compressed,
      _ref$fullWidth = _ref.fullWidth,
      fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
      id = _ref.id,
      inputRef = _ref.inputRef,
      isInvalid = _ref.isInvalid,
      name = _ref.name,
      placeholder = _ref.placeholder,
      _ref$resize = _ref.resize,
      resize = _ref$resize === void 0 ? 'vertical' : _ref$resize,
      rows = _ref.rows,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "compressed", "fullWidth", "id", "inputRef", "isInvalid", "name", "placeholder", "resize", "rows"]);
  var classes = (0, _classnames.default)('ouiTextArea', resizeToClassNameMap[resize], {
    'ouiTextArea--fullWidth': fullWidth,
    'ouiTextArea--compressed': compressed
  }, className);
  var definedRows;

  if (rows) {
    definedRows = rows;
  } else if (compressed) {
    definedRows = 3;
  } else {
    definedRows = 6;
  }

  return /*#__PURE__*/_react.default.createElement(_validatable_control.OuiValidatableControl, {
    isInvalid: isInvalid
  }, /*#__PURE__*/_react.default.createElement("textarea", (0, _extends2.default)({
    className: classes
  }, rest, {
    rows: definedRows,
    name: name,
    id: id,
    ref: inputRef,
    placeholder: placeholder
  }), children));
}; // @internal


exports.OuiTextArea = OuiTextArea;
OuiTextArea.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  isInvalid: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  compressed: _propTypes.default.bool,

  /**
       * Which direction, if at all, should the textarea resize
       */
  resize: _propTypes.default.oneOf(["vertical", "horizontal", "both", "none"]),
  inputRef: _propTypes.default.any
};

// @internal
var OuiCompressedTextArea = function OuiCompressedTextArea(props) {
  return /*#__PURE__*/_react.default.createElement(OuiTextArea, (0, _extends2.default)({}, props, {
    compressed: true
  }));
};
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */


exports.OuiCompressedTextArea = OuiCompressedTextArea;