/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.events.AutomationEventFactory;
import org.openhab.core.automation.events.TimerEvent;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TimeBasedTriggerHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicPrefixEventFilter;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.scheduler.CronAdjuster;
import org.openhab.core.scheduler.CronScheduler;
import org.openhab.core.scheduler.ScheduledCompletableFuture;
import org.openhab.core.scheduler.SchedulerRunnable;
import org.openhab.core.types.Type;
import org.openhab.core.types.UnDefType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DateTimeTriggerHandler
extends BaseTriggerModuleHandler
implements SchedulerRunnable,
TimeBasedTriggerHandler,
EventSubscriber {
    public static final String MODULE_TYPE_ID = "timer.DateTimeTrigger";
    public static final String CONFIG_ITEM_NAME = "itemName";
    public static final String CONFIG_TIME_ONLY = "timeOnly";
    private static final DateTimeFormatter CRON_FORMATTER = DateTimeFormatter.ofPattern("s m H d M * uuuu");
    private static final DateTimeFormatter CRON_TIMEONLY_FORMATTER = DateTimeFormatter.ofPattern("s m H * * * *");
    private final Logger logger = LoggerFactory.getLogger(DateTimeTriggerHandler.class);
    private final CronScheduler scheduler;
    private final String itemName;
    private final @Nullable EventFilter eventFilter;
    private String cronExpression = "@reboot";
    private Boolean timeOnly = false;
    private @Nullable ScheduledCompletableFuture<?> schedule;
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;

    public DateTimeTriggerHandler(Trigger module, CronScheduler scheduler, ItemRegistry itemRegistry, BundleContext bundleContext) {
        super(module);
        this.scheduler = scheduler;
        this.itemName = (String)ConfigParser.valueAsOrElse((Object)module.getConfiguration().get(CONFIG_ITEM_NAME), String.class, (Object)"");
        if (this.itemName.isBlank()) {
            this.logger.warn("itemName is blank in module '{}', trigger will not work", (Object)module.getId());
            this.eventFilter = null;
            return;
        }
        this.eventFilter = new TopicPrefixEventFilter("openhab/items/" + this.itemName + "/");
        this.timeOnly = (Boolean)ConfigParser.valueAsOrElse((Object)module.getConfiguration().get(CONFIG_TIME_ONLY), Boolean.class, (Object)false);
        this.eventSubscriberRegistration = bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        try {
            this.process((Type)itemRegistry.getItem(this.itemName).getState());
        }
        catch (ItemNotFoundException e) {
            this.logger.info("Could not determine initial state for item '{}' in trigger '{}', waiting for event", (Object)this.itemName, (Object)module.getId());
        }
    }

    @Override
    public void dispose() {
        ServiceRegistration<?> eventSubscriberRegistration = this.eventSubscriberRegistration;
        if (eventSubscriberRegistration != null) {
            eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
        this.cancelScheduler();
        super.dispose();
    }

    @Override
    public synchronized void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
        this.startScheduler();
    }

    /*
     * WARNING - void declaration
     */
    public void run() {
        ModuleHandlerCallback callback = this.callback;
        ModuleHandlerCallback moduleHandlerCallback = callback;
        if (moduleHandlerCallback instanceof TriggerHandlerCallback) {
            void triggerHandlerCallback;
            TriggerHandlerCallback triggerHandlerCallback2 = (TriggerHandlerCallback)moduleHandlerCallback;
            TriggerHandlerCallback cfr_ignored_0 = (TriggerHandlerCallback)moduleHandlerCallback;
            TimerEvent event = AutomationEventFactory.createTimerEvent(((Trigger)this.module).getTypeUID(), Objects.requireNonNullElse(((Trigger)this.module).getLabel(), ((Trigger)this.module).getId()), Map.of(CONFIG_ITEM_NAME, this.itemName));
            triggerHandlerCallback.triggered((Trigger)this.module, Map.of("event", event));
        } else {
            this.logger.debug("Tried to trigger, but callback isn't available!");
        }
    }

    public CronAdjuster getTemporalAdjuster() {
        return new CronAdjuster(this.cronExpression);
    }

    public Set<String> getSubscribedEventTypes() {
        return Set.of(ItemStateChangedEvent.TYPE);
    }

    public @Nullable EventFilter getEventFilter() {
        return this.eventFilter;
    }

    /*
     * WARNING - void declaration
     */
    public void receive(Event event) {
        Event event2 = event;
        if (event2 instanceof ItemStateChangedEvent) {
            void itemStateChangedEvent;
            ItemStateChangedEvent itemStateChangedEvent2 = (ItemStateChangedEvent)event2;
            ItemStateChangedEvent cfr_ignored_0 = (ItemStateChangedEvent)event2;
            if (itemStateChangedEvent.getItemName().equals(this.itemName)) {
                this.process((Type)itemStateChangedEvent.getItemState());
            }
        }
    }

    private synchronized void startScheduler() {
        this.cancelScheduler();
        if (!"@reboot".equals(this.cronExpression)) {
            this.schedule = this.scheduler.schedule((SchedulerRunnable)this, this.cronExpression);
            this.logger.debug("Scheduled cron job '{}' for trigger '{}'.", ((Trigger)this.module).getConfiguration().get(CONFIG_ITEM_NAME), (Object)((Trigger)this.module).getId());
        }
    }

    private synchronized void cancelScheduler() {
        ScheduledCompletableFuture<?> schedule = this.schedule;
        if (schedule != null) {
            schedule.cancel(true);
            this.schedule = null;
            this.logger.debug("Cancelled job for trigger '{}'.", (Object)((Trigger)this.module).getId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(Type value) {
        this.cancelScheduler();
        if (value instanceof UnDefType) {
            this.cronExpression = "@reboot";
        } else {
            Type type = value;
            if (type instanceof DateTimeType) {
                void dateTimeType;
                DateTimeType dateTimeType2 = (DateTimeType)type;
                DateTimeType cfr_ignored_0 = (DateTimeType)type;
                boolean itemIsTimeOnly = dateTimeType.toString().startsWith("1970-01-01T");
                this.cronExpression = dateTimeType.getZonedDateTime().withZoneSameInstant(ZoneId.systemDefault()).format(this.timeOnly != false || itemIsTimeOnly ? CRON_TIMEONLY_FORMATTER : CRON_FORMATTER);
                this.startScheduler();
            } else {
                this.logger.warn("Received {} which is not an accepted value for trigger of type '{}", (Object)value, (Object)MODULE_TYPE_ID);
            }
        }
    }
}

