/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.auth;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.AuthenticationException;
import org.openhab.core.auth.AuthenticationManager;
import org.openhab.core.auth.AuthenticationProvider;
import org.openhab.core.auth.Credentials;
import org.openhab.core.auth.UnsupportedCredentialsException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AuthenticationManagerImpl
implements AuthenticationManager {
    private final Logger logger = LoggerFactory.getLogger(AuthenticationManagerImpl.class);
    private final List<AuthenticationProvider> providers = new CopyOnWriteArrayList<AuthenticationProvider>();

    @Override
    public Authentication authenticate(Credentials credentials) throws AuthenticationException {
        boolean unmatched = true;
        for (AuthenticationProvider provider : this.providers) {
            if (!provider.supports(credentials.getClass())) continue;
            unmatched = false;
            try {
                Authentication authentication = provider.authenticate(credentials);
                if (authentication == null) continue;
                return authentication;
            }
            catch (AuthenticationException e) {
                this.logger.info("Failed to authenticate credentials {} with provider {}", new Object[]{credentials.getClass(), provider, e});
            }
        }
        if (unmatched) {
            throw new UnsupportedCredentialsException("Unsupported credentials specified " + String.valueOf(credentials.getClass()));
        }
        throw new AuthenticationException("Could not authenticate credentials " + String.valueOf(credentials.getClass()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addAuthenticationProvider(AuthenticationProvider provider) {
        this.providers.add(provider);
    }

    public void removeAuthenticationProvider(AuthenticationProvider provider) {
        this.providers.remove(provider);
    }
}

