/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.predicates;

import de.focus_shift.jollyday.core.spi.Limited;
import java.util.function.Predicate;

public class ValidCycle
implements Predicate<Limited> {
    private final int year;

    public ValidCycle(int year) {
        this.year = year;
    }

    @Override
    public boolean test(Limited limited) {
        switch (limited.cycle()) {
            case EVERY_YEAR: {
                return true;
            }
            case ODD_YEARS: {
                return this.year % 2 != 0;
            }
            case EVEN_YEARS: {
                return this.year % 2 == 0;
            }
            case TWO_YEARS: {
                return this.isValidWithReferenceYear(limited, 2);
            }
            case THREE_YEARS: {
                return this.isValidWithReferenceYear(limited, 3);
            }
            case FOUR_YEARS: {
                return this.isValidWithReferenceYear(limited, 4);
            }
            case FIVE_YEARS: {
                return this.isValidWithReferenceYear(limited, 5);
            }
            case SIX_YEARS: {
                return this.isValidWithReferenceYear(limited, 6);
            }
        }
        throw new IllegalArgumentException("Cannot handle unknown cycle type '" + limited.cycle() + "'.");
    }

    private boolean isValidWithReferenceYear(Limited limited, int cycleYears) {
        if (limited.validFrom() != null) {
            return (this.year - limited.validFrom().getValue()) % cycleYears == 0;
        }
        if (limited.validTo() != null) {
            return (limited.validTo().getValue() - this.year) % cycleYears == 0;
        }
        throw new IllegalArgumentException("Cannot handle cycle type '" + limited.cycle() + "' without any reference year.");
    }
}

