/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIMapperCallback;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ProtoCallbackHandler
implements CallbackHandler {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    UDDIMapper mapper;

    public ProtoCallbackHandler(UDDIMapper mapper) {
        this.mapper = mapper;
    }

    public UDDIMapper getUDDIMapper() {
        return this.mapper;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        this.logger.finest(toc.getMessage());
                        break;
                    }
                    case 2: {
                        this.logger.log(Level.SEVERE, ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:ERROR:_") + toc.getMessage());
                        break;
                    }
                    case 1: {
                        this.logger.warning(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:WARNING:_") + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:Unsupported_message_type:_") + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                System.err.print(nc.getPrompt());
                System.err.flush();
                nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                System.err.print(pc.getPrompt());
                System.err.flush();
                pc.setPassword(this.readPassword(System.in));
                continue;
            }
            if (callbacks[i] instanceof UDDIMapperCallback) {
                UDDIMapperCallback mc = (UDDIMapperCallback)callbacks[i];
                mc.setUDDIMapper(this.mapper);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("ProtoCallbackHandler:Unrecognized_Callback"));
        }
    }

    private char[] readPassword(InputStream in) throws IOException {
        char[] lineBuffer;
        char[] buf = lineBuffer = new char[128];
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            int c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(lineBuffer, 0, buf, 0, offset);
                        Arrays.fill(lineBuffer, ' ');
                        lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (offset == 0) {
            return null;
        }
        char[] ret = new char[offset];
        System.arraycopy(buf, 0, ret, 0, offset);
        Arrays.fill(buf, ' ');
        return ret;
    }
}

