/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasPort;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewWSDLAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        boolean enabled = true;
        for (Node node : nodes) {
            WsdlSaas saas = this.getWsdlSaas(node);
            if (saas != null && (saas.getState() == Saas.State.RETRIEVED || saas.getState() == Saas.State.READY)) continue;
            enabled = false;
            break;
        }
        return enabled;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(ViewWSDLAction.class, (String)"VIEW_WSDL");
    }

    private WsdlSaas getWsdlSaas(Node node) {
        WsdlSaasMethod method;
        WsdlSaasPort port;
        WsdlSaas saas = (WsdlSaas)node.getLookup().lookup(WsdlSaas.class);
        if (saas == null && (port = (WsdlSaasPort)node.getLookup().lookup(WsdlSaasPort.class)) != null) {
            saas = port.getParentSaas();
        }
        if (saas == null && (method = (WsdlSaasMethod)node.getLookup().lookup(WsdlSaasMethod.class)) != null) {
            saas = method.getSaas();
        }
        return saas;
    }

    protected void performAction(Node[] nodes) {
        for (Node node : nodes) {
            WsdlSaas saas = this.getWsdlSaas(node);
            String location = saas.getWsdlData().getWsdlFile();
            FileObject wsdlFileObject = saas.getLocalWsdlFile();
            if (wsdlFileObject == null) {
                String errorMessage = NbBundle.getMessage(ViewWSDLAction.class, (String)"WSDL_FILE_NOT_FOUND", (Object)location);
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                continue;
            }
            try {
                DataObject wsdlDataObject = DataObject.find((FileObject)wsdlFileObject);
                EditorCookie editorCookie = (EditorCookie)wsdlDataObject.getLookup().lookup(EditorCookie.class);
                editorCookie.open();
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public boolean asynchronous() {
        return true;
    }
}

