/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.refactoring.spi.impl.UndoableWrapper;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

abstract class BackupFacility2 {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.refactoring.Undo");
    private static BackupFacility2 defaultInstance;

    private BackupFacility2() {
    }

    public abstract Handle backup(FileObject ... var1) throws IOException;

    public abstract Handle backup(File ... var1) throws IOException;

    public final Handle backup(Collection<? extends FileObject> fileObjects) throws IOException {
        return this.backup(fileObjects.toArray(new FileObject[0]));
    }

    public abstract void clear();

    public static BackupFacility2 getDefault() {
        BackupFacility2 instance = (BackupFacility2)Lookup.getDefault().lookup(BackupFacility2.class);
        return instance != null ? instance : BackupFacility2.getDefaultInstance();
    }

    private static synchronized BackupFacility2 getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultImpl();
        }
        return defaultInstance;
    }

    public static interface Handle {
        public void restore() throws IOException;

        public void storeChecksum() throws IOException;

        public Collection<String> checkChecksum(boolean var1) throws IOException;
    }

    private static class DefaultImpl
    extends BackupFacility2 {
        private long currentId = 0L;
        private Map<Long, BackupEntry> map = new HashMap<Long, BackupEntry>();
        private static Field undoRedo;

        private String MD5toString(byte[] digest) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < digest.length; ++i) {
                b.append(Integer.toHexString(0xFF & digest[i]));
            }
            return b.toString();
        }

        private void storeChecksum(long l) throws IOException {
            CloneableEditorSupport ces;
            BaseDocument doc;
            FileObject fo;
            BackupEntry backup = this.map.get(l);
            if (backup.orig == null) {
                backup.orig = FileUtil.toFileObject((File)backup.origFile);
                backup.origFile = null;
            }
            if (!(fo = backup.orig).isValid()) {
                BackupEntry.access$502(backup, new byte[16]);
                Arrays.fill(backup.checkSum, (byte)0);
                return;
            }
            DataObject dob = DataObject.find((FileObject)fo);
            if (dob != null && (doc = (BaseDocument)(ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class)).getDocument()) != null && doc.isAtomicLock()) {
                return;
            }
            LOG.log(Level.FINE, "Storing MD5 for {0}", backup.orig);
            BackupEntry.access$502(backup, this.getMD5(this.getInputStream(backup.orig)));
            LOG.log(Level.FINE, "MD5 is: {0}", this.MD5toString(backup.checkSum));
        }

        private String checkChecksum(long l, boolean undo) {
            try {
                BackupEntry backup = this.map.get(l);
                FileObject fo = backup.orig;
                if (!fo.isValid()) {
                    return null;
                }
                DataObject dob = DataObject.find((FileObject)fo);
                if (dob != null) {
                    CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
                    BaseDocument doc = (BaseDocument)ces.getDocument();
                    if (doc != null && doc.isAtomicLock()) {
                        return null;
                    }
                    EditorCookie editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                    if (editor != null && doc != null && editor.isModified()) {
                        UndoableWrapper.UndoableEditDelegate edit;
                        UndoableWrapper.UndoableEditDelegate undoableEditDelegate = edit = undo ? (UndoableWrapper.UndoableEditDelegate)NbDocument.getEditToBeUndoneOfType((EditorCookie)editor, UndoableWrapper.UndoableEditDelegate.class) : (UndoableWrapper.UndoableEditDelegate)NbDocument.getEditToBeRedoneOfType((EditorCookie)editor, UndoableWrapper.UndoableEditDelegate.class);
                        if (edit == null) {
                            LOG.fine("Editor Undo Different");
                            return backup.orig.getPath();
                        }
                    }
                }
                try {
                    LOG.log(Level.FINE, "Checking MD5 for {0}", backup.orig);
                    byte[] ts = this.getMD5(this.getInputStream(backup.orig));
                    if (!Arrays.equals(backup.checkSum, ts)) {
                        LOG.fine("MD5 check failed");
                        return backup.orig.getPath();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        private InputStream getInputStream(FileObject fo) throws IOException {
            DataObject dob = DataObject.find((FileObject)fo);
            CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
            if (ces != null && ces.isModified()) {
                LOG.fine("Editor Input Stream");
                return ces.getInputStream();
            }
            LOG.fine("File Input Stream");
            return fo.getInputStream();
        }

        private DefaultImpl() {
        }

        @Override
        public Handle backup(FileObject ... file) throws IOException {
            ArrayList<Long> list = new ArrayList<Long>();
            for (FileObject f : file) {
                list.add(this.backup(f));
            }
            return new DefaultHandle(this, list);
        }

        @Override
        public Handle backup(File ... files) throws IOException {
            ArrayList<Long> list = new ArrayList<Long>();
            for (File f : files) {
                list.add(this.backup(f));
            }
            return new DefaultHandle(this, list);
        }

        public long backup(FileObject file) throws IOException {
            BackupEntry entry = new BackupEntry();
            entry.file = Files.createTempFile("nbbackup", null, new FileAttribute[0]).toFile();
            this.copy(file, entry.file);
            entry.orig = file;
            this.map.put(this.currentId, entry);
            entry.file.deleteOnExit();
            return this.currentId++;
        }

        public long backup(File file) throws IOException {
            BackupEntry entry = new BackupEntry();
            entry.file = Files.createTempFile("nbbackup", null, new FileAttribute[0]).toFile();
            entry.exists = file.exists();
            if (entry.exists) {
                FileObject fo = FileUtil.toFileObject((File)file);
                entry.orig = fo;
            } else {
                entry.origFile = file;
            }
            this.map.put(this.currentId, entry);
            entry.file.deleteOnExit();
            if (entry.exists) {
                this.copy(file, entry.file);
            }
            return this.currentId++;
        }

        private byte[] getMD5(InputStream is) throws IOException {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                try {
                    is = new DigestInputStream(is, md);
                    DefaultImpl.readFully(is, -1, true);
                }
                finally {
                    is.close();
                }
                return md.digest();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException(ex);
            }
        }

        private static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
            int cc;
            byte[] output = new byte[]{};
            if (length == -1) {
                length = Integer.MAX_VALUE;
            }
            for (int pos = 0; pos < length; pos += cc) {
                int bytesToRead;
                if (pos >= output.length) {
                    bytesToRead = Math.min(length - pos, output.length + 1024);
                    if (output.length < pos + bytesToRead) {
                        output = Arrays.copyOf(output, pos + bytesToRead);
                    }
                } else {
                    bytesToRead = output.length - pos;
                }
                if ((cc = is.read(output, pos, bytesToRead)) >= 0) continue;
                if (readAll && length != Integer.MAX_VALUE) {
                    throw new EOFException("Detect premature EOF");
                }
                if (output.length == pos) break;
                output = Arrays.copyOf(output, pos);
                break;
            }
            return output;
        }

        void restore(long id) throws IOException {
            BackupEntry entry = this.map.get(id);
            if (entry == null) {
                throw new IllegalArgumentException("Backup with id " + id + "does not exist");
            }
            File backup = Files.createTempFile("nbbackup", null, new FileAttribute[0]).toFile();
            backup.deleteOnExit();
            boolean exists = false;
            FileObject fo = entry.orig;
            if (!fo.isValid()) {
                FileObject file = FileUtil.toFileObject((File)FileUtil.toFile((FileObject)fo));
                FileObject fileObject = fo = file == null ? fo : file;
            }
            if (exists = fo.isValid()) {
                backup.createNewFile();
                this.copy(fo, backup);
            } else {
                fo = this.createNewFile(fo);
            }
            if (entry.exists) {
                if (!this.tryUndoOrRedo(fo, entry)) {
                    this.copy(entry.file, fo);
                }
            } else {
                fo.delete();
            }
            entry.exists = exists;
            entry.file.delete();
            if (backup.exists()) {
                entry.file = backup;
            } else {
                this.map.remove(id);
            }
        }

        private boolean tryUndoOrRedo(@NonNull FileObject fileObj, final @NonNull BackupEntry entry) throws DataObjectNotFoundException {
            DataObject dob = DataObject.find((FileObject)fileObj);
            if (dob != null) {
                CloneableEditorSupport ces = (CloneableEditorSupport)dob.getLookup().lookup(CloneableEditorSupport.class);
                if (ces == null) {
                    return false;
                }
                try {
                    final UndoRedo.Manager manager = (UndoRedo.Manager)undoRedo.get(ces);
                    BaseDocument doc = (BaseDocument)ces.getDocument();
                    if (doc == null) {
                        return false;
                    }
                    if (doc.isAtomicLock() || fileObj.isLocked()) {
                        if (entry.isUndo()) {
                            entry.setUndo(false);
                        } else {
                            entry.setUndo(true);
                        }
                    } else if (entry.isUndo() && manager.canUndo() || !entry.isUndo() && manager.canRedo()) {
                        doc.runAtomic(new Runnable(){

                            @Override
                            public void run() {
                                if (entry.isUndo()) {
                                    manager.undo();
                                    entry.setUndo(false);
                                } else {
                                    manager.redo();
                                    entry.setUndo(true);
                                }
                            }
                        });
                    } else {
                        return false;
                    }
                    return true;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return false;
        }

        private FileObject createNewFile(FileObject fo) throws IOException {
            if (fo.isValid()) {
                return fo;
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file != null && file.exists()) {
                return FileUtil.toFileObject((File)file);
            }
            FileObject parent = fo.getParent();
            if (parent != null) {
                this.createNewFolder(parent);
            }
            return FileUtil.createData((FileObject)parent, (String)fo.getNameExt());
        }

        private void createNewFolder(FileObject fo) throws IOException {
            FileObject parent;
            if (!fo.isValid() && (parent = fo.getParent()) != null) {
                this.createNewFolder(parent);
                FileUtil.createFolder((FileObject)parent, (String)fo.getNameExt());
            }
        }

        private void copy(FileObject a, File b) throws IOException {
            InputStream fs = a.getInputStream();
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, File b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            FileOutputStream fo = new FileOutputStream(b);
            this.copy(fs, fo);
        }

        private void copy(File a, FileObject b) throws IOException {
            FileInputStream fs = new FileInputStream(a);
            OutputStream fo = b.getOutputStream();
            this.copy(fs, fo);
        }

        private void copy(InputStream is, OutputStream os) throws IOException {
            try {
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                is.close();
                os.close();
            }
        }

        @Override
        public void clear() {
            for (BackupEntry entry : this.map.values()) {
                entry.file.delete();
            }
            this.map.clear();
        }

        static {
            try {
                undoRedo = CloneableEditorSupport.class.getDeclaredField("undoRedo");
                undoRedo.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private class BackupEntry {
            private File file;
            private FileObject orig;
            private File origFile;
            private byte[] checkSum;
            private boolean undo = true;
            private boolean exists = true;

            public boolean isUndo() {
                return this.undo;
            }

            public void setUndo(boolean undo) {
                this.undo = undo;
            }

            static /* synthetic */ byte[] access$502(BackupEntry x0, byte[] x1) {
                x0.checkSum = x1;
                return x1;
            }
        }
    }

    private static class DefaultHandle
    implements Handle {
        private List<Long> handle;
        private DefaultImpl instance;

        private DefaultHandle(DefaultImpl instance, List<Long> handles) {
            this.handle = handles;
            this.instance = instance;
        }

        @Override
        public void restore() throws IOException {
            for (long l : this.handle) {
                this.instance.restore(l);
            }
        }

        @Override
        public void storeChecksum() throws IOException {
            for (long l : this.handle) {
                this.instance.storeChecksum(l);
            }
        }

        @Override
        public Collection<String> checkChecksum(boolean undo) throws IOException {
            LinkedList<String> result = new LinkedList<String>();
            for (long l : this.handle) {
                String checkChecksum = this.instance.checkChecksum(l, undo);
                if (checkChecksum == null) continue;
                result.add(checkChecksum);
            }
            return result;
        }
    }
}

