/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TypeEnter;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.Map;
import java.util.Optional;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class Enter
extends JCTree.Visitor {
    protected static final Context.Key<Enter> enterKey = new Context.Key();
    Annotate annotate;
    Log log;
    Symtab syms;
    Check chk;
    TreeMaker make;
    TypeEnter typeEnter;
    Types types;
    Lint lint;
    Names names;
    JavaFileManager fileManager;
    Option.PkgInfo pkginfoOpt;
    TypeEnvs typeEnvs;
    Modules modules;
    JCDiagnostic.Factory diags;
    private final Todo todo;
    ListBuffer<Symbol.ClassSymbol> uncompleted;
    List<Symbol.ClassSymbol> pendingCompleter = null;
    ListBuffer<JCTree.JCCompilationUnit> unfinishedModules = new ListBuffer();
    private JCTree.JCClassDecl predefClassDef;
    protected Env<AttrContext> env;
    Type result;
    private final TreeScanner setPackageSymbols = new TreeScanner(){
        Symbol currentPackage;

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            tree.sym = this.currentPackage;
            tree.type = this.currentPackage.type;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            tree.sym = this.currentPackage;
            tree.type = this.currentPackage.type;
            this.currentPackage = this.currentPackage.owner;
            super.visitSelect(tree);
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl tree) {
            this.currentPackage = tree.packge;
            this.scan(tree.pid);
        }
    };

    public static Enter instance(Context context) {
        Enter instance = context.get(enterKey);
        if (instance == null) {
            instance = new Enter(context);
        }
        return instance;
    }

    protected Enter(Context context) {
        context.put(enterKey, this);
        this.log = Log.instance(context);
        this.make = TreeMaker.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.typeEnter = TypeEnter.instance(context);
        this.types = Types.instance(context);
        this.annotate = Annotate.instance(context);
        this.lint = Lint.instance(context);
        this.names = Names.instance(context);
        this.modules = Modules.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.predefClassDef = this.make.ClassDef(this.make.Modifiers(1L), this.syms.predefClass.name, List.nil(), null, List.nil(), List.nil());
        this.predefClassDef.sym = this.syms.predefClass;
        this.todo = Todo.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        Options options = Options.instance(context);
        this.pkginfoOpt = Option.PkgInfo.get(options);
        this.typeEnvs = TypeEnvs.instance(context);
    }

    public Env<AttrContext> getEnv(Symbol.TypeSymbol sym) {
        return this.typeEnvs.get(sym);
    }

    public Iterable<Env<AttrContext>> getEnvs() {
        return this.typeEnvs.values();
    }

    public Env<AttrContext> getClassEnv(Symbol.TypeSymbol sym) {
        Env<AttrContext> localEnv = this.getEnv(sym);
        if (localEnv == null) {
            return null;
        }
        Env<AttrContext> lintEnv = localEnv;
        while (((AttrContext)lintEnv.info).lint == null) {
            lintEnv = lintEnv.next;
        }
        ((AttrContext)localEnv.info).lint = ((AttrContext)lintEnv.info).lint.augment(sym);
        return localEnv;
    }

    public Env<AttrContext> classEnv(JCTree.JCClassDecl tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(Scope.WriteableScope.create(tree.sym)));
        localEnv.enclClass = tree;
        localEnv.outer = env;
        ((AttrContext)localEnv.info).lint = null;
        ((AttrContext)localEnv.info).isAnonymousDiamond = TreeInfo.isDiamond(env.tree);
        return localEnv;
    }

    Env<AttrContext> topLevelEnv(JCTree.JCCompilationUnit tree) {
        Env<AttrContext> localEnv = new Env<AttrContext>(tree, new AttrContext());
        localEnv.toplevel = tree;
        localEnv.enclClass = this.predefClassDef;
        tree.toplevelScope = Scope.WriteableScope.create(tree.packge);
        tree.namedImportScope = new Scope.NamedImportScope(tree.packge);
        tree.starImportScope = new Scope.StarImportScope(tree.packge);
        ((AttrContext)localEnv.info).scope = tree.toplevelScope;
        ((AttrContext)localEnv.info).lint = this.lint;
        return localEnv;
    }

    public Env<AttrContext> getTopLevelEnv(JCTree.JCCompilationUnit tree) {
        Env<AttrContext> localEnv = new Env<AttrContext>(tree, new AttrContext());
        localEnv.toplevel = tree;
        localEnv.enclClass = this.predefClassDef;
        ((AttrContext)localEnv.info).scope = tree.toplevelScope;
        ((AttrContext)localEnv.info).lint = this.lint;
        return localEnv;
    }

    Scope.WriteableScope enterScope(Env<AttrContext> env) {
        return env.tree.hasTag(JCTree.Tag.CLASSDEF) ? ((JCTree.JCClassDecl)env.tree).sym.members_field : ((AttrContext)env.info).scope;
    }

    public Env<AttrContext> moduleEnv(JCTree.JCModuleDecl tree, Env<AttrContext> env) {
        Assert.checkNonNull(tree.sym);
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(Scope.WriteableScope.create(tree.sym)));
        localEnv.enclClass = this.predefClassDef;
        localEnv.outer = env;
        ((AttrContext)localEnv.info).lint = null;
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type classEnter(JCTree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            this.annotate.blockAnnotations();
            tree.accept(this);
            Type type = this.result;
            return type;
        }
        catch (Symbol.CompletionFailure ex) {
            Type type = this.chk.completionError(tree.pos(), ex);
            return type;
        }
        finally {
            this.annotate.unblockAnnotations();
            this.env = prevEnv;
        }
    }

    <T extends JCTree> List<Type> classEnter(List<T> trees, Env<AttrContext> env) {
        ListBuffer<Type> ts = new ListBuffer<Type>();
        List<Object> l = trees;
        while (l.nonEmpty()) {
            Type t = this.classEnter((JCTree)l.head, env);
            if (t != null) {
                ts.append(t);
            }
            l = l.tail;
        }
        return ts.toList();
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        JavaFileObject prev = this.log.useSource(tree.sourcefile);
        boolean addEnv = false;
        boolean isPkgInfo = tree.sourcefile.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE);
        if (TreeInfo.isModuleInfo(tree)) {
            JCTree.JCPackageDecl pd = tree.getPackage();
            if (pd != null) {
                this.log.error(pd.pos(), CompilerProperties.Errors.NoPkgInModuleInfoJava);
            }
            tree.packge = this.syms.rootPackage;
            Env<AttrContext> topEnv = this.topLevelEnv(tree);
            this.classEnter(tree.defs, topEnv);
            tree.modle.usesProvidesCompleter = this.modules.getUsesProvidesCompleter();
        } else {
            JCTree.JCPackageDecl pd = tree.getPackage();
            if (pd != null) {
                tree.packge = pd.packge = this.syms.enterPackage(tree.modle, TreeInfo.fullName(pd.pid));
                this.setPackageSymbols.scan(pd);
                if (pd.annotations.nonEmpty() || this.pkginfoOpt == Option.PkgInfo.ALWAYS || tree.docComments != null) {
                    if (isPkgInfo) {
                        addEnv = true;
                    } else if (pd.annotations.nonEmpty()) {
                        this.log.error(((JCTree.JCAnnotation)pd.annotations.head).pos(), CompilerProperties.Errors.PkgAnnotationsSbInPackageInfoJava);
                    }
                }
            } else {
                tree.packge = tree.modle.unnamedPackage;
            }
            Map<Name, Symbol.PackageSymbol> visiblePackages = tree.modle.visiblePackages;
            Optional<Symbol.ModuleSymbol> dependencyWithPackage = this.syms.listPackageModules(tree.packge.fullname).stream().filter(m -> m != tree.modle).filter(cand -> visiblePackages.get(tree.packge.fullname) == this.syms.getPackage((Symbol.ModuleSymbol)cand, tree.packge.fullname)).findAny();
            if (dependencyWithPackage.isPresent()) {
                this.log.error(pd, CompilerProperties.Errors.PackageInOtherModule(dependencyWithPackage.get()));
            }
            tree.packge.complete();
            Env<AttrContext> topEnv = this.topLevelEnv(tree);
            Env<AttrContext> packageEnv = null;
            if (isPkgInfo) {
                packageEnv = topEnv.dup(pd != null ? pd : tree);
                Env<AttrContext> env0 = this.typeEnvs.get(tree.packge);
                if (env0 != null) {
                    JCTree.JCCompilationUnit tree0 = env0.toplevel;
                    if (!this.fileManager.isSameFile(tree.sourcefile, tree0.sourcefile)) {
                        this.log.warning(pd != null ? pd.pid.pos() : null, CompilerProperties.Warnings.PkgInfoAlreadySeen(tree.packge));
                    }
                }
                this.typeEnvs.put(tree.packge, packageEnv);
                Symbol q = tree.packge;
                while (q != null && q.kind == Kinds.Kind.PCK) {
                    q.flags_field |= 0x800000L;
                    q = q.owner;
                }
                Name name = this.names.package_info;
                Symbol.ClassSymbol c = this.syms.enterClass(tree.modle, name, tree.packge);
                c.flatname = this.names.fromString(tree.packge + "." + name);
                c.classfile = c.sourcefile = tree.sourcefile;
                c.completer = Symbol.Completer.NULL_COMPLETER;
                c.members_field = Scope.WriteableScope.create(c);
                tree.packge.package_info = c;
                tree.packge.sourcefile = tree.sourcefile;
            }
            this.classEnter(tree.defs, topEnv);
            if (addEnv) {
                this.todo.append(packageEnv);
            }
        }
        this.log.useSource(prev);
        this.result = null;
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        Symbol.ClassSymbol c;
        Symbol owner = ((AttrContext)this.env.info).scope.owner;
        Scope.WriteableScope enclScope = this.enterScope(this.env);
        if (owner.kind == Kinds.Kind.PCK) {
            Symbol.PackageSymbol packge;
            Symbol q = packge = (Symbol.PackageSymbol)owner;
            while (q != null && q.kind == Kinds.Kind.PCK) {
                q.flags_field |= 0x800000L;
                q = q.owner;
            }
            c = this.syms.enterClass(this.env.toplevel.modle, tree.name, packge);
            packge.members().enterIfAbsent(c);
            if ((tree.mods.flags & 1L) != 0L && !Enter.classNameMatchesFileName(c, this.env)) {
                Kinds.KindName topElement = Kinds.KindName.CLASS;
                if ((tree.mods.flags & 0x4000L) != 0L) {
                    topElement = Kinds.KindName.ENUM;
                } else if ((tree.mods.flags & 0x200L) != 0L) {
                    topElement = Kinds.KindName.INTERFACE;
                }
                this.log.error(tree.pos(), CompilerProperties.Errors.ClassPublicShouldBeInFile(topElement, tree.name));
            }
            if ((tree.mods.flags & 0x80000L) != 0L) {
                this.syms.removeClass(this.env.toplevel.modle, tree.name);
            }
        } else {
            if (tree.name.length() != 0 && !this.chk.checkUniqueClassName(tree.pos(), tree.name, enclScope)) {
                this.result = null;
                return;
            }
            if (owner.kind == Kinds.Kind.TYP) {
                c = this.syms.enterClass(this.env.toplevel.modle, tree.name, (Symbol.TypeSymbol)owner);
                if (c.owner != owner) {
                    if (c.name != tree.name) {
                        this.log.error(tree.pos(), CompilerProperties.Errors.SameBinaryName(c.name, tree.name));
                        this.result = this.types.createErrorType(tree.name, (Symbol.TypeSymbol)owner, Type.noType);
                        tree.sym = (Symbol.ClassSymbol)this.result.tsym;
                        return;
                    }
                    Assert.check(owner.owner.kind != Kinds.Kind.TYP, owner::toString);
                    Assert.check(c.owner.kind == Kinds.Kind.TYP, () -> c.owner.toString());
                    Symbol.ClassSymbol cowner = (Symbol.ClassSymbol)c.owner;
                    if (cowner.members_field != null) {
                        cowner.members_field.remove(c);
                    }
                    c.owner = owner;
                }
                if ((owner.flags_field & 0x200L) != 0L) {
                    tree.mods.flags |= 9L;
                }
            } else {
                c = this.syms.defineClass(tree.name, owner);
                c.flatname = this.chk.localClassName(c);
                if (c.name.length() != 0) {
                    this.chk.checkTransparentClass(tree.pos(), c, ((AttrContext)this.env.info).scope);
                }
            }
        }
        tree.sym = c;
        if (this.chk.getCompiled(c) != null) {
            this.duplicateClass(tree.pos(), c);
            this.result = this.types.createErrorType(tree.name, (Symbol.TypeSymbol)owner, Type.noType);
            tree.sym = (Symbol.ClassSymbol)this.result.tsym;
            return;
        }
        this.chk.putCompiled(c);
        enclScope.enter(c);
        Env<AttrContext> localEnv = this.classEnv(tree, this.env);
        this.typeEnvs.put(c, localEnv);
        c.completer = Symbol.Completer.NULL_COMPLETER;
        c.flags_field = this.chk.checkFlags(tree.pos(), tree.mods.flags, c, tree) | 0x200000L;
        c.classfile = c.sourcefile = this.env.toplevel.sourcefile;
        c.members_field = Scope.WriteableScope.create(c);
        c.isPermittedExplicit = tree.permitting.nonEmpty();
        c.clearAnnotationMetadata();
        Type.ClassType ct = (Type.ClassType)c.type;
        if (owner.kind != Kinds.Kind.PCK && (c.flags_field & 8L) == 0L) {
            Symbol owner1 = owner;
            while (owner1.kind.matches(Kinds.KindSelector.VAL_MTH) && (owner1.flags_field & 8L) == 0L) {
                owner1 = owner1.owner;
            }
            if (owner1.kind == Kinds.Kind.TYP) {
                ct.setEnclosingType(owner1.type);
            }
        }
        ct.typarams_field = this.classEnter(tree.typarams, localEnv);
        ct.allparams_field = null;
        if (this.pendingCompleter != null) {
            this.pendingCompleter = this.pendingCompleter.prepend(c);
        } else {
            c.completer = this.typeEnter;
        }
        if (!c.isDirectlyOrIndirectlyLocal() && this.uncompleted != null) {
            this.uncompleted.append(c);
        }
        this.classEnter(tree.defs, localEnv);
        this.result = c.type;
    }

    private static boolean classNameMatchesFileName(Symbol.ClassSymbol c, Env<AttrContext> env) {
        return env.toplevel.sourcefile.isNameCompatible(c.name.toString(), JavaFileObject.Kind.SOURCE);
    }

    protected void duplicateClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, CompilerProperties.Errors.DuplicateClass(c.fullname));
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        Type.TypeVar a = tree.type != null ? (Type.TypeVar)tree.type : new Type.TypeVar(tree.name, ((AttrContext)this.env.info).scope.owner, this.syms.botType);
        tree.type = a;
        if (this.chk.checkUnique(tree.pos(), a.tsym, ((AttrContext)this.env.info).scope)) {
            ((AttrContext)this.env.info).scope.enter(a.tsym);
        }
        this.result = a;
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl tree) {
        Env<AttrContext> moduleEnv = this.moduleEnv(tree, this.env);
        this.typeEnvs.put(tree.sym, moduleEnv);
        if (this.modules.isInModuleGraph(tree.sym)) {
            this.todo.append(moduleEnv);
        }
    }

    @Override
    public void visitTree(JCTree tree) {
        this.result = null;
    }

    public void main(List<JCTree.JCCompilationUnit> trees) {
        this.complete(trees, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(List<JCTree.JCCompilationUnit> trees, Symbol.ClassSymbol c) {
        this.annotate.blockAnnotations();
        ListBuffer<Symbol.ClassSymbol> prevUncompleted = this.uncompleted;
        if (this.typeEnter.completionEnabled) {
            this.uncompleted = new ListBuffer();
        }
        try {
            List<Symbol.ClassSymbol> prevPendingCompleter = this.pendingCompleter;
            try {
                this.pendingCompleter = List.nil();
                this.classEnter(trees, null);
                for (Symbol.ClassSymbol sym : this.pendingCompleter) {
                    sym.completer = this.typeEnter;
                }
            }
            finally {
                this.pendingCompleter = prevPendingCompleter;
            }
            if (this.typeEnter.completionEnabled) {
                while (this.uncompleted.nonEmpty()) {
                    Symbol.ClassSymbol clazz = this.uncompleted.next();
                    if (c == null || c == clazz || prevUncompleted == null) {
                        clazz.complete();
                        continue;
                    }
                    prevUncompleted.append(clazz);
                }
                if (!this.modules.modulesInitialized()) {
                    for (JCTree.JCCompilationUnit cut : trees) {
                        if (cut.getModuleDecl() != null) {
                            this.unfinishedModules.append(cut);
                            continue;
                        }
                        this.typeEnter.ensureImportsChecked(List.of(cut));
                    }
                } else {
                    this.typeEnter.ensureImportsChecked(this.unfinishedModules.toList());
                    this.unfinishedModules.clear();
                    this.typeEnter.ensureImportsChecked(trees);
                }
            }
        }
        finally {
            this.uncompleted = prevUncompleted;
            this.annotate.unblockAnnotations();
        }
    }

    public void newRound() {
        this.typeEnvs.clear();
    }

    public void unenter(JCTree.JCCompilationUnit topLevel, JCTree tree) {
        new UnenterScanner(topLevel.modle).scan(tree);
    }

    class UnenterScanner
    extends TreeScanner {
        private final Symbol.ModuleSymbol msym;

        public UnenterScanner(Symbol.ModuleSymbol msym) {
            this.msym = msym;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            Symbol.ClassSymbol csym = tree.sym;
            if (csym == null) {
                return;
            }
            Enter.this.typeEnvs.remove(csym);
            Enter.this.chk.removeCompiled(csym);
            Enter.this.chk.clearLocalClassNameIndexes(csym);
            Enter.this.syms.removeClass(this.msym, csym.flatname);
            super.visitClassDef(tree);
        }
    }
}

