/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class Preview {
    private final boolean enabled;
    private final MandatoryWarningHandler previewHandler;
    private final boolean forcePreview;
    private final Map<Integer, Source> majorVersionToSource;
    private final Set<JavaFileObject> sourcesWithPreviewFeatures = new HashSet<JavaFileObject>();
    private final Names names;
    private final Lint lint;
    private final Log log;
    private final Source source;
    protected static final Context.Key<Preview> previewKey = new Context.Key();

    public static Preview instance(Context context) {
        Preview instance = context.get(previewKey);
        if (instance == null) {
            instance = new Preview(context);
        }
        return instance;
    }

    protected Preview(Context context) {
        context.put(previewKey, this);
        Options options = Options.instance(context);
        this.names = Names.instance(context);
        this.enabled = options.isSet(Option.PREVIEW);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.source = Source.instance(context);
        this.previewHandler = new MandatoryWarningHandler(this.log, this.source, this.lint.isEnabled(Lint.LintCategory.PREVIEW), true, "preview", Lint.LintCategory.PREVIEW);
        this.forcePreview = options.isSet("forcePreview");
        this.majorVersionToSource = this.initMajorVersionToSourceMap();
    }

    private Map<Integer, Source> initMajorVersionToSourceMap() {
        HashMap<Integer, Source> majorVersionToSource = new HashMap<Integer, Source>();
        for (Target t : Target.values()) {
            int major = t.majorVersion;
            Source source = Source.lookup(t.name);
            if (source == null) continue;
            majorVersionToSource.put(major, source);
        }
        return majorVersionToSource;
    }

    public boolean participatesInPreview(Symtab syms, Symbol s, Symbol previewSymbol) {
        if (previewSymbol.packge().modle == s.packge().modle) {
            return true;
        }
        return syms.java_base.exports.stream().filter(ed -> ed.packge.fullname == this.names.jdk_internal_javac).anyMatch(ed -> ed.modules.contains(s.packge().modle));
    }

    public void warnPreview(int pos, Source.Feature feature) {
        this.warnPreview(new JCDiagnostic.SimpleDiagnosticPosition(pos), feature);
    }

    public void warnPreview(JCDiagnostic.DiagnosticPosition pos, Source.Feature feature) {
        Assert.check(this.isEnabled());
        Assert.check(this.isPreview(feature));
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
            this.previewHandler.report(pos, feature.isPlural() ? CompilerProperties.Warnings.PreviewFeatureUsePlural(feature.nameFragment()) : CompilerProperties.Warnings.PreviewFeatureUse(feature.nameFragment()));
        }
    }

    public void warnPreview(JavaFileObject classfile, int majorVersion) {
        Assert.check(this.isEnabled());
        if (this.lint.isEnabled(Lint.LintCategory.PREVIEW)) {
            this.log.mandatoryWarning(Lint.LintCategory.PREVIEW, null, CompilerProperties.Warnings.PreviewFeatureUseClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name));
        }
    }

    public void markUsesPreview(JCDiagnostic.DiagnosticPosition pos) {
        this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
    }

    public void reportPreviewWarning(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        this.previewHandler.report(pos, warnKey);
    }

    public boolean usesPreview(JavaFileObject file) {
        return this.sourcesWithPreviewFeatures.contains(file);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreview(Source.Feature feature) {
        boolean bl;
        switch (feature) {
            case STRING_TEMPLATES: {
                bl = true;
                break;
            }
            case IMPLICIT_CLASSES: {
                bl = true;
                break;
            }
            case SUPER_INIT: {
                bl = true;
                break;
            }
            default: {
                bl = this.forcePreview;
            }
        }
        return bl;
    }

    public JCDiagnostic.Error disabledError(Source.Feature feature) {
        Assert.check(!this.isEnabled());
        return feature.isPlural() ? CompilerProperties.Errors.PreviewFeatureDisabledPlural(feature.nameFragment()) : CompilerProperties.Errors.PreviewFeatureDisabled(feature.nameFragment());
    }

    public JCDiagnostic.Error disabledError(JavaFileObject classfile, int majorVersion) {
        Assert.check(!this.isEnabled());
        return CompilerProperties.Errors.PreviewFeatureDisabledClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name);
    }

    public boolean declaredUsingPreviewFeature(Symbol sym) {
        return false;
    }

    public void reportDeferredDiagnostics() {
        this.previewHandler.reportDeferredDiagnostic();
    }

    public void clear() {
        this.previewHandler.clear();
    }

    public void checkSourceLevel(JCDiagnostic.DiagnosticPosition pos, Source.Feature feature) {
        if (this.isPreview(feature) && !this.isEnabled()) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, this.disabledError(feature));
        } else {
            if (!feature.allowedInSource(this.source)) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, pos, feature.error(this.source.name));
            }
            if (this.isEnabled() && this.isPreview(feature)) {
                this.warnPreview(pos, feature);
            }
        }
    }
}

