/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactInfoFilter;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.DefaultScannerListener;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IndexerEngine;
import org.apache.maven.index.IteratorResultSet;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.SearchEngine;
import org.apache.maven.index.artifact.ArtifactPackagingMapper;
import org.apache.maven.index.context.DefaultIndexingContext;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenArchetypeArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.expr.StringSearchExpression;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.search.api.MAVEN;
import org.apache.maven.search.api.SearchRequest;
import org.apache.maven.search.api.request.Field;
import org.apache.maven.search.api.request.FieldQuery;
import org.apache.maven.search.api.request.Paging;
import org.apache.maven.search.api.request.Query;
import org.apache.maven.search.backend.smo.SmoSearchBackend;
import org.apache.maven.search.backend.smo.SmoSearchBackendFactory;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.ArtifactDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.Cancellation;
import org.netbeans.modules.maven.indexer.ClassDependencyIndexCreator;
import org.netbeans.modules.maven.indexer.CompositeResult;
import org.netbeans.modules.maven.indexer.CustomArtifactContextProducer;
import org.netbeans.modules.maven.indexer.FastScanner;
import org.netbeans.modules.maven.indexer.MinimalArtifactInfoRemoteIndexCreator;
import org.netbeans.modules.maven.indexer.NotifyingIndexCreator;
import org.netbeans.modules.maven.indexer.RemoteIndexTransferListener;
import org.netbeans.modules.maven.indexer.ResultImpl;
import org.netbeans.modules.maven.indexer.SMORequestResult;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBGroupInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.indexer.spi.ArchetypeQueries;
import org.netbeans.modules.maven.indexer.spi.BaseQueries;
import org.netbeans.modules.maven.indexer.spi.ChecksumQueries;
import org.netbeans.modules.maven.indexer.spi.ClassUsageQuery;
import org.netbeans.modules.maven.indexer.spi.ClassesQuery;
import org.netbeans.modules.maven.indexer.spi.ContextLoadedQuery;
import org.netbeans.modules.maven.indexer.spi.DependencyInfoQueries;
import org.netbeans.modules.maven.indexer.spi.GenericFindQuery;
import org.netbeans.modules.maven.indexer.spi.RepositoryIndexQueryProvider;
import org.netbeans.modules.maven.indexer.spi.ResultImplementation;
import org.netbeans.modules.maven.indexer.spi.impl.IndexingNotificationProvider;
import org.netbeans.modules.maven.indexer.spi.impl.RepositoryIndexerImplementation;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;

public class NexusRepositoryIndexerImpl
implements RepositoryIndexerImplementation,
RepositoryIndexQueryProvider,
BaseQueries,
ChecksumQueries,
ArchetypeQueries,
DependencyInfoQueries,
ClassesQuery,
ClassUsageQuery,
GenericFindQuery,
ContextLoadedQuery {
    private static final Logger LOGGER = Logger.getLogger(NexusRepositoryIndexerImpl.class.getName());
    private static final String GROUP_CACHE_ALL_PREFIX = "nb-groupcache-all-v1";
    private static final String GROUP_CACHE_ALL_SUFFIX = "txt";
    private static final String GROUP_CACHE_ROOT_PREFIX = "nb-groupcache-root-v1";
    private static final String GROUP_CACHE_ROOT_SUFFIX = "txt";
    private PlexusContainer embedder;
    private Indexer indexer;
    private Scanner scanner;
    private SearchEngine searcher;
    private IndexUpdater remoteIndexUpdater;
    private ArtifactContextProducer contextProducer;
    private final Map<String, IndexingContext> indexingContexts = new ConcurrentHashMap<String, IndexingContext>();
    private boolean inited = false;
    private static final HashMap<String, Mutex> repoMutexMap = new HashMap(4);
    private static final Set<Mutex> indexingMutexes = new HashSet<Mutex>();
    private static final RequestProcessor RP_LOCAL = new RequestProcessor("maven-local-indexing");
    private static final RequestProcessor RP_REMOTE = new RequestProcessor("maven-remote-indexing");
    private final SmoSearchBackend smo = SmoSearchBackendFactory.createDefault();
    static final int MAX_RESULT_COUNT = 1024;
    static final int NO_CAP_RESULT_COUNT = -1;

    @Override
    public boolean handlesRepository(RepositoryInfo repo) {
        return true;
    }

    @Override
    public BaseQueries getBaseQueries() {
        return this;
    }

    @Override
    public ChecksumQueries getChecksumQueries() {
        return this;
    }

    @Override
    public ArchetypeQueries getArchetypeQueries() {
        return this;
    }

    @Override
    public DependencyInfoQueries getDependencyInfoQueries() {
        return this;
    }

    @Override
    public ClassesQuery getClassesQuery() {
        return this;
    }

    @Override
    public ClassUsageQuery getClassUsageQuery() {
        return this;
    }

    @Override
    public GenericFindQuery getGenericFindQuery() {
        return this;
    }

    @Override
    public ContextLoadedQuery getContextLoadedQuery() {
        return this;
    }

    private static Mutex getRepoMutex(RepositoryInfo repo) {
        return NexusRepositoryIndexerImpl.getRepoMutex(repo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Mutex getRepoMutex(String repoId) {
        HashMap<String, Mutex> hashMap = repoMutexMap;
        synchronized (hashMap) {
            return repoMutexMap.computeIfAbsent(repoId, k -> new Mutex());
        }
    }

    private void initIndexer() {
        if (!this.inited) {
            try {
                DefaultContainerConfiguration config = new DefaultContainerConfiguration();
                ClassLoader indexerLoader = NexusRepositoryIndexerImpl.class.getClassLoader();
                ClassWorld classWorld = new ClassWorld();
                ClassRealm plexusRealm = classWorld.newRealm("plexus.core", EmbedderFactory.class.getClassLoader());
                plexusRealm.importFrom(indexerLoader, "META-INF/sisu");
                plexusRealm.importFrom(indexerLoader, "org.apache.maven.index");
                plexusRealm.importFrom(indexerLoader, "org.netbeans.modules.maven.indexer");
                config.setClassWorld(classWorld);
                config.setClassPathScanning("index");
                this.embedder = new DefaultPlexusContainer((ContainerConfiguration)config);
                ComponentDescriptor desc = new ComponentDescriptor();
                desc.setRoleClass(ArtifactContextProducer.class);
                desc.setImplementationClass(CustomArtifactContextProducer.class);
                ComponentRequirement req = new ComponentRequirement();
                req.setFieldName("mapper");
                req.setRole(ArtifactPackagingMapper.class.getName());
                desc.addRequirement(req);
                this.embedder.addComponentDescriptor(desc);
                this.indexer = (Indexer)this.embedder.lookup(Indexer.class);
                this.searcher = (SearchEngine)this.embedder.lookup(SearchEngine.class);
                this.remoteIndexUpdater = (IndexUpdater)this.embedder.lookup(IndexUpdater.class);
                this.contextProducer = (ArtifactContextProducer)this.embedder.lookup(ArtifactContextProducer.class);
                this.scanner = new FastScanner(this.contextProducer);
                this.inited = true;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    public Map<String, IndexingContext> getIndexingContexts() {
        return Collections.unmodifiableMap(this.indexingContexts);
    }

    private IndexingContext addIndexingContextForced(RepositoryInfo repo, List<? extends IndexCreator> indexers) throws IOException {
        IndexingContext context = this.indexer.createIndexingContext(repo.getId(), repo.getId(), repo.isLocal() ? new File(repo.getRepositoryPath()) : null, NexusRepositoryIndexerImpl.getIndexDirectory(repo).toFile(), repo.isRemoteDownloadable() ? repo.getRepositoryUrl() : null, repo.isRemoteDownloadable() ? repo.getIndexUpdateUrl() : null, true, true, indexers);
        try {
            context.setAllGroups(Files.readAllLines(NexusRepositoryIndexerImpl.getAllGroupCacheFile(repo)));
            context.setRootGroups(Files.readAllLines(NexusRepositoryIndexerImpl.getRootGroupCacheFile(repo)));
        }
        catch (IOException ex) {
            NexusRepositoryIndexerImpl.rebuildGroupCache(repo, context);
        }
        this.indexingContexts.put(context.getId(), context);
        return context;
    }

    public void removeIndexingContext(IndexingContext context, boolean deleteFiles) throws IOException {
        if (this.indexingContexts.remove(context.getId()) != null) {
            this.indexer.closeIndexingContext(context, deleteFiles);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private boolean loadIndexingContext(RepositoryInfo info) throws IOException {
        block11: {
            if (!NexusRepositoryIndexerImpl.$assertionsDisabled && !NexusRepositoryIndexerImpl.getRepoMutex(info).isWriteAccess()) {
                throw new AssertionError();
            }
            this.initIndexer();
            context = this.getIndexingContexts().get(info.getId());
            indexUpdateUrl = info.getIndexUpdateUrl();
            if (context == null) ** GOTO lbl20
            contexturl = context.getIndexUpdateUrl();
            contextfile = context.getRepository();
            v0 = repofile = info.getRepositoryPath() != null ? new File(info.getRepositoryPath()) : null;
            if (BaseUtilities.compareObjects((Object)contexturl, (Object)indexUpdateUrl)) break block11;
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Remote context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
            ** GOTO lbl20
        }
        if (BaseUtilities.compareObjects((Object)contextfile, (Object)repofile)) {
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Skipping Context: {0}, already loaded.", info.getId());
        } else {
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Local context changed: {0}, unload/load", info.getId());
            this.unloadIndexingContext(info.getId());
lbl20:
            // 3 sources

            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "Loading Context: {0}", info.getId());
            creators /* !! */  = info.isLocal() != false ? List.of(new JarFileContentsIndexCreator(), new MinimalArtifactInfoIndexCreator(), new MavenArchetypeArtifactInfoIndexCreator(), new MavenPluginArtifactInfoIndexCreator(), new ArtifactDependencyIndexCreator(), new ClassDependencyIndexCreator()) : List.of(info.getId().equals(this.smo.getRepositoryId()) != false ? new MinimalArtifactInfoRemoteIndexCreator() : new MinimalArtifactInfoIndexCreator(), new NotifyingIndexCreator());
            try {
                this.addIndexingContextForced(info, creators /* !! */ );
                NexusRepositoryIndexerImpl.LOGGER.log(Level.FINE, "using index creators: {0}", creators /* !! */ );
            }
            catch (IOException | IllegalArgumentException ex) {
                NexusRepositoryIndexerImpl.LOGGER.log(Level.WARNING, "Found an incompatible or broken index at " + NexusRepositoryIndexerImpl.getIndexDirectory(info) + " with loaded contexts " + this.getIndexingContexts().keySet() + ", resetting.", ex);
                NexusRepositoryIndexerImpl.removeDir(NexusRepositoryIndexerImpl.getIndexDirectory(info));
            }
        }
        currents = new HashSet<String>();
        for (Object info2 : RepositoryPreferences.getInstance().getRepositoryInfos()) {
            currents.add(info2.getId());
        }
        toRemove = new HashSet<String>(this.getIndexingContexts().keySet());
        toRemove.removeAll(currents);
        if (!toRemove.isEmpty()) {
            for (String repo : toRemove) {
                try {
                    NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess((Mutex.ExceptionAction)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadIndexingContext$1(java.lang.String ), ()Ljava/lang/Void;)((NexusRepositoryIndexerImpl)this, (String)repo));
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!NexusRepositoryIndexerImpl.indexExists(indexDir = NexusRepositoryIndexerImpl.getIndexDirectory(info))) {
            NexusRepositoryIndexerImpl.LOGGER.log(Level.FINER, "Index Not Available: {0} at: {1}", new Object[]{info.getId(), indexDir.toAbsolutePath()});
            return true;
        }
        return false;
    }

    @CheckForNull
    private IteratorSearchResponse repeatedPagedSearch(org.apache.lucene.search.Query q, IndexingContext context, int count) throws IOException {
        return this.repeatedPagedSearch(q, List.of(context), count);
    }

    @CheckForNull
    private IteratorSearchResponse repeatedPagedSearch(org.apache.lucene.search.Query q, List<IndexingContext> contexts, int count) throws IOException {
        List list;
        IteratorSearchRequest isr = new IteratorSearchRequest(q, contexts, new NoJavadocSourceFilter());
        if (count > 0) {
            isr.setCount(count);
        }
        int MAX_MAX_CLAUSE = 2048;
        if (q instanceof BooleanQuery && (list = ((BooleanQuery)q).clauses()).size() == 1) {
            org.apache.lucene.search.Query q1 = ((BooleanClause)list.get(0)).getQuery();
            if (q1 instanceof PrefixQuery && "u".equals(((PrefixQuery)q1).getPrefix().field())) {
                MAX_MAX_CLAUSE = 65536;
            } else if (q1 instanceof TermQuery && "p".equals(((TermQuery)q1).getTerm().field())) {
                MAX_MAX_CLAUSE = 65536;
            }
        }
        int oldMax = IndexSearcher.getMaxClauseCount();
        try {
            int max = oldMax;
            while (true) {
                try {
                    IndexSearcher.setMaxClauseCount((int)max);
                    IteratorSearchResponse response = this.searcher.searchIteratorPaged(isr, contexts);
                    LOGGER.log(Level.FINE, "passed on {0} clauses processing {1} with {2} hits", new Object[]{max, q, response.getTotalHitsCount()});
                    IteratorSearchResponse iteratorSearchResponse = response;
                    return iteratorSearchResponse;
                }
                catch (IndexSearcher.TooManyClauses exc) {
                    block13: {
                        LOGGER.log(Level.FINE, "TooManyClauses on {0} clauses processing {1}", new Object[]{max, q});
                        if ((max *= 2) <= MAX_MAX_CLAUSE) break block13;
                        LOGGER.log(Level.WARNING, "Encountered more than {0} clauses processing {1}", new Object[]{MAX_MAX_CLAUSE, q});
                        IteratorSearchResponse iteratorSearchResponse = null;
                        IndexSearcher.setMaxClauseCount((int)oldMax);
                        return iteratorSearchResponse;
                    }
                    continue;
                }
                break;
            }
        }
        finally {
            IndexSearcher.setMaxClauseCount((int)oldMax);
        }
    }

    private void unloadIndexingContext(String repo) throws IOException {
        assert (NexusRepositoryIndexerImpl.getRepoMutex(repo).isWriteAccess());
        LOGGER.log(Level.FINE, "Unloading Context: {0}", repo);
        IndexingContext ic = this.getIndexingContexts().get(repo);
        if (ic != null) {
            this.removeIndexingContext(ic, false);
        }
    }

    /*
     * Exception decompiling
     */
    private void indexLoadedRepo(RepositoryInfo repo, boolean updateLocal) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [30[CATCHBLOCK]], but top level block is 11[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void pauseRemoteRepoIndexing(int minutes) {
        LOGGER.log(Level.INFO, "pausing index downloads for {0} {1}.", new Object[]{minutes, ChronoUnit.MINUTES});
        RepositoryPreferences.pauseIndexDownloadsFor(minutes, ChronoUnit.MINUTES);
    }

    private static boolean isNoSpaceLeftOnDevice(Throwable ex) {
        String msg = ex.getMessage();
        Throwable cause = ex.getCause();
        Throwable[] suppressed = ex.getSuppressed();
        return msg != null && msg.contains("No space left on device") || cause != null && NexusRepositoryIndexerImpl.isNoSpaceLeftOnDevice(cause) || suppressed.length > 0 && Stream.of(suppressed).anyMatch(NexusRepositoryIndexerImpl::isNoSpaceLeftOnDevice);
    }

    private static boolean isCancellation(Throwable ex) {
        return Stream.of(ex.getSuppressed()).anyMatch(s -> s instanceof Cancellation);
    }

    private static boolean isDiag() {
        return Boolean.getBoolean("maven.indexing.diag");
    }

    private boolean spawnIndexLoadedRepo(RepositoryInfo repo) {
        if (NexusRepositoryIndexerImpl.shouldSkipIndexRequest(repo)) {
            return false;
        }
        RequestProcessor rp = repo.isLocal() ? RP_LOCAL : RP_REMOTE;
        rp.post(() -> NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess(() -> {
            if (NexusRepositoryIndexerImpl.shouldSkipIndexRequest(repo)) {
                return null;
            }
            try {
                this.indexLoadedRepo(repo, true);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), ex);
            }
            return null;
        }));
        return true;
    }

    @Override
    public void indexRepo(RepositoryInfo repo) {
        if (NexusRepositoryIndexerImpl.shouldSkipIndexRequest(repo)) {
            return;
        }
        LOGGER.log(Level.FINER, "Indexing Context: {0}", repo);
        try {
            RemoteIndexTransferListener.addToActive(Thread.currentThread());
            NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess(() -> {
                if (NexusRepositoryIndexerImpl.shouldSkipIndexRequest(repo)) {
                    return null;
                }
                try {
                    this.initIndexer();
                    assert (this.indexer != null);
                    boolean noIndexExists = this.loadIndexingContext(repo);
                    this.indexLoadedRepo(repo, !noIndexExists);
                }
                catch (IOException x) {
                    LOGGER.log(Level.INFO, "could not (re-)index " + repo.getId(), x);
                }
                return null;
            });
        }
        finally {
            RemoteIndexTransferListener.removeFromActive(Thread.currentThread());
        }
    }

    private static boolean shouldSkipIndexRequest(RepositoryInfo repo) {
        if (repo.isRemoteDownloadable()) {
            if (!RepositoryPreferences.isIndexDownloadEnabledEffective()) {
                return true;
            }
            if (RepositoryPreferences.isIndexDownloadDeniedFor(repo)) {
                return true;
            }
            if (!RepositoryPreferences.isIndexDownloadAllowedFor(repo)) {
                IndexingNotificationProvider np = (IndexingNotificationProvider)Lookup.getDefault().lookup(IndexingNotificationProvider.class);
                if (np != null) {
                    np.requestPermissionsFor(repo);
                }
                return true;
            }
        }
        return false;
    }

    public void shutdownAll() {
        LOGGER.fine("Shutting Down All Contexts");
        try {
            if (this.inited) {
                for (IndexingContext ic : this.getIndexingContexts().values()) {
                    LOGGER.log(Level.FINER, "Shutting Down: {0}", ic.getId());
                    this.removeIndexingContext(ic, false);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void scan(IndexingContext context, String fromPath, ArtifactScanningListener listener, boolean update) throws IOException {
        File repositoryDirectory = context.getRepository();
        if (repositoryDirectory == null) {
            return;
        }
        if (!repositoryDirectory.exists()) {
            throw new IOException("Repository directory " + repositoryDirectory + " does not exist");
        }
        File tmpDir = new File(Places.getCacheDirectory(), "tmp-" + context.getRepositoryId());
        if (!tmpDir.mkdirs()) {
            throw new IOException("Cannot create temporary directory: " + tmpDir);
        }
        File tmpFile = new File(tmpDir, context.getId() + "-tmp");
        IndexingContext tmpContext = null;
        try {
            FSDirectory directory = FSDirectory.open((Path)tmpDir.toPath());
            if (update) {
                IndexUtils.copyDirectory(context.getIndexDirectory(), (Directory)directory);
            }
            tmpContext = new DefaultIndexingContext(context.getId() + "-tmp", context.getRepositoryId(), context.getRepository(), tmpDir, context.getRepositoryUrl(), context.getIndexUpdateUrl(), context.getIndexCreators(), true);
            DefaultScannerListener defaultListener = new DefaultScannerListener(tmpContext, (IndexerEngine)this.embedder.lookup(IndexerEngine.class), update, listener);
            this.scanner.scan(new ScanningRequest(tmpContext, defaultListener, fromPath));
            tmpContext.updateTimestamp(true);
            context.replace(tmpContext.getIndexDirectory());
        }
        catch (Exception ex) {
            throw new IOException("Error scanning context " + context.getId() + ": " + ex, ex);
        }
        finally {
            if (tmpContext != null) {
                tmpContext.close(true);
            }
            if (tmpFile.exists()) {
                tmpFile.delete();
            }
            FileUtils.deleteDirectory((File)tmpDir);
        }
    }

    @Override
    public void updateIndexWithArtifacts(RepositoryInfo repo, Collection<Artifact> artifacts) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess(() -> {
                boolean index = this.loadIndexingContext(repo);
                if (index) {
                    return null;
                }
                IndexingContext indexingContext = this.indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                    return null;
                }
                if (!indexingContext.getRepository().exists()) {
                    LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                    return null;
                }
                HashSet<ArtifactContext> artifactContexts = new HashSet<ArtifactContext>();
                for (Artifact artifact : artifacts) {
                    File art;
                    Object absolutePath;
                    if (artifact.getFile() != null) {
                        absolutePath = artifact.getFile().getAbsolutePath();
                    } else {
                        if (artifact.getVersion() == null) continue;
                        absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                    }
                    if (!(art = new File((String)absolutePath)).exists()) continue;
                    boolean add = artifact.isSnapshot();
                    if (!artifact.isSnapshot()) {
                        String id = artifact.getGroupId() + "|" + artifact.getArtifactId() + "|" + artifact.getVersion() + "|" + ArtifactInfo.nvl(artifact.getClassifier());
                        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST)).build();
                        IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, indexingContext, 1024);
                        boolean bl = add = response == null || response.getTotalHitsCount() == 0;
                        if (response != null) {
                            response.close();
                        }
                    }
                    if (add) {
                        LOGGER.log(Level.FINE, "indexing " + artifact.getId());
                        ArtifactContext ac = this.contextProducer.getArtifactContext(indexingContext, art);
                        artifactContexts.add(ac);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Skipped " + artifact.getId() + " already in index.");
                }
                try {
                    this.indexer.addArtifactsToIndex(artifactContexts, indexingContext);
                    NexusRepositoryIndexerImpl.storeGroupCache(repo, indexingContext);
                }
                catch (ZipError err) {
                    LOGGER.log(Level.INFO, "#230581 concurrent access to local repository file. Skipping..", err);
                }
                return null;
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NullPointerException x) {
            LOGGER.log(Level.INFO, "#201057", x);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    @Override
    public void deleteArtifactFromIndex(RepositoryInfo repo, Artifact artifact) {
        if (!RepositoryPreferences.isIndexRepositories()) {
            return;
        }
        ArtifactRepository repository = EmbedderFactory.getProjectEmbedder().getLocalRepository();
        try {
            NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess(() -> {
                Object absolutePath;
                boolean index = this.loadIndexingContext(repo);
                if (index) {
                    return null;
                }
                IndexingContext indexingContext = this.indexingContexts.get(repo.getId());
                if (indexingContext == null) {
                    LOGGER.log(Level.WARNING, "Indexing context could not be created: {0}", repo.getId());
                    return null;
                }
                if (!indexingContext.getRepository().exists()) {
                    LOGGER.log(Level.FINE, "Local repository at {0} doesn't exist, no update.", indexingContext.getRepository());
                    return null;
                }
                if (artifact.getFile() != null) {
                    absolutePath = artifact.getFile().getAbsolutePath();
                } else if (artifact.getVersion() != null) {
                    absolutePath = repo.getRepositoryPath() + File.separator + repository.pathOf(artifact);
                } else {
                    return null;
                }
                String extension = artifact.getArtifactHandler().getExtension();
                Object pomPath = ((String)absolutePath).substring(0, ((String)absolutePath).length() - extension.length());
                pomPath = (String)pomPath + "pom";
                File pom = new File((String)pomPath);
                if (pom.exists()) {
                    this.indexer.deleteArtifactsFromIndex(List.of(this.contextProducer.getArtifactContext(indexingContext, pom)), indexingContext);
                    NexusRepositoryIndexerImpl.storeGroupCache(repo, indexingContext);
                }
                return null;
            });
        }
        catch (MutexException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.fireChange(repo, () -> repo.fireIndexChange());
    }

    private void fireChange(RepositoryInfo repo, Runnable r) {
        if (NexusRepositoryIndexerImpl.getRepoMutex(repo).isWriteAccess()) {
            RequestProcessor.getDefault().post(() -> this.fireChange(repo, r));
            return;
        }
        assert (!NexusRepositoryIndexerImpl.getRepoMutex(repo).isWriteAccess() && !NexusRepositoryIndexerImpl.getRepoMutex(repo).isReadAccess());
        r.run();
    }

    @Override
    public ResultImplementation<String> getGroups(List<RepositoryInfo> repos) {
        return this.filterGroupIds("", repos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIndexing(Mutex mutex) {
        Set<Mutex> set = indexingMutexes;
        synchronized (set) {
            return indexingMutexes.contains(mutex);
        }
    }

    private void iterate(List<RepositoryInfo> repos, RepoAction action, RepoAction actionSkip, boolean skipUnIndexed) {
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (RepositoryInfo repo : repos) {
            Mutex mutex = NexusRepositoryIndexerImpl.getRepoMutex(repo);
            if (skipUnIndexed && NexusRepositoryIndexerImpl.isIndexing(mutex)) {
                try {
                    actionSkip.run(repo, null);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINER, "could not skip " + repo.getId(), ex);
                }
                continue;
            }
            mutex.writeAccess(() -> {
                try {
                    boolean index = this.loadIndexingContext(repo);
                    if (skipUnIndexed && index) {
                        if (!RepositoryPreferences.isIndexRepositories()) {
                            return null;
                        }
                        boolean spawned = this.spawnIndexLoadedRepo(repo);
                        if (spawned) {
                            actionSkip.run(repo, null);
                        }
                        return null;
                    }
                    IndexingContext context = this.getIndexingContexts().get(repo.getId());
                    if (context == null) {
                        if (skipUnIndexed) {
                            actionSkip.run(repo, null);
                        }
                        return null;
                    }
                    action.run(repo, context);
                }
                catch (IOException x) {
                    LOGGER.log(Level.INFO, "could not process " + repo.getId(), x);
                }
                return null;
            });
        }
    }

    private ResultImplementation<String> filterGroupIds(String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(res -> this.filterGroupIds(prefix, res, res.getSkipped(), false));
        return this.filterGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterGroupIds(String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> groups = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            Set<String> all = context.getAllGroups();
            if (!all.isEmpty()) {
                if (prefix.isEmpty()) {
                    groups.addAll(all);
                } else {
                    for (String gr : all) {
                        if (!gr.startsWith(prefix)) continue;
                        groups.add(gr);
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(groups);
        return result;
    }

    @Override
    public ResultImplementation<String> getGAVsForPackaging(String packaging, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.getGAVsForPackaging(packaging, result1, result1.getSkipped(), false));
        return this.getGAVsForPackaging(packaging, result, repos, true);
    }

    private ResultImplementation<String> getGAVsForPackaging(String packaging, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<String> infos = new ArrayList<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, packaging)), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        String gav = ai.getGroupId() + ":" + ai.getArtifactId() + ":" + ai.getVersion();
                        if (infos.contains(gav)) continue;
                        infos.add(gav);
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getRecords(String groupId, String artifactId, String version, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.getRecords(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.getRecords(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getRecords(String groupId, String artifactId, String version, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + artifactId + "|" + version + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id)), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 1024);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> getArtifacts(String groupId, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.getArtifacts(groupId, result1, result1.getSkipped(), false));
        return this.getArtifacts(groupId, result, repos, true);
    }

    private ResultImplementation<String> getArtifacts(String groupId, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getArtifactId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> getVersions(String groupId, String artifactId, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.getVersions(groupId, artifactId, result1, result1.getSkipped(), false));
        return this.getVersions(groupId, artifactId, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> getVersions(String groupId, String artifactId, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + artifactId + "|";
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 1024);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findVersionsByClass(String className, List<RepositoryInfo> repos) {
        Optional<RepositoryInfo> central = repos.stream().filter(repo -> repo.getId().equals(this.smo.getRepositoryId())).findFirst();
        if (central.isPresent()) {
            ArrayList<RepositoryInfo> otherRepos = new ArrayList<RepositoryInfo>(repos);
            otherRepos.remove(central.get());
            SearchRequest request = new SearchRequest(new Paging(128), (Query)FieldQuery.fieldQuery((Field)(className.contains(".") ? MAVEN.FQ_CLASS_NAME : MAVEN.CLASS_NAME), (String)className));
            return new CompositeResult<NBVersionInfo>(this.findVersionsByClass(className, otherRepos), new SMORequestResult(this.smo, request));
        }
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findVersionsByClass(className, result1, result1.getSkipped(), false));
        return this.findVersionsByClass(className, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findVersionsByClass(String className, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            String clsname = className.replace(".", "/");
            while (!clsname.isEmpty() && (clsname.startsWith("*") || clsname.startsWith("?"))) {
                clsname = clsname.substring(1);
            }
            if (clsname.isEmpty()) {
                return;
            }
            org.apache.lucene.search.Query q = NexusRepositoryIndexerImpl.setBooleanRewrite(this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH)));
            IteratorSearchResponse response = this.repeatedPagedSearch(q, context, 1024);
            if (response != null) {
                try {
                    infos.addAll(this.postProcessClasses(response.getResults(), clsname));
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private org.apache.lucene.search.Query constructQuery(org.apache.maven.index.Field f, String qs) {
        return this.indexer.constructQuery(f, new StringSearchExpression(qs));
    }

    @Override
    public ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(String className, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<RepositoryQueries.ClassUsage> result = new ResultImpl<RepositoryQueries.ClassUsage>(result1 -> this.findClassUsages(className, result1, result1.getSkipped(), false));
        return this.findClassUsages(className, result, repos, true);
    }

    private ResultImplementation<RepositoryQueries.ClassUsage> findClassUsages(String className, ResultImpl<RepositoryQueries.ClassUsage> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<RepositoryInfo> localRepos = new ArrayList<RepositoryInfo>();
        if (repos == null) {
            repos = RepositoryPreferences.getInstance().getRepositoryInfos();
        }
        for (RepositoryInfo repo2 : repos) {
            if (!repo2.isLocal()) continue;
            localRepos.add(repo2);
        }
        ArrayList<RepositoryQueries.ClassUsage> results = new ArrayList<RepositoryQueries.ClassUsage>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(localRepos, (repo, context) -> ClassDependencyIndexCreator.search(className, this.indexer, List.of(context), results), skipAction, skipUnIndexed);
        results.sort((r1, r2) -> r1.getArtifact().compareTo(r2.getArtifact()));
        result.setResults(results);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, @NullAllowed List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findDependencyUsage(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.findDependencyUsage(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findDependencyUsage(String groupId, String artifactId, String version, ResultImpl<NBVersionInfo> result, @NullAllowed List<RepositoryInfo> repos, boolean skipUnIndexed) {
        org.apache.lucene.search.Query q = ArtifactDependencyIndexCreator.query(groupId, artifactId, version);
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch(q, context, 1024);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBGroupInfo> findDependencyUsageGroups(String groupId, String artifactId, String version, List<RepositoryInfo> repos) {
        ResultImpl<NBGroupInfo> result = new ResultImpl<NBGroupInfo>(result1 -> this.findDependencyUsageGroups(groupId, artifactId, version, result1, result1.getSkipped(), false));
        return this.findDependencyUsageGroups(groupId, artifactId, version, result, repos, true);
    }

    private ResultImplementation<NBGroupInfo> findDependencyUsageGroups(String groupId, String artifactId, String version, ResultImpl<NBGroupInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        HashMap<String, NBGroupInfo> groupMap = new HashMap<String, NBGroupInfo>();
        HashMap<String, NBArtifactInfo> artifactMap = new HashMap<String, NBArtifactInfo>();
        ArrayList<NBGroupInfo> groupInfos = new ArrayList<NBGroupInfo>(result.getResults());
        ResultImpl<NBVersionInfo> res = new ResultImpl<NBVersionInfo>(result1 -> {});
        this.findDependencyUsage(groupId, artifactId, version, res, repos, skipUnIndexed);
        NexusRepositoryIndexerImpl.convertToNBGroupInfo(res.getResults(), groupMap, artifactMap, groupInfos);
        if (res.isPartial()) {
            result.addSkipped(res.getSkipped());
        }
        result.setResults(groupInfos);
        return result;
    }

    private static void convertToNBGroupInfo(Collection<NBVersionInfo> artifactInfos, Map<String, NBGroupInfo> groupMap, Map<String, NBArtifactInfo> artifactMap, List<NBGroupInfo> groupInfos) {
        for (NBVersionInfo ai : artifactInfos) {
            NBArtifactInfo ua;
            String groupId = ai.getGroupId();
            String artId = ai.getArtifactId();
            NBGroupInfo ug = groupMap.get(groupId);
            if (ug == null) {
                ug = new NBGroupInfo(groupId);
                groupInfos.add(ug);
                groupMap.put(groupId, ug);
            }
            if ((ua = artifactMap.get(artId)) == null) {
                ua = new NBArtifactInfo(artId);
                ug.addArtifactInfo(ua);
                artifactMap.put(artId, ua);
            }
            ua.addVersionInfo(ai);
        }
    }

    @Override
    public ResultImplementation<NBVersionInfo> findBySHA1(String sha1, List<RepositoryInfo> repos) {
        Optional<RepositoryInfo> central = repos.stream().filter(repo -> repo.getId().equals(this.smo.getRepositoryId())).findFirst();
        if (central.isPresent()) {
            ArrayList<RepositoryInfo> otherRepos = new ArrayList<RepositoryInfo>(repos);
            otherRepos.remove(central.get());
            SearchRequest request = new SearchRequest(new Paging(8), (Query)FieldQuery.fieldQuery((Field)MAVEN.SHA1, (String)sha1));
            return new CompositeResult<NBVersionInfo>(this.findBySHA1(sha1, otherRepos), new SMORequestResult(this.smo, request));
        }
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findBySHA1(sha1, result1, result1.getSkipped(), false));
        return this.findBySHA1(sha1, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findBySHA1(String sha1, ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, (repo, context) -> {
            BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(this.constructQuery(org.apache.maven.index.MAVEN.SHA1, sha1)), BooleanClause.Occur.SHOULD)).build();
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, 1024);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> findArchetypes(List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.findArchetypes(result1, result1.getSkipped(), false));
        return this.findArchetypes(result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> findArchetypes(ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-archetype")), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo ai : response) {
                        infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                    }
                }
                finally {
                    result.addReturnedResultCount(response.getTotalProcessedArtifactInfoCount());
                    result.addTotalResultCount(response.getTotalHitsCount());
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginArtifactIds(String groupId, String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.filterPluginArtifactIds(groupId, prefix, result1, result1.getSkipped(), false));
        return this.filterPluginArtifactIds(groupId, prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginArtifactIds(String groupId, String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        String id = groupId + "|" + prefix;
        BooleanQuery bq = new BooleanQuery.Builder().add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST)).add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.UINFO, id))), BooleanClause.Occur.MUST)).build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getArtifactId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<String> filterPluginGroupIds(String prefix, List<RepositoryInfo> repos) {
        ResultImpl<String> result = new ResultImpl<String>(result1 -> this.filterPluginGroupIds(prefix, result1, result1.getSkipped(), false));
        return this.filterPluginGroupIds(prefix, result, repos, true);
    }

    private ResultImplementation<String> filterPluginGroupIds(String prefix, ResultImpl<String> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        TreeSet<String> artifacts = new TreeSet<String>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new BooleanClause((org.apache.lucene.search.Query)new TermQuery(new Term(ArtifactInfo.PACKAGING, "maven-plugin")), BooleanClause.Occur.MUST));
        if (!prefix.isEmpty()) {
            builder.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite((org.apache.lucene.search.Query)new PrefixQuery(new Term(ArtifactInfo.GROUP_ID, prefix))), BooleanClause.Occur.MUST));
        }
        BooleanQuery bq = builder.build();
        this.iterate(repos, (repo, context) -> {
            IteratorSearchResponse response = this.repeatedPagedSearch((org.apache.lucene.search.Query)bq, context, -1);
            if (response != null) {
                try {
                    for (ArtifactInfo artifactInfo : response.getResults()) {
                        artifacts.add(artifactInfo.getGroupId());
                    }
                }
                finally {
                    response.close();
                }
            }
        }, skipAction, skipUnIndexed);
        result.setResults(artifacts);
        return result;
    }

    @Override
    public ResultImplementation<NBVersionInfo> find(List<QueryField> fields, List<RepositoryInfo> repos) {
        ResultImpl<NBVersionInfo> result = new ResultImpl<NBVersionInfo>(result1 -> this.find(fields, result1, result1.getSkipped(), false));
        return this.find(fields, result, repos, true);
    }

    private ResultImplementation<NBVersionInfo> find(final List<QueryField> fields, final ResultImpl<NBVersionInfo> result, List<RepositoryInfo> repos, boolean skipUnIndexed) {
        final ArrayList<NBVersionInfo> infos = new ArrayList<NBVersionInfo>(result.getResults());
        SkippedAction skipAction = new SkippedAction(result);
        this.iterate(repos, new RepoAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                for (QueryField field : fields) {
                    Object q;
                    BooleanClause.Occur occur;
                    block22: {
                        occur = field.getOccur() == 1 ? BooleanClause.Occur.SHOULD : BooleanClause.Occur.MUST;
                        String fieldName = NexusRepositoryIndexerImpl.this.toNexusField(field.getField());
                        String one = field.getValue();
                        while (!one.isEmpty() && (one.startsWith("*") || one.startsWith("?"))) {
                            one = one.substring(1);
                        }
                        if (one.isEmpty() || fieldName == null) continue;
                        if (ArtifactInfo.NAMES.equals(fieldName)) {
                            try {
                                String clsname = one.replace(".", "/");
                                q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                String clsname = QueryParser.escape((String)one.replace(".", "/"));
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.CLASSNAMES, clsname.toLowerCase(Locale.ENGLISH));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        if (ArtifactInfo.ARTIFACT_ID.equals(fieldName)) {
                            String aid = one.replace("-", "?").replace(".", "?");
                            try {
                                q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.ARTIFACT_ID, aid);
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.ARTIFACT_ID, QueryParser.escape((String)aid));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        if (ArtifactInfo.GROUP_ID.equals(fieldName)) {
                            String gid = one.replace("-", "?").replace(".", "?");
                            try {
                                q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.GROUP_ID, gid);
                                break block22;
                            }
                            catch (IllegalArgumentException iae) {
                                try {
                                    q = NexusRepositoryIndexerImpl.this.constructQuery(org.apache.maven.index.MAVEN.GROUP_ID, QueryParser.escape((String)gid));
                                    break block22;
                                }
                                catch (IllegalArgumentException iae2) {
                                    continue;
                                }
                            }
                        }
                        q = field.getMatch() == 0 ? new TermQuery(new Term(fieldName, one)) : new PrefixQuery(new Term(fieldName, one));
                    }
                    bq.add(new BooleanClause(NexusRepositoryIndexerImpl.setBooleanRewrite(q), occur));
                }
                IteratorSearchResponse resp = NexusRepositoryIndexerImpl.this.repeatedPagedSearch((org.apache.lucene.search.Query)bq.build(), context, 1024);
                if (resp != null) {
                    try {
                        for (ArtifactInfo ai : resp) {
                            infos.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai));
                        }
                    }
                    finally {
                        result.addReturnedResultCount(resp.getTotalProcessedArtifactInfoCount());
                        result.addTotalResultCount(resp.getTotalHitsCount());
                        resp.close();
                    }
                }
            }
        }, skipAction, skipUnIndexed);
        this.doSortIssue226100(infos);
        result.setResults(infos);
        return result;
    }

    private void doSortIssue226100(List<NBVersionInfo> infos) {
        try {
            Collections.sort(infos);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
    }

    private void doLogError226100(List<NBVersionInfo> infos, Exception ex) throws RuntimeException {
        StringBuilder versions = new StringBuilder();
        for (NBVersionInfo info : infos) {
            versions.append(info.getVersion()).append(",");
        }
        String message = "Issue #226100: Versions compared are:" + versions.toString();
        LOGGER.log(Level.WARNING, message);
        boolean rethrow = false;
        if (!$assertionsDisabled) {
            rethrow = false;
            if (!false) {
                throw new AssertionError();
            }
        }
        if (rethrow) {
            throw new RuntimeException(message, ex);
        }
    }

    @Override
    public List<RepositoryInfo> getLoaded(List<RepositoryInfo> repos) {
        ArrayList<RepositoryInfo> toRet = new ArrayList<RepositoryInfo>(repos.size());
        for (RepositoryInfo repo : repos) {
            Path loc = NexusRepositoryIndexerImpl.getIndexDirectory(repo);
            if (!NexusRepositoryIndexerImpl.indexExists(loc)) continue;
            toRet.add(repo);
        }
        return toRet;
    }

    private static boolean indexExists(Path path) {
        try {
            return Files.exists(path.resolve("timestamp"), new LinkOption[0]) && DirectoryReader.indexExists((Directory)new MMapDirectory(path));
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINER, "Unable to verify index location at " + path, ex);
            return false;
        }
    }

    private String toNexusField(String field) {
        if (field != null) {
            switch (field) {
                case "artifactId": {
                    return ArtifactInfo.ARTIFACT_ID;
                }
                case "groupId": {
                    return ArtifactInfo.GROUP_ID;
                }
                case "version": {
                    return ArtifactInfo.VERSION;
                }
                case "classes": {
                    return ArtifactInfo.NAMES;
                }
                case "name": {
                    return ArtifactInfo.NAME;
                }
                case "description": {
                    return ArtifactInfo.DESCRIPTION;
                }
                case "packaging": {
                    return ArtifactInfo.PACKAGING;
                }
            }
        }
        return field;
    }

    private Collection<NBVersionInfo> postProcessClasses(IteratorResultSet artifactInfos, String classname) {
        ArrayList<NBVersionInfo> toRet = new ArrayList<NBVersionInfo>();
        int patter = 40;
        boolean isPath = classname.contains("/");
        if (isPath) {
            for (ArtifactInfo i : artifactInfos) {
                toRet.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(i));
            }
            return toRet;
        }
        String pattStr = ".*/" + classname + "$.*";
        Pattern patt = Pattern.compile(pattStr, patter);
        ArrayList<ArtifactInfo> altArtifactInfos = new ArrayList<ArtifactInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            Matcher m = patt.matcher(ai.getClassNames());
            if (!m.matches()) continue;
            altArtifactInfos.add(ai);
        }
        for (ArtifactInfo i : altArtifactInfos) {
            toRet.add(NexusRepositoryIndexerImpl.convertToNBVersionInfo(i));
        }
        return toRet;
    }

    static List<NBVersionInfo> convertToNBVersionInfo(Collection<ArtifactInfo> artifactInfos) {
        ArrayList<NBVersionInfo> bVersionInfos = new ArrayList<NBVersionInfo>();
        for (ArtifactInfo ai : artifactInfos) {
            NBVersionInfo nbvi = NexusRepositoryIndexerImpl.convertToNBVersionInfo(ai);
            if (nbvi == null) continue;
            bVersionInfos.add(nbvi);
        }
        return bVersionInfos;
    }

    static NBVersionInfo convertToNBVersionInfo(ArtifactInfo ai) {
        if ("javadoc".equals(ai.getClassifier()) || "sources".equals(ai.getClassifier())) {
            return null;
        }
        NBVersionInfo nbvi = new NBVersionInfo(ai.getRepository(), ai.getGroupId(), ai.getArtifactId(), ai.getVersion(), ai.getFileExtension(), ai.getPackaging(), ai.getName(), ai.getDescription(), ai.getClassifier());
        nbvi.setJavadocExists(ai.getJavadocExists() == ArtifactAvailability.PRESENT);
        nbvi.setSourcesExists(ai.getSourcesExists() == ArtifactAvailability.PRESENT);
        nbvi.setSignatureExists(ai.getSignatureExists() == ArtifactAvailability.PRESENT);
        nbvi.setLastModified(ai.getLastModified());
        nbvi.setSize(ai.getSize());
        nbvi.setLuceneScore(ai.getLuceneScore());
        return nbvi;
    }

    private static org.apache.lucene.search.Query setBooleanRewrite(org.apache.lucene.search.Query q) {
        if (q instanceof MultiTermQuery) {
            ((MultiTermQuery)q).setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
        } else if (q instanceof BooleanQuery) {
            for (BooleanClause c : ((BooleanQuery)q).clauses()) {
                NexusRepositoryIndexerImpl.setBooleanRewrite(c.getQuery());
            }
        }
        return q;
    }

    private ResourceFetcher createFetcher(Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
        return new WagonFetcher(wagon, listener, authenticationInfo, proxyInfo);
    }

    private static Path getIndexDirectory() {
        return Places.getCacheSubdirectory((String)"mavenindex").toPath();
    }

    private static Path getIndexDirectory(RepositoryInfo info) {
        return NexusRepositoryIndexerImpl.getIndexDirectory().resolve(info.getId());
    }

    private static Path getAllGroupCacheFile(RepositoryInfo info) {
        return NexusRepositoryIndexerImpl.getIndexDirectory(info).resolve("nb-groupcache-all-v1.txt");
    }

    private static Path getRootGroupCacheFile(RepositoryInfo info) {
        return NexusRepositoryIndexerImpl.getIndexDirectory(info).resolve("nb-groupcache-root-v1.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeGroupCache(RepositoryInfo repo, IndexingContext context) throws IOException {
        Path indexDir = NexusRepositoryIndexerImpl.getIndexDirectory(repo);
        Path tempAllCache = Files.createTempFile(indexDir, GROUP_CACHE_ALL_PREFIX, "txt", new FileAttribute[0]);
        Path tempRootCache = Files.createTempFile(indexDir, GROUP_CACHE_ROOT_PREFIX, "txt", new FileAttribute[0]);
        try {
            Files.write(tempAllCache, context.getAllGroups(), new OpenOption[0]);
            Files.move(tempAllCache, NexusRepositoryIndexerImpl.getAllGroupCacheFile(repo), StandardCopyOption.REPLACE_EXISTING);
            Files.write(tempRootCache, context.getRootGroups(), new OpenOption[0]);
            Files.move(tempRootCache, NexusRepositoryIndexerImpl.getRootGroupCacheFile(repo), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tempAllCache);
            Files.deleteIfExists(tempRootCache);
        }
    }

    private static void removeGroupCache(RepositoryInfo repo) throws IOException {
        Files.deleteIfExists(NexusRepositoryIndexerImpl.getAllGroupCacheFile(repo));
        Files.deleteIfExists(NexusRepositoryIndexerImpl.getRootGroupCacheFile(repo));
    }

    private static void rebuildGroupCache(RepositoryInfo repo, IndexingContext context) throws IOException {
        NexusRepositoryIndexerImpl.removeGroupCache(repo);
        (repo.isLocal() ? RP_LOCAL : RP_REMOTE).submit(() -> NexusRepositoryIndexerImpl.getRepoMutex(repo).writeAccess(() -> {
            Path allGroupsPath = NexusRepositoryIndexerImpl.getAllGroupCacheFile(repo);
            Path rootGroupsPath = NexusRepositoryIndexerImpl.getRootGroupCacheFile(repo);
            if (Files.exists(allGroupsPath, new LinkOption[0]) && Files.exists(rootGroupsPath, new LinkOption[0])) {
                return;
            }
            try {
                LOGGER.log(Level.FINE, "Rebuilding group cache for {0}", repo.getId());
                long start = System.currentTimeMillis();
                context.rebuildGroups();
                NexusRepositoryIndexerImpl.storeGroupCache(repo, context);
                LOGGER.log(Level.INFO, "Group cache rebuilding of {0} took {1}s.", new Object[]{repo.getId(), System.currentTimeMillis() - start});
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to rebuild groups for repo: " + repo.getId(), e);
            }
        }));
    }

    private static void removeDir(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.deleteIfExists(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static long getFreeSpaceInMB(Path path) {
        try {
            return Files.getFileStore(path).getUsableSpace() / 0x100000L;
        }
        catch (IOException ignore) {
            return -1L;
        }
    }

    private static /* synthetic */ void lambda$indexLoadedRepo$6(RepositoryInfo repo) {
        repo.fireIndexChange();
    }

    private static /* synthetic */ void lambda$indexLoadedRepo$5(RepositoryInfo repo) {
        repo.fireNoIndex();
    }

    private static /* synthetic */ boolean lambda$indexLoadedRepo$4(IndexCreator c) {
        return c instanceof NotifyingIndexCreator;
    }

    private static /* synthetic */ boolean lambda$indexLoadedRepo$3(Instant cutoff, Document doc) {
        IndexableField date = doc.getField(MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey());
        return date != null && Instant.ofEpochMilli(Long.parseLong(date.stringValue())).isAfter(cutoff);
    }

    private static /* synthetic */ FSDirectory lambda$indexLoadedRepo$2(File file) throws IOException {
        return MMapDirectory.open((Path)file.toPath());
    }

    private /* synthetic */ Void lambda$loadIndexingContext$1(String repo) throws Exception {
        this.unloadIndexingContext(repo);
        return null;
    }

    private static class NoJavadocSourceFilter
    implements ArtifactInfoFilter {
        private NoJavadocSourceFilter() {
        }

        @Override
        public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
            return !"javadoc".equals(ai.getClassifier()) && !"sources".equals(ai.getClassifier());
        }
    }

    private static interface RepoAction {
        public void run(RepositoryInfo var1, IndexingContext var2) throws IOException;
    }

    private static class SkippedAction
    implements RepoAction {
        private final ResultImpl<?> result;

        private SkippedAction(ResultImpl<?> result) {
            this.result = result;
        }

        @Override
        public void run(RepositoryInfo repo, IndexingContext context) throws IOException {
            this.result.addSkipped(repo);
        }
    }

    private static class WagonFetcher
    implements ResourceFetcher {
        private final TransferListener listener;
        private final AuthenticationInfo authenticationInfo;
        private final ProxyInfo proxyInfo;
        private final Wagon wagon;

        public WagonFetcher(Wagon wagon, TransferListener listener, AuthenticationInfo authenticationInfo, ProxyInfo proxyInfo) {
            Objects.requireNonNull(wagon);
            Objects.requireNonNull(listener);
            this.wagon = wagon;
            this.listener = listener;
            this.authenticationInfo = authenticationInfo;
            this.proxyInfo = proxyInfo;
        }

        @Override
        public void connect(String id, String url) throws IOException {
            Repository repository = new Repository(id, url);
            try {
                this.wagon.addTransferListener(this.listener);
                if (this.authenticationInfo != null) {
                    if (this.proxyInfo != null) {
                        this.wagon.connect(repository, this.authenticationInfo, this.proxyInfo);
                    } else {
                        this.wagon.connect(repository, this.authenticationInfo);
                    }
                } else if (this.proxyInfo != null) {
                    this.wagon.connect(repository, this.proxyInfo);
                } else {
                    this.wagon.connect(repository);
                }
            }
            catch (AuthenticationException ex) {
                String msg = "Authentication exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
            catch (WagonException ex) {
                String msg = "Wagon exception connecting to " + repository;
                this.logError(msg, (Exception)((Object)ex));
                throw new IOException(msg, ex);
            }
        }

        @Override
        public void disconnect() throws IOException {
            try {
                this.wagon.disconnect();
            }
            catch (ConnectionException ex) {
                throw new IOException(ex.toString(), ex);
            }
        }

        @Override
        public InputStream retrieve(String name) throws IOException, FileNotFoundException {
            if (NexusRepositoryIndexerImpl.isDiag()) {
                String id = this.wagon.getRepository().getId();
                if (name.endsWith(".properties") && System.getProperty("maven.diag.index.properties." + id) != null) {
                    LOGGER.log(Level.INFO, "maven indexer will use local properties file: {0}", System.getProperty("maven.diag.index.properties." + id));
                    return new FileInputStream(new File(System.getProperty("maven.diag.index.properties." + id)));
                }
                if (name.endsWith(".gz") && System.getProperty("maven.diag.index.gz." + id) != null) {
                    LOGGER.log(Level.INFO, "maven indexer will use gz file: {0}", System.getProperty("maven.diag.index.gz." + id));
                    return new FileInputStream(new File(System.getProperty("maven.diag.index.gz." + id)));
                }
            }
            final File target = Files.createTempFile("fetcher-" + name, "", new FileAttribute[0]).toFile();
            target.deleteOnExit();
            try {
                this.retrieve(name, target);
            }
            catch (Exception | Cancellation ex) {
                target.delete();
                throw ex;
            }
            return new FileInputStream(target){

                @Override
                public void close() throws IOException {
                    super.close();
                    target.delete();
                }
            };
        }

        public void retrieve(String name, File targetFile) throws IOException {
            try {
                this.wagon.get(name, targetFile);
            }
            catch (AuthorizationException e) {
                targetFile.delete();
                String msg = "Authorization exception retrieving " + name;
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg, e);
            }
            catch (ResourceDoesNotExistException e) {
                targetFile.delete();
                String msg = "Resource " + name + " does not exist";
                this.logError(msg, (Exception)((Object)e));
                FileNotFoundException fileNotFoundException = new FileNotFoundException(msg);
                fileNotFoundException.initCause(e);
                throw fileNotFoundException;
            }
            catch (WagonException e) {
                targetFile.delete();
                String msg = "Transfer for " + name + " failed";
                this.logError(msg, (Exception)((Object)e));
                throw new IOException(msg + "; " + e.getMessage(), e);
            }
        }

        private void logError(String msg, Exception ex) {
            if (this.listener != null) {
                this.listener.debug(msg + "; " + ex.getMessage());
            }
        }
    }
}

