/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.context.impl;

import net.java.html.BrwsrCtx;
import org.netbeans.html.context.impl.CtxAccssr;
import org.netbeans.html.context.spi.Contexts;

public final class CtxImpl {
    private Bind<?>[] techs;
    private final Object[] context;

    public CtxImpl(Object[] context) {
        this(context, new Bind[0]);
    }

    private CtxImpl(Object[] context, Bind<?>[] techs) {
        this.techs = techs;
        this.context = context;
    }

    public static <Tech> Tech find(BrwsrCtx context, Class<Tech> technology) {
        CtxImpl impl = CtxAccssr.getDefault().find(context);
        for (Bind<?> bind : impl.techs) {
            if (technology != ((Bind)bind).clazz) continue;
            return technology.cast(((Bind)bind).impl);
        }
        return null;
    }

    public BrwsrCtx build() {
        new BindCompare().sort(this.techs);
        CtxImpl impl = new CtxImpl(this.context, (Bind[])this.techs.clone());
        BrwsrCtx ctx = CtxAccssr.getDefault().newContext(impl);
        return ctx;
    }

    public <Tech> void register(Class<Tech> type, Tech impl, int priority) {
        this.techs = new BindCompare().add(this.techs, new Bind<Tech>(type, impl, priority));
    }

    private static final class Bind<Tech> {
        private final Class<Tech> clazz;
        private final Tech impl;
        private final int priority;

        public Bind(Class<Tech> clazz, Tech impl, int priority) {
            this.clazz = clazz;
            this.impl = impl;
            this.priority = priority;
        }

        public String toString() {
            return "Bind{clazz=" + this.clazz + "@" + this.clazz.getClassLoader() + ", impl=" + this.impl + ", priority=" + this.priority + '}';
        }
    }

    private final class BindCompare {
        private BindCompare() {
        }

        void sort(Bind<?>[] techs) {
            for (int i = 0; i < techs.length; ++i) {
                Bind<?> min = techs[i];
                int minIndex = i;
                for (int j = i + 1; j < techs.length; ++j) {
                    if (this.compare(min, techs[j]) <= 0) continue;
                    min = techs[j];
                    minIndex = j;
                }
                if (minIndex == i) continue;
                techs[minIndex] = techs[i];
                techs[i] = min;
            }
        }

        private <Tech> Bind<?>[] add(Bind<?>[] techs, Bind<Tech> bind) {
            Bind[] newArr = new Bind[techs.length + 1];
            for (int i = 0; i < techs.length; ++i) {
                newArr[i] = techs[i];
            }
            newArr[techs.length] = bind;
            return newArr;
        }

        private boolean isPrefered(Bind<?> b) {
            Class<?> implClazz = ((Bind)b).impl.getClass();
            Contexts.Id id = implClazz.getAnnotation(Contexts.Id.class);
            if (id == null) {
                return false;
            }
            for (String v : id.value()) {
                for (Object c : CtxImpl.this.context) {
                    if (!v.equals(c)) continue;
                    return true;
                }
            }
            return false;
        }

        private int compare(Bind<?> o1, Bind<?> o2) {
            boolean p2;
            boolean p1 = this.isPrefered(o1);
            if (p1 != (p2 = this.isPrefered(o2))) {
                return p1 ? -1 : 1;
            }
            if (((Bind)o1).priority != ((Bind)o2).priority) {
                return ((Bind)o1).priority - ((Bind)o2).priority;
            }
            return ((Bind)o1).clazz.getName().compareTo(((Bind)o2).clazz.getName());
        }
    }
}

