/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Bundle;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class NavigatorPanelImpl
extends Children.Keys<Either<SymbolInformation, DocumentSymbol>>
implements NavigatorPanel,
LSPBindings.BackgroundTask,
LookupListener {
    private static final Logger LOG = Logger.getLogger(NavigatorPanelImpl.class.getName());
    private static final NavigatorPanelImpl INSTANCE = new NavigatorPanelImpl();
    private final ExplorerManager manager = new ExplorerManager();
    private View view;
    private Lookup.Result<FileObject> result;
    private FileObject file;

    public NavigatorPanelImpl() {
        this.manager.setRootContext((Node)new AbstractNode((Children)this));
    }

    public String getDisplayName() {
        return Bundle.DN_Symbols();
    }

    public String getDisplayHint() {
        return "symbols";
    }

    public JComponent getComponent() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public void panelActivated(Lookup context) {
        this.result = context.lookupResult(FileObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.updateFile();
    }

    public void panelDeactivated() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
        this.updateFile();
    }

    private void updateFile() {
        if (this.file != null) {
            LSPBindings.removeBackgroundTask(this.file, this);
            this.setKeys(Collections.emptyList());
            this.file = null;
        }
        List files = this.result != null ? this.result.allInstances() : Collections.emptyList();
        FileObject fileObject = this.file = files.isEmpty() ? null : (FileObject)files.iterator().next();
        if (this.file != null) {
            LSPBindings.addBackgroundTask(this.file, this);
        }
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        if (file.equals(this.file)) {
            try {
                String uri = Utils.toURI(file);
                List<Either<SymbolInformation, DocumentSymbol>> symbols = bindings.getTextDocumentService().documentSymbol(new DocumentSymbolParams(new TextDocumentIdentifier(uri))).get();
                this.setKeys(symbols);
                SwingUtilities.invokeLater(() -> this.view.expandAll());
            }
            catch (ExecutionException ex) {
                LOG.log(Level.FINE, null, ex);
                this.setKeys(Collections.emptyList());
            }
            catch (InterruptedException ex) {
                LSPBindings.addBackgroundTask(file, this);
            }
        }
    }

    protected Node[] createNodes(Either<SymbolInformation, DocumentSymbol> sym) {
        return new Node[]{new NodeImpl(Utils.toURI(this.file), sym)};
    }

    public void resultChanged(LookupEvent arg0) {
        this.updateFile();
    }

    private class View
    extends JPanel
    implements ExplorerManager.Provider {
        private final BeanTreeView internalView;

        public View() {
            this.setLayout(new BorderLayout());
            this.internalView = new BeanTreeView();
            this.add((Component)this.internalView, "Center");
            this.internalView.setRootVisible(false);
        }

        public ExplorerManager getExplorerManager() {
            return NavigatorPanelImpl.this.manager;
        }

        public void expandAll() {
            boolean scrollsOnExpand = this.internalView.getScrollsOnExpand();
            this.internalView.setScrollsOnExpand(false);
            this.internalView.expandAll();
            this.internalView.setScrollsOnExpand(scrollsOnExpand);
        }
    }

    private static final class NodeImpl
    extends AbstractNode {
        private final Action open;

        private static Children createChildren(String currentFileUri, Either<SymbolInformation, DocumentSymbol> sym) {
            if (sym.isLeft()) {
                return Children.LEAF;
            }
            return NodeImpl.createChildren(currentFileUri, (DocumentSymbol)sym.getRight());
        }

        private static Children createChildren(final String currentFileUri, final DocumentSymbol sym) {
            if (sym.getChildren() == null || sym.getChildren().isEmpty()) {
                return Children.LEAF;
            }
            return new Children.Keys<DocumentSymbol>(){

                protected void addNotify() {
                    this.setKeys(sym.getChildren());
                }

                protected Node[] createNodes(DocumentSymbol sym2) {
                    return new Node[]{new NodeImpl(currentFileUri, sym2)};
                }

                protected void removeNotify() {
                    this.setKeys(Collections.emptyList());
                }
            };
        }

        private static Action createOpenAction(final String uri, final Range range) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Utils.open(uri, range);
                }
            };
        }

        public NodeImpl(String currentFileUri, Either<SymbolInformation, DocumentSymbol> symbol) {
            super(NodeImpl.createChildren(currentFileUri, symbol));
            if (symbol.isLeft()) {
                this.setDisplayName(((SymbolInformation)symbol.getLeft()).getName());
                this.setIconBaseWithExtension(Icons.getSymbolIconBase(((SymbolInformation)symbol.getLeft()).getKind()));
                this.open = NodeImpl.createOpenAction(((SymbolInformation)symbol.getLeft()).getLocation().getUri(), ((SymbolInformation)symbol.getLeft()).getLocation().getRange());
            } else {
                this.setDisplayName(((DocumentSymbol)symbol.getRight()).getName());
                this.setIconBaseWithExtension(Icons.getSymbolIconBase(((DocumentSymbol)symbol.getRight()).getKind()));
                this.open = NodeImpl.createOpenAction(currentFileUri, ((DocumentSymbol)symbol.getRight()).getRange());
            }
        }

        public NodeImpl(String currentFileUri, DocumentSymbol symbol) {
            super(NodeImpl.createChildren(currentFileUri, symbol));
            this.setDisplayName(symbol.getName());
            this.setIconBaseWithExtension(Icons.getSymbolIconBase(symbol.getKind()));
            this.open = NodeImpl.createOpenAction(currentFileUri, symbol.getRange());
        }

        public Action getPreferredAction() {
            return this.open;
        }
    }

    public static final class DynamicRegistrationImpl
    implements NavigatorPanel.DynamicRegistration {
        public Collection<? extends NavigatorPanel> panelsFor(URI uri) {
            try {
                FileObject file = URLMapper.findFileObject((URL)uri.toURL());
                if (file != null) {
                    return LSPBindings.getBindings(file) != null ? Collections.singletonList(INSTANCE) : Collections.emptyList();
                }
                return Collections.emptyList();
            }
            catch (MalformedURLException ex) {
                return Collections.emptyList();
            }
        }
    }
}

