/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.ResourceBundle;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.DiffStreamSource;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.openide.util.NbBundle;

public final class Setup
extends AbstractDiffSetup {
    private final File baseFile;
    private final String firstRevision;
    private final String secondRevision;
    private DiffStreamSource firstSource;
    private DiffStreamSource secondSource;
    private DiffController view;
    private DiffNode node;
    private String title;

    public Setup(GitFileNode<FileInformation> node, FileInformation.Mode mode, Revision revision) {
        String secondTitle;
        String firstTitle;
        this.baseFile = node.getFile();
        ResourceBundle loc = NbBundle.getBundle(Setup.class);
        FileInformation info = (FileInformation)node.getInformation();
        File originalFile = null;
        if (info != null && (info.isCopied() || info.isRenamed())) {
            originalFile = info.getOldFile();
        }
        switch (mode) {
            case HEAD_VS_WORKING_TREE: 
            case HEAD_VS_INDEX: {
                this.firstRevision = originalFile == null && info.containsStatus(EnumSet.of(FileInformation.Status.NEW_HEAD_WORKING_TREE, FileInformation.Status.NEW_HEAD_INDEX)) ? null : revision.getCommitId();
                firstTitle = originalFile == null ? revision.toString() : MessageFormat.format(loc.getString("MSG_DiffPanel_Revision.file"), revision.toString(), originalFile.getName());
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.firstRevision = "INDEX";
                firstTitle = MessageFormat.format(loc.getString("MSG_DiffPanel_IndexRevision"), this.firstRevision);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diff type: " + mode);
            }
        }
        switch (mode) {
            case HEAD_VS_WORKING_TREE: 
            case INDEX_VS_WORKING_TREE: {
                if (info.containsStatus(FileInformation.Status.NEW_HEAD_WORKING_TREE)) {
                    this.secondRevision = "CURRENT";
                    if (originalFile != null) {
                        if (info.isRenamed()) {
                            secondTitle = loc.getString("MSG_DiffPanel_LocalRenamed");
                            break;
                        }
                        secondTitle = loc.getString("MSG_DiffPanel_LocalCopied");
                        break;
                    }
                    secondTitle = loc.getString("MSG_DiffPanel_LocalNew");
                    break;
                }
                if (info.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_LocalDeleted");
                    break;
                }
                this.secondRevision = "CURRENT";
                secondTitle = loc.getString("MSG_DiffPanel_LocalModified");
                break;
            }
            case HEAD_VS_INDEX: {
                if (info.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
                    this.secondRevision = "INDEX";
                    if (originalFile != null) {
                        if (info.isRenamed()) {
                            secondTitle = loc.getString("MSG_DiffPanel_IndexRenamed");
                            break;
                        }
                        secondTitle = loc.getString("MSG_DiffPanel_IndexCopied");
                        break;
                    }
                    secondTitle = loc.getString("MSG_DiffPanel_IndexNew");
                    break;
                }
                if (info.containsStatus(FileInformation.Status.REMOVED_HEAD_INDEX)) {
                    this.secondRevision = null;
                    secondTitle = loc.getString("MSG_DiffPanel_IndexDeleted");
                    break;
                }
                this.secondRevision = "INDEX";
                secondTitle = loc.getString("MSG_DiffPanel_IndexModified");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown diff type: " + mode);
            }
        }
        this.firstSource = new DiffStreamSource(originalFile == null || mode == FileInformation.Mode.INDEX_VS_WORKING_TREE ? this.baseFile : originalFile, this.baseFile, this.firstRevision, firstTitle);
        this.secondSource = new DiffStreamSource(this.baseFile, this.baseFile, this.secondRevision, secondTitle);
        this.title = "<html>" + info.annotateNameHtml(this.baseFile.getName());
    }

    Setup(File file, FileInformation.Mode mode, final boolean forceNonEditable) {
        this.baseFile = file;
        switch (mode) {
            case HEAD_VS_INDEX: {
                this.firstRevision = "HEAD";
                this.secondRevision = "INDEX";
                break;
            }
            case HEAD_VS_WORKING_TREE: {
                this.firstRevision = "HEAD";
                this.secondRevision = "CURRENT";
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.firstRevision = "INDEX";
                this.secondRevision = "CURRENT";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.firstSource = new DiffStreamSource(this.baseFile, this.baseFile, this.firstRevision, this.firstRevision);
        this.secondSource = new DiffStreamSource(this.baseFile, this.baseFile, this.secondRevision, this.secondRevision){

            @Override
            public boolean isEditable() {
                return !forceNonEditable && super.isEditable();
            }
        };
    }

    Setup(File file, Revision rev1, Revision rev2, GitFileNode.HistoryFileInformation fileInfo) {
        this.baseFile = file;
        this.firstRevision = rev1.getCommitId();
        this.secondRevision = rev2.getCommitId();
        StringBuilder sb = new StringBuilder(rev1.toString(true));
        File firstSourceBaseFile = this.baseFile;
        if (fileInfo != null && fileInfo.getOldPath() != null) {
            sb.append(" (").append(fileInfo.getOldPath()).append(")");
            firstSourceBaseFile = fileInfo.getOldFile();
        }
        this.firstSource = new DiffStreamSource(firstSourceBaseFile, this.baseFile, this.firstRevision, sb.toString());
        this.secondSource = new DiffStreamSource(this.baseFile, this.baseFile, this.secondRevision, rev2.toString(true));
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setView(DiffController view) {
        this.view = view;
    }

    public DiffController getView() {
        return this.view;
    }

    public StreamSource getFirstSource() {
        return this.firstSource;
    }

    public StreamSource getSecondSource() {
        return this.secondSource;
    }

    void setNode(DiffNode node) {
        assert (this.node == null);
        this.node = node;
    }

    DiffNode getNode() {
        return this.node;
    }

    public String toString() {
        return this.title;
    }

    void initSources() throws IOException {
        if (this.firstSource != null) {
            this.firstSource.init();
        }
        if (this.secondSource != null) {
            this.secondSource.init();
        }
    }
}

