/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import org.netbeans.api.server.properties.InstanceProperties;
import org.netbeans.api.server.properties.InstancePropertiesManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.OCISessionInitiator;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class OCIManager {
    private static final Logger LOG = Logger.getLogger(OCIManager.class.getName());
    public static final String PROP_ACTIVE_PROFILE = "activeProfile";
    public static final String PROP_CONNECTED_PROFILES = "connectedProfiles";
    private static final Map<OCIConfig, OCIProfile> profiles = new HashMap<OCIConfig, OCIProfile>();
    private Map<String, List<OCIProfile>> implicitProfiles = new HashMap<String, List<OCIProfile>>();
    private FileChangeListener defaultProfileListener;
    private static Path defaultConfigPath;
    private PropertyChangeSupport listeners;
    private static OCIManager INSTANCE;
    private OCIProfile activeProfile;
    private static final String KEY_CONFIG_PATH = "configPath";
    private static final String KEY_PROFILE_ID = "profile";

    static Path getDefaultConfigPath() {
        if (defaultConfigPath != null) {
            return defaultConfigPath;
        }
        String filename = System.getenv("OCI_CONFIG_FILE");
        if (filename == null) {
            filename = "~/.oci/config";
        }
        String replacedFile = filename.replace("~", new File(System.getProperty("user.home")).getAbsolutePath());
        try {
            try {
                defaultConfigPath = Paths.get(new URI("file://" + replacedFile));
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.WARNING, "Unable to parse default config path {0} as a file:// URI", replacedFile);
                defaultConfigPath = Paths.get(replacedFile, new String[0]);
            }
        }
        catch (IllegalArgumentException ex) {
            LOG.log(Level.WARNING, "Unable to parse default config path {0} even as a path", replacedFile);
            defaultConfigPath = Paths.get(System.getProperty("user.home"), ".oci", "config");
        }
        return defaultConfigPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            if (this.listeners == null) {
                this.listeners = new PropertyChangeSupport(this);
            }
            this.listeners.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.removePropertyChangeListener(listener);
        }
    }

    public boolean isValid() {
        return this.getActiveProfile().isValid();
    }

    public static synchronized OCIProfile forProfile(String profile) {
        return OCIManager.forConfig(null, profile);
    }

    public List<OCIProfile> listProfiles(Path configPath) throws IOException {
        Path p = configPath != null ? configPath : OCIManager.getDefaultConfigPath();
        return Files.readAllLines(p).stream().filter(s -> s.startsWith("[")).map(s -> {
            String n = s.substring(1).trim();
            if (n.endsWith("]")) {
                n = n.substring(0, n.length() - 1).trim();
            }
            return n;
        }).map(n -> OCIManager.forConfig(configPath, n)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OCIProfile forConfig(Path configPath, String profile) {
        OCIProfile prof;
        if (configPath == null) {
            configPath = OCIManager.getDefaultConfigPath();
        }
        if (profile == null) {
            profile = "DEFAULT";
        }
        OCIConfig c = new OCIConfig(configPath, profile);
        Map<OCIConfig, OCIProfile> map = profiles;
        synchronized (map) {
            prof = profiles.get(c);
            if (prof != null && prof.isValid()) {
                return prof;
            }
        }
        OCIProfile newProf = new OCIProfile(OCIManager.getDefaultConfigPath(), c.getProfile());
        Map<OCIConfig, OCIProfile> map2 = profiles;
        synchronized (map2) {
            if (prof == null) {
                OCIProfile check = profiles.putIfAbsent(c, newProf);
                OCIProfile oCIProfile = check != null ? check : newProf;
                return oCIProfile;
            }
            OCIProfile check = profiles.get(c);
            if (check == null || !check.isValid()) {
                profiles.put(c, newProf);
            }
            return newProf;
        }
    }

    private List<OCIProfile> list() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImplicitProfiles(String key, List<OCIProfile> profiles) {
        OCIProfile active;
        List<OCIProfile> current = this.getConnectedProfiles();
        boolean changes = false;
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            current = new ArrayList<OCIProfile>(this.implicitProfiles.getOrDefault(key, Collections.emptyList()));
            Iterator<OCIProfile> it = current.iterator();
            while (it.hasNext()) {
                OCIProfile p = it.next();
                if (p.isValid()) continue;
                it.remove();
                changes = true;
            }
            if (!(changes |= current.size() != profiles.size() || !current.containsAll(profiles))) {
                return;
            }
            current.addAll(profiles);
            this.implicitProfiles.put(key, profiles);
            active = this.activeProfile;
        }
        this.listeners.firePropertyChange(PROP_CONNECTED_PROFILES, null, null);
        oCIManager = this;
        synchronized (oCIManager) {
            if ((active != null || profiles.isEmpty()) && !current.contains(active)) {
                return;
            }
            this.activeProfile = null;
        }
        this.listeners.firePropertyChange(PROP_ACTIVE_PROFILE, null, null);
    }

    static boolean loadDefaultConfigProfiles() {
        return Boolean.valueOf(NbBundle.getMessage(OCIManager.class, (String)"OCIManager_Autoload_DefaultConfig"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<OCIProfile>> initImplicitProfiles() {
        if (!OCIManager.loadDefaultConfigProfiles()) {
            return this.implicitProfiles;
        }
        Path path = OCIManager.getDefaultConfigPath();
        final String s = path.toString();
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            if (this.implicitProfiles.get(s) != null) {
                return this.implicitProfiles;
            }
            try {
                this.implicitProfiles.put(s, this.listProfiles(null));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.defaultProfileListener = new FileChangeAdapter(){

                public void fileDeleted(FileEvent fe) {
                    this.refresh();
                }

                public void fileChanged(FileEvent fe) {
                    this.refresh();
                }

                public void fileDataCreated(FileEvent fe) {
                    this.refresh();
                }

                private void refresh() {
                    try {
                        OCIManager.this.setImplicitProfiles(s, OCIManager.this.listProfiles(null));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            FileUtil.addFileChangeListener((FileChangeListener)this.defaultProfileListener, (File)path.toFile());
        }
        return this.implicitProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectedProfile(OCIProfile profile) {
        if (profile.getTenantId() == null) {
            throw new IllegalArgumentException("Broken profiles are not supported.");
        }
        List<OCIProfile> current = this.getConnectedProfiles();
        if (current.contains(profile)) {
            return;
        }
        boolean fireActive = current.isEmpty();
        InstanceProperties p = InstancePropertiesManager.getInstance().createProperties("cloud.oracle.com.ociprofiles");
        if (!OCIManager.getDefaultConfigPath().equals(profile.getConfigPath())) {
            p.putString(KEY_CONFIG_PATH, profile.getConfigPath().toString());
        }
        p.putString(KEY_PROFILE_ID, profile.getId());
        this.listeners.firePropertyChange(PROP_CONNECTED_PROFILES, null, null);
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            if (this.activeProfile != null && this.activeProfile != profile) {
                return;
            }
        }
        this.listeners.firePropertyChange(PROP_ACTIVE_PROFILE, null, null);
    }

    public boolean isConfiguredProfile(OCIProfile profile) {
        return this.findProfileProperties(profile) != null;
    }

    private InstanceProperties findProfileProperties(OCIProfile profile) {
        List props = InstancePropertiesManager.getInstance().getProperties("cloud.oracle.com.ociprofiles");
        for (InstanceProperties p : props) {
            String cfgPath = p.getString(KEY_CONFIG_PATH, null);
            String profName = p.getString(KEY_PROFILE_ID, null);
            if (cfgPath == null) {
                cfgPath = OCIManager.getDefaultConfigPath().toString();
            }
            if (!profile.getConfigPath().toString().equals(cfgPath)) continue;
            if (profName == null) {
                profName = "DEFAULT";
            }
            if (!profName.equals(profile.getId())) continue;
            return p;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectedProfile(OCIProfile profile) {
        String profName = profile.getId();
        InstanceProperties p = this.findProfileProperties(profile);
        if (p == null) {
            return;
        }
        OCIProfile resetToProfile = null;
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            OCIConfig cfg = new OCIConfig(profile.getConfigPath(), "DEFAULT".equals(profile.getId()) ? null : profile.getId());
            if (profiles.remove(cfg) == null) {
                return;
            }
            if (profile == this.getActiveProfile()) {
                OCIProfile def = OCIManager.forConfig(defaultConfigPath, profName);
                resetToProfile = profiles.containsValue(def) || profiles.isEmpty() ? def : profiles.values().iterator().next();
            }
        }
        p.remove();
        if (resetToProfile != null) {
            this.setActiveProfile(resetToProfile);
        }
        this.listeners.firePropertyChange(PROP_CONNECTED_PROFILES, null, null);
    }

    public List<OCIProfile> getConnectedProfiles() {
        LinkedHashSet<OCIProfile> toReturn = new LinkedHashSet<OCIProfile>();
        Path defConfigPath = OCIManager.getDefaultConfigPath();
        List props = InstancePropertiesManager.getInstance().getProperties("cloud.oracle.com.ociprofiles");
        for (InstanceProperties p : props) {
            String cfgPath = p.getString(KEY_CONFIG_PATH, null);
            String profName = p.getString(KEY_PROFILE_ID, null);
            if ("DEFAULT".equals(profName)) {
                profName = null;
            }
            if (cfgPath != null) {
                try {
                    Path check = Paths.get(cfgPath, new String[0]);
                    if (defConfigPath.equals(check)) {
                        cfgPath = null;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            toReturn.add(OCIManager.forConfig(defConfigPath, profName));
        }
        this.initImplicitProfiles().values().stream().flatMap(l -> l.stream()).forEach(toReturn::add);
        return new ArrayList<OCIProfile>(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCIProfile getActiveProfile() {
        OCIProfile p = (OCIProfile)Lookup.getDefault().lookup(OCIProfile.class);
        if (p != null) {
            return p;
        }
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            OCIProfile active = this.activeProfile;
        }
        if (this.activeProfile == null) {
            Preferences prefs = NbPreferences.forModule(OCIManager.class);
            String confPath = prefs.get("activeProfilePath", null);
            String id = null;
            Path path = null;
            if (confPath != null) {
                try {
                    path = Paths.get(confPath, new String[0]);
                }
                catch (IllegalArgumentException ex) {
                    LOG.log(Level.WARNING, "Invalid active OCI profile path: {0}", confPath);
                }
            }
            id = prefs.get("activeProfileId", null);
            p = OCIManager.forConfig(path, id);
            OCIManager oCIManager2 = this;
            synchronized (oCIManager2) {
                if (this.activeProfile == null) {
                    this.activeProfile = p;
                } else {
                    p = this.activeProfile;
                }
            }
        }
        return this.activeProfile;
    }

    private String nonDefaultProfilePath(Path p) {
        if (OCIManager.getDefaultConfigPath().equals(p)) {
            return null;
        }
        return p.toString();
    }

    private String nonDefaultProfileId(String id) {
        return "DEFAULT".equals(id) ? null : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProfile(OCIProfile profile) {
        OCIProfile oldProfile;
        if (profile == null) {
            return;
        }
        OCIManager oCIManager = this;
        synchronized (oCIManager) {
            if (profile == null) {
                if (this.activeProfile == null) {
                    return;
                }
                profile = OCIManager.forProfile(null);
            }
            if (profile == this.activeProfile) {
                return;
            }
            oldProfile = this.activeProfile;
            this.activeProfile = profile;
            if (this.listeners == null) {
                return;
            }
        }
        if (oldProfile == null) {
            oldProfile = OCIManager.forProfile(null);
        }
        Preferences prefs = NbPreferences.forModule(OCIManager.class);
        if (OCIManager.getDefaultConfigPath().equals(profile.getConfigPath())) {
            prefs.remove("activeProfilePath");
        } else {
            prefs.put("activeProfilePath", profile.getConfigPath().toString());
        }
        if ("DEFAULT".equals(profile.getId())) {
            prefs.remove("activeProfileId");
        } else {
            prefs.put("activeProfileId", profile.getId());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.listeners.firePropertyChange(PROP_ACTIVE_PROFILE, oldProfile, profile);
    }

    public static synchronized OCIManager getDefault() {
        return INSTANCE;
    }

    public Optional<TenancyItem> getTenancy() {
        return this.getActiveProfile().getTenancy();
    }

    public OCISessionInitiator getActiveSession() {
        return this.getActiveProfile();
    }

    @Deprecated
    public ConfigFileAuthenticationDetailsProvider getConfigProvider() {
        return this.getActiveProfile().getConfigProvider();
    }

    public Optional<String> createAutonomousDatabase(String compartmentId, String dbName, char[] password) {
        return this.getActiveProfile().createAutonomousDatabase(compartmentId, dbName, password);
    }

    public Path downloadWallet(OCIItem dbInstance, String password, String parentPath) throws FileNotFoundException, IOException {
        return this.getActiveProfile().downloadWallet(dbInstance, password, parentPath);
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public static <V, E extends Exception> V usingSession(OCISessionInitiator p, OCIOperation<V, E> toExecute) throws E {
        ProxyLookup localDefLookup = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)p), Lookup.getDefault()});
        Object[] res = new Object[1];
        Exception[] t = new Exception[1];
        if (OCIManager.getDefault().getActiveSession() == p) {
            return toExecute.call();
        }
        Lookups.executeWith((Lookup)localDefLookup, () -> {
            try {
                res[0] = toExecute.call();
            }
            catch (Error | RuntimeException td) {
                throw td;
            }
            catch (Exception ex) {
                t[0] = ex;
            }
        });
        if (t[0] != null) {
            OCIManager.sneakyThrow(t[0]);
            return null;
        }
        return (V)res[0];
    }

    static {
        INSTANCE = new OCIManager();
    }

    public static final class OCIConfig {
        private final Path configPath;
        private final String profile;
        private long timestamp;

        public OCIConfig(Path configFile, String profile) {
            this.configPath = configFile;
            this.profile = profile;
        }

        public Path getConfigFile() {
            return this.configPath;
        }

        public String getProfile() {
            return this.profile;
        }

        public int hashCode() {
            int hash = 7;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OCIConfig other = (OCIConfig)obj;
            if (!Objects.equals(this.configPath, other.configPath)) {
                return false;
            }
            return Objects.equals(this.profile, other.profile);
        }
    }

    @FunctionalInterface
    public static interface OCIOperation<V, E extends Exception> {
        public V call() throws E;
    }
}

