/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.completion;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.jakarta.web.beans.completion.BeansCompletionItem;
import org.netbeans.modules.jakarta.web.beans.completion.BeansCompletionManager;
import org.netbeans.modules.jakarta.web.beans.completion.CCParser;
import org.netbeans.modules.jakarta.web.beans.completion.CompletionContext;
import org.netbeans.modules.jakarta.web.beans.completion.CompletionContextResolver;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class BeansCompletionProvider
implements CompletionProvider {
    private static final String EMPTY = "";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1 && queryType != 9) {
            return null;
        }
        return new AsyncCompletionTask((AsyncCompletionQuery)new BeansCompletionQuery(queryType, component, component.getSelectionStart(), true), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static int getRowFirstNonWhite(StyledDocument doc, int offset) throws BadLocationException {
        javax.swing.text.Element lineElement = doc.getParagraphElement(offset);
        int start = lineElement.getStartOffset();
        while (start + 1 < lineElement.getEndOffset()) {
            try {
                if (doc.getText(start, 1).charAt(0) != ' ') {
                    break;
                }
            }
            catch (BadLocationException ex) {
                throw (BadLocationException)new BadLocationException("calling getText(" + start + ", " + (start + 1) + ") on doc of length: " + doc.getLength(), start).initCause(ex);
            }
            ++start;
        }
        return start;
    }

    static int indexOfWhite(char[] line) {
        int i = line.length;
        while (--i > -1) {
            char c = line[i];
            if (!Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    static class BeansCompletionQuery
    extends AsyncCompletionQuery {
        private ArrayList<CompletionContextResolver> resolvers;
        private byte hasAdditionalItems = 0;
        private int anchorOffset;
        private int queryType;

        public BeansCompletionQuery(int queryType, JTextComponent component, int caretOffset, boolean hasTask) {
            this.queryType = queryType;
            this.initResolvers();
        }

        private void initResolvers() {
            this.resolvers = new ArrayList();
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            ArrayList<BeansCompletionItem> completionItems = new ArrayList<BeansCompletionItem>();
            int anchorOffset = this.getCompletionItems(doc, caretOffset, completionItems);
            resultSet.addAllItems(completionItems);
            if (anchorOffset != -1) {
                resultSet.setAnchorOffset(anchorOffset);
            }
            resultSet.finish();
        }

        int getCompletionItems(Document doc, int caretOffset, List<BeansCompletionItem> completionItems) {
            int anchorOffset = -1;
            CompletionContext context = new CompletionContext(doc, caretOffset);
            if (context.getCompletionType() == CompletionContext.CompletionType.NONE) {
                return anchorOffset;
            }
            switch (context.getCompletionType()) {
                case VALUE: {
                    anchorOffset = BeansCompletionManager.getDefault().completeValues(context, completionItems);
                }
            }
            return anchorOffset;
        }

        protected boolean canFilter(JTextComponent component) {
            return false;
        }

        protected void filter(CompletionResultSet resultSet) {
            try {
                resultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            resultSet.finish();
        }
    }

    public final class Context {
        private JTextComponent component;
        CompilationController controller;
        private int endOffset;
        private String completedMemberName;
        private String completedMemberJavaClassName;
        private CCParser CCParser;
        private CCParser.CC parsednn = null;
        private CCParser.MD methodName = null;

        public Context(JTextComponent component, CompilationController controller, int endOffset, boolean autoPopup) {
            this.component = component;
            this.controller = controller;
            this.endOffset = endOffset;
            FileObject documentFO = this.getFileObject();
            if (documentFO != null) {
                // empty if block
            }
            this.CCParser = new CCParser(controller);
        }

        public Element getJavaClass() {
            TreePath path = null;
            Element el = null;
            try {
                this.getController().toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            while ((el == null || ElementKind.CLASS != el.getKind() && ElementKind.INTERFACE != el.getKind()) && path != null) {
                path.getCompilationUnit().getTypeDecls();
                el = this.getController().getTrees().getElement(path);
                path = path.getParentPath();
            }
            return el;
        }

        public BaseDocument getBaseDocument() {
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            return doc;
        }

        public FileObject getFileObject() {
            try {
                return URLMapper.findFileObject((URL)this.getController().getCompilationUnit().getSourceFile().toUri().toURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        public int getCompletionOffset() {
            return this.endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CCParser.CC getParsedAnnotation() {
            CCParser cCParser = this.CCParser;
            synchronized (cCParser) {
                if (this.parsednn == null) {
                    this.parsednn = this.CCParser.parseAnnotation(this.getCompletionOffset());
                }
                return this.parsednn;
            }
        }

        public String getCompletedMemberClassName() {
            if (this.completedMemberJavaClassName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberJavaClassName;
        }

        public String getCompletedMemberName() {
            if (this.completedMemberName == null) {
                this.initCompletedMemberContext();
            }
            return this.completedMemberName;
        }

        private void initCompletedMemberContext() {
            Object type = null;
            Object genericType = null;
            Object propertyName = null;
            CCParser nnp = new CCParser(this.getController());
            TokenSequence ts = this.getController().getTokenHierarchy().tokenSequence(JavaTokenId.language());
            ts.move(this.getCompletionOffset() + 1);
            this.nextNonWhitespaceToken((TokenSequence<JavaTokenId>)ts);
            Token ti = ts.token();
            while (ti != null && propertyName == null) {
                CCParser.CC parsed;
                Element el = null;
                if (el != null && el.getKind() == ElementKind.ANNOTATION_TYPE && (parsed = nnp.parseAnnotation(ts.offset() + 1)) != null) {
                    ts.move(parsed.getEndOffset());
                    ti = ts.token();
                    continue;
                }
                if (genericType != null && ti.id() == JavaTokenId.LT) {
                    ts.moveNext();
                    Token ti2 = ts.token();
                    if (ti2.id() != JavaTokenId.IDENTIFIER) {
                        genericType = null;
                    }
                } else if (ti.id() == JavaTokenId.IDENTIFIER && type == null) {
                    genericType = type;
                }
                ts.moveNext();
                ti = ts.token();
            }
            this.completedMemberName = propertyName;
            this.completedMemberJavaClassName = genericType == null ? type : genericType;
        }

        private void initMethodContext() {
            TokenSequence ts = this.getController().getTokenHierarchy().tokenSequence(JavaTokenId.language());
            ts.move(this.getCompletionOffset());
            this.previousNonWhitespaceToken((TokenSequence<JavaTokenId>)ts);
            Token ti = ts.token();
            int lparpassed = 0;
            String mname = null;
            while (ti != null) {
                Element el = null;
                if (ti.id() == JavaTokenId.LPAREN) {
                    ++lparpassed;
                } else {
                    if (ti.id() == JavaTokenId.IDENTIFIER) break;
                    if (ti.id() == JavaTokenId.RPAREN) {
                        --lparpassed;
                    }
                }
                if (lparpassed > 0) {
                    if (el != null && el.getKind() == ElementKind.METHOD) {
                        mname = el.getSimpleName().toString();
                        break;
                    }
                    if (el == null || el.getKind() != ElementKind.CLASS || el.asType().getKind() != TypeKind.ERROR || el.asType().toString().indexOf(46) <= 0 || el.asType().toString().indexOf(46) >= el.asType().toString().length() - 1) break;
                    mname = el.getSimpleName().toString();
                    break;
                }
                if (!ts.movePrevious()) break;
                ti = ts.token();
            }
            if (mname != null) {
                Token literalToComplete = null;
                Token titk = ts.token();
                do {
                    JavaTokenId id;
                    if ((id = (JavaTokenId)titk.id()) == JavaTokenId.WHITESPACE || id == JavaTokenId.LINE_COMMENT || id == JavaTokenId.BLOCK_COMMENT || id == JavaTokenId.JAVADOC_COMMENT) {
                        if (!ts.moveNext()) break;
                        titk = ts.token();
                        continue;
                    }
                    int tokenOffset = titk.offset(this.getController().getTokenHierarchy());
                    if (tokenOffset > this.getCompletionOffset()) break;
                    if (id == JavaTokenId.STRING_LITERAL && tokenOffset + titk.length() > this.getCompletionOffset()) {
                        literalToComplete = titk;
                        break;
                    }
                    if (!ts.moveNext()) break;
                    titk = ts.token();
                } while (titk != null);
                this.methodName = new CCParser.MD(mname, literalToComplete != null ? literalToComplete.text().toString() : null, literalToComplete != null ? literalToComplete.offset(this.getController().getTokenHierarchy()) : this.getCompletionOffset(), true, true);
            }
        }

        private TokenSequence<JavaTokenId> nextNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
            block3: while (ts.moveNext()) {
                switch ((JavaTokenId)ts.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        continue block3;
                    }
                }
                return ts;
            }
            return null;
        }

        private TokenSequence<JavaTokenId> previousNonWhitespaceToken(TokenSequence<JavaTokenId> ts) {
            do {
                if (ts.token() == null) continue;
                switch ((JavaTokenId)ts.token().id()) {
                    case WHITESPACE: 
                    case LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case JAVADOC_COMMENT: {
                        break;
                    }
                    default: {
                        return ts;
                    }
                }
            } while (ts.movePrevious());
            return null;
        }

        public CompilationController getController() {
            return this.controller;
        }

        public CCParser.MD getMethod() {
            if (this.methodName == null) {
                this.initMethodContext();
            }
            return this.methodName;
        }
    }
}

