/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.DeclaredIBindingsAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.InterceptedBeanAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.ManagedBeansAnalizer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.NamedModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.ScopedBeanAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type.SessionBeanAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;

public class ClassModelAnalyzer
implements ModelAnalyzer {
    private static final List<ClassAnalyzer> ANALYZERS = new LinkedList<ClassAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        TypeElement subject = (TypeElement)element;
        for (ClassAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(subject, parent, model, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new ManagedBeansAnalizer());
        ANALYZERS.add(new ScopedBeanAnalyzer());
        ANALYZERS.add(new SessionBeanAnalyzer());
        ANALYZERS.add(new InterceptedBeanAnalyzer());
        ANALYZERS.add(new NamedModelAnalyzer());
        ANALYZERS.add(new DeclaredIBindingsAnalyzer());
    }

    public static interface ClassAnalyzer {
        public void analyze(TypeElement var1, TypeElement var2, WebBeansModel var3, AtomicBoolean var4, ModelAnalyzer.Result var5);
    }
}

