/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript2.editor.parser.JsonParserResult;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.types.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class JsonOccurrencesFinder
extends OccurrencesFinder<JsonParserResult> {
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private int caretPosition;
    private Map<OffsetRange, ColoringAttributes> range2Attribs;

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.range2Attribs;
    }

    public void run(JsonParserResult result, SchedulerEvent event) {
        this.range2Attribs = JsonOccurrencesFinder.calculateOccurences(result, this.caretPosition, true, this.cancelled);
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    @NonNull
    public static Set<OffsetRange> calculateOccurances(@NonNull ParserResult result, int caretPosition, boolean includeQuotes) {
        Map<OffsetRange, ColoringAttributes> occ = JsonOccurrencesFinder.calculateOccurences(result, caretPosition, includeQuotes, new AtomicBoolean());
        return occ == null ? Collections.emptySet() : occ.keySet();
    }

    @CheckForNull
    private static Map<OffsetRange, ColoringAttributes> calculateOccurences(@NonNull ParserResult result, int caretPosition, boolean includeQuotes, @NonNull AtomicBoolean cancelled) {
        if (cancelled.getAndSet(false)) {
            return null;
        }
        TokenHierarchy th = result.getSnapshot().getTokenHierarchy();
        if (th == null) {
            return null;
        }
        TokenSequence ts = th.tokenSequence(JsTokenId.jsonLanguage());
        if (ts == null) {
            return null;
        }
        int offset = result.getSnapshot().getEmbeddedOffset(caretPosition);
        int delta = ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        Model model = Model.getModel((org.netbeans.modules.csl.spi.ParserResult)result, (boolean)false);
        if (model == null) {
            return null;
        }
        Token token = ts.token();
        JsTokenId tokenId = (JsTokenId)token.id();
        if (tokenId != JsTokenId.STRING && delta == 0 && ts.movePrevious()) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
        }
        ts.movePrevious();
        Token prevToken = LexUtilities.findPreviousNonWsNonComment((TokenSequence)ts);
        JsTokenId prevTokenId = (JsTokenId)prevToken.id();
        HashSet<OffsetRange> ranges = new HashSet<OffsetRange>();
        if (tokenId == JsTokenId.STRING && (prevTokenId == JsTokenId.BRACKET_LEFT_CURLY || prevTokenId == JsTokenId.OPERATOR_COMMA)) {
            CharSequence text = token.text();
            JsonOccurrencesFinder.findRanges(model.getGlobalObject(), text.subSequence(1, text.length() - 1).toString(), includeQuotes, ranges);
        }
        HashMap<OffsetRange, ColoringAttributes> res = new HashMap<OffsetRange, ColoringAttributes>();
        if (cancelled.getAndSet(false)) {
            return null;
        }
        for (OffsetRange offsetRange : ranges) {
            res.put(ModelUtils.documentOffsetRange((ParserResult)result, (int)offsetRange.getStart(), (int)offsetRange.getEnd()), ColoringAttributes.MARK_OCCURRENCES);
        }
        return res;
    }

    private static void findRanges(JsObject object, String key, boolean includeQuotes, Set<OffsetRange> ranges) {
        for (Map.Entry entry : object.getProperties().entrySet()) {
            if (!((JsObject)entry.getValue()).isAnonymous() && key.equals(entry.getKey())) {
                ranges.add(new OffsetRange((includeQuotes ? 0 : 1) + ((JsObject)entry.getValue()).getOffset(), (includeQuotes ? 2 : 1) + ((JsObject)entry.getValue()).getOffset() + key.length()));
            }
            JsonOccurrencesFinder.findRanges((JsObject)entry.getValue(), key, includeQuotes, ranges);
        }
    }
}

