/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.status.AuthFailureStateListener;
import org.netbeans.modules.glassfish.common.status.MonitoringInitStateListener;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.GlassFishStatusListener;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServerStatus;
import org.netbeans.modules.glassfish.tooling.data.GlassFishVersion;
import org.openide.util.NbBundle;

public class GlassFishState {
    private static final Logger LOGGER = GlassFishLogger.get(GlassFishState.class);
    private static final int INIT_MONITORING_TIMEOUT = 5000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean monitor(GlassFishServer instance) {
        boolean added;
        GlassFishServerStatus status = GlassFishStatus.get((GlassFishServer)instance);
        if (status == null) {
            MonitoringInitStateListener listener = new MonitoringInitStateListener();
            added = GlassFishStatus.add((GlassFishServer)instance, (GlassFishStatusListener)listener, (boolean)false, (GlassFishStatus[])new GlassFishStatus[]{GlassFishStatus.OFFLINE, GlassFishStatus.STARTUP, GlassFishStatus.ONLINE, GlassFishStatus.SHUTDOWN});
            if (added) {
                if (instance.getVersion() != null) {
                    AuthFailureStateListener authListener = new AuthFailureStateListener(instance.getVersion().ordinal() >= GlassFishVersion.GF_4.ordinal());
                    GlassFishStatus.addChangeListener((GlassFishServer)instance, (GlassFishStatusListener)authListener, (GlassFishStatus[])new GlassFishStatus[]{GlassFishStatus.STARTUP});
                    GlassFishStatus.addErrorListener((GlassFishServer)instance, (GlassFishStatusListener)authListener);
                }
                try {
                    long startTime = System.currentTimeMillis();
                    long waitTime = 5000L;
                    MonitoringInitStateListener monitoringInitStateListener = listener;
                    synchronized (monitoringInitStateListener) {
                        while (!listener.isWakeUp() && waitTime > 0L) {
                            listener.wait(waitTime);
                            waitTime = 5000L + startTime - System.currentTimeMillis();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    LOGGER.log(Level.FINE, "Interrupted while waiting on server monitoring");
                }
                finally {
                    GlassFishStatus.removeListener((GlassFishServer)instance, (GlassFishStatusListener)listener);
                }
            }
        } else {
            added = false;
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForKnownState(GlassFishServer instance, MonitoringInitStateListener listener, long timeout) {
        try {
            long startTime = System.currentTimeMillis();
            long waitTime = timeout;
            MonitoringInitStateListener monitoringInitStateListener = listener;
            synchronized (monitoringInitStateListener) {
                while (!listener.isWakeUp() && waitTime > 0L) {
                    listener.wait(waitTime);
                    waitTime = timeout + startTime - System.currentTimeMillis();
                }
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.FINE, "Interrupted while waiting on server monitoring");
        }
        finally {
            GlassFishStatus.removeListener((GlassFishServer)instance, (GlassFishStatusListener)listener);
        }
    }

    public static GlassFishServerStatus getStatus(GlassFishServer instance, long timeout) {
        MonitoringInitStateListener listener = timeout > 0L ? new MonitoringInitStateListener() : null;
        GlassFishServerStatus status = GlassFishStatus.get((GlassFishServer)instance, (GlassFishStatusListener)listener);
        if (status == null) {
            GlassFishState.monitor(instance);
            status = GlassFishStatus.get((GlassFishServer)instance);
            if (status == null) {
                throw new IllegalStateException(NbBundle.getMessage(GlassFishState.class, (String)"GlassFishState.getStatus.statusNull"));
            }
        } else if (listener != null && listener.isActive()) {
            GlassFishState.waitForKnownState(instance, listener, timeout);
        }
        return status;
    }

    public static GlassFishServerStatus getStatus(GlassFishServer instance) {
        return GlassFishState.getStatus(instance, 0L);
    }

    public static boolean isOnline(GlassFishServer instance) {
        return GlassFishState.getStatus(instance).getStatus() == GlassFishStatus.ONLINE;
    }

    public static boolean isOffline(GlassFishServer instance) {
        return GlassFishState.getStatus(instance).getStatus() == GlassFishStatus.OFFLINE;
    }

    public static boolean canStart(GlassFishServer instance) {
        GlassFishServerStatus status = GlassFishState.getStatus(instance);
        switch (status.getStatus()) {
            case UNKNOWN: 
            case ONLINE: 
            case SHUTDOWN: 
            case STARTUP: {
                return false;
            }
        }
        return true;
    }

    public static enum Mode {
        DEFAULT,
        STARTUP,
        REFRESH;


        public String toString() {
            switch (this) {
                case DEFAULT: {
                    return "DEFAULT";
                }
                case STARTUP: {
                    return "STARTUP";
                }
                case REFRESH: {
                    return "REFRESH";
                }
            }
            throw new IllegalStateException("Unknown Mode value");
        }
    }
}

