/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tools.java.generator;

import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class GenerateSupportUtils {
    public static String getJavaName(String name) {
        StringTokenizer st = new StringTokenizer(name, " -.:");
        StringBuffer sb = new StringBuffer();
        if (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            while (st.hasMoreTokens()) {
                sb.append("_").append(st.nextToken());
            }
        }
        return sb.toString();
    }

    public static String getJavaFileHeader(String name, FileObject primFile) {
        Date now = new Date();
        StringBuffer sb = new StringBuffer();
        sb.append("/*\n * File:           ").append(name).append(".java");
        if (primFile != null) {
            sb.append("\n * Generated from: ").append(primFile.getName()).append(".").append(primFile.getExt());
        }
        sb.append("\n * Date:           ").append(DateFormat.getDateInstance(1).format(now));
        sb.append("  ").append(DateFormat.getTimeInstance(3).format(now));
        sb.append("\n *");
        sb.append("\n * @author  ").append(System.getProperty("user.name"));
        sb.append("\n * @version generated by NetBeans XML module");
        sb.append("\n */");
        return sb.toString();
    }

    public static boolean isValidReturnType(String value) {
        int length;
        if (value == null || "".equals(value)) {
            return false;
        }
        for (length = value.length(); length > 2 && value.charAt(length - 2) == '[' && value.charAt(length - 1) == ']'; length -= 2) {
            value = value.substring(0, length - 2);
        }
        if (value.charAt(0) == '.' || value.charAt(value.length() - 1) == '.') {
            return false;
        }
        for (int i = 1; i < length - 2; ++i) {
            if (value.charAt(i) != '.' || value.charAt(i + 1) != '.') continue;
            return false;
        }
        StringTokenizer st = new StringTokenizer(value, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (GenerateSupportUtils.isPrimitiveType(token) || Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrimitiveType(String value) {
        String[] val = new String[]{"int", "char", "boolean", "long", "float", "double", "void"};
        for (int i = 0; i < val.length; ++i) {
            if (!val[i].equals(value)) continue;
            return true;
        }
        return false;
    }
}

