/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.keymanagement.KmsVault;
import com.oracle.bmc.keymanagement.model.Vault;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class KmsVaultWaiters {
    private final ExecutorService executorService;
    private final KmsVault client;

    public KmsVaultWaiters(ExecutorService executorService, KmsVault client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetVaultRequest, GetVaultResponse> forVault(GetVaultRequest request, Vault.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVault(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVaultRequest, GetVaultResponse> forVault(GetVaultRequest request, Vault.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVault(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetVaultRequest, GetVaultResponse> forVault(GetVaultRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Vault.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVault(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetVaultRequest, GetVaultResponse> forVault(BmcGenericWaiter waiter, GetVaultRequest request, Vault.LifecycleState ... targetStates) {
        final HashSet<Vault.LifecycleState> targetStatesSet = new HashSet<Vault.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetVaultRequest, GetVaultResponse>(){

            @Override
            public GetVaultResponse apply(GetVaultRequest request) {
                return KmsVaultWaiters.this.client.getVault(request);
            }
        }, (Predicate)new Predicate<GetVaultResponse>(){

            @Override
            public boolean test(GetVaultResponse response) {
                return targetStatesSet.contains((Object)response.getVault().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Vault.LifecycleState.Deleted)), (Object)request);
    }
}

