/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.dcsctp;

import java.lang.ref.WeakReference;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.dcsctp4j.DcSctpSocketCallbacks;
import org.jitsi.dcsctp4j.Timeout;
import org.jitsi.videobridge.dcsctp.DcSctpTransport;
import org.jitsi.videobridge.util.TaskPools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001 B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jitsi/videobridge/dcsctp/DcSctpBaseCallbacks;", "Lorg/jitsi/dcsctp4j/DcSctpSocketCallbacks;", "transport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;Ljava/time/Clock;)V", "getTransport", "()Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "getClock", "()Ljava/time/Clock;", "createTimeout", "Lorg/jitsi/dcsctp4j/Timeout;", "p0", "Lorg/jitsi/dcsctp4j/DcSctpSocketCallbacks$DelayPrecision;", "Now", "Ljava/time/Instant;", "getRandomInt", "", "low", "high", "OnConnectionRestarted", "", "OnStreamsResetFailed", "outgoingStreams", "", "reason", "", "OnStreamsResetPerformed", "OnIncomingStreamsReset", "incomingStreams", "ATimeout", "jitsi-videobridge"})
public abstract class DcSctpBaseCallbacks
implements DcSctpSocketCallbacks {
    @NotNull
    private final DcSctpTransport transport;
    @NotNull
    private final Clock clock;

    public DcSctpBaseCallbacks(@NotNull DcSctpTransport transport, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.transport = transport;
        this.clock = clock;
    }

    public /* synthetic */ DcSctpBaseCallbacks(DcSctpTransport dcSctpTransport, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            clock = Clock.systemUTC();
        }
        this(dcSctpTransport, clock);
    }

    @NotNull
    public final DcSctpTransport getTransport() {
        return this.transport;
    }

    @NotNull
    public final Clock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public Timeout createTimeout(@NotNull DcSctpSocketCallbacks.DelayPrecision p0) {
        Intrinsics.checkNotNullParameter((Object)p0, "p0");
        return new ATimeout(this.transport);
    }

    @Override
    @NotNull
    public Instant Now() {
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant(...)");
        return instant;
    }

    @Override
    public long getRandomInt(long low, long high) {
        return ThreadLocalRandom.current().nextLong(low, high);
    }

    @Override
    public void OnConnectionRestarted() {
        this.transport.getLogger().info("Surprising SCTP callback: connection restarted");
    }

    @Override
    public void OnStreamsResetFailed(@NotNull short[] outgoingStreams, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(outgoingStreams, "outgoingStreams");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.transport.getLogger().info("Surprising SCTP callback: streams " + ArraysKt.joinToString$default(outgoingStreams, null, null, null, 0, null, null, 63, null) + " reset failed: " + reason);
    }

    @Override
    public void OnStreamsResetPerformed(@NotNull short[] outgoingStreams) {
        Intrinsics.checkNotNullParameter(outgoingStreams, "outgoingStreams");
        this.transport.getLogger().info("Outgoing streams " + ArraysKt.joinToString$default(outgoingStreams, null, null, null, 0, null, null, 63, null) + " reset");
    }

    @Override
    public void OnIncomingStreamsReset(@NotNull short[] incomingStreams) {
        Intrinsics.checkNotNullParameter(incomingStreams, "incomingStreams");
        this.transport.getLogger().info("Surprising SCTP callback: incoming streams " + ArraysKt.joinToString$default(incomingStreams, null, null, null, 0, null, null, 63, null) + " reset");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00030\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/dcsctp/DcSctpBaseCallbacks$ATimeout;", "Lorg/jitsi/dcsctp4j/Timeout;", "transport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "<init>", "(Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;)V", "weakTransport", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getTransport", "()Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "timeoutId", "", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "future", "Ljava/util/concurrent/Future;", "start", "", "duration", "stop", "jitsi-videobridge"})
    private static final class ATimeout
    implements Timeout {
        @NotNull
        private final WeakReference<DcSctpTransport> weakTransport;
        private long timeoutId;
        @Nullable
        private ScheduledFuture<?> scheduledFuture;
        @Nullable
        private Future<?> future;

        public ATimeout(@NotNull DcSctpTransport transport) {
            Intrinsics.checkNotNullParameter(transport, "transport");
            this.weakTransport = new WeakReference<DcSctpTransport>(transport);
        }

        private final DcSctpTransport getTransport() {
            return (DcSctpTransport)this.weakTransport.get();
        }

        @Override
        public void start(long duration, long timeoutId) {
            block2: {
                try {
                    this.timeoutId = timeoutId;
                    this.scheduledFuture = TaskPools.SCHEDULED_POOL.schedule(() -> ATimeout.start$lambda$1(this, timeoutId), duration, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e) {
                    Object object = this.getTransport();
                    if (object == null || (object = ((DcSctpTransport)object).getLogger()) == null) break block2;
                    object.warn("Exception scheduling DCSCTP timeout", e);
                }
            }
        }

        @Override
        public void stop() {
            ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
            Future<?> future = this.future;
            if (future != null) {
                future.cancel(false);
            }
            this.scheduledFuture = null;
            this.future = null;
        }

        private static final void start$lambda$1$lambda$0(ATimeout this$0, long $timeoutId) {
            block0: {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                Object object = this$0.getTransport();
                if (object == null || (object = ((DcSctpTransport)object).getSocket()) == null) break block0;
                object.handleTimeout($timeoutId);
            }
        }

        private static final void start$lambda$1(ATimeout this$0, long $timeoutId) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.future = TaskPools.IO_POOL.submit(() -> ATimeout.start$lambda$1$lambda$0(this$0, $timeoutId));
        }
    }
}

