/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.LossListener;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.nlj.util.Rfc3711IndexTracker;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacket;
import org.jitsi.rtp.rtcp.rtcpfb.transport_layer_fb.tcc.RtcpFbTccPacketBuilder;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.TccHeaderExtension;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020.H\u0014J\u000e\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020+J\u000e\u00101\u001a\u00020\u00052\u0006\u00100\u001a\u00020+J*\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00102\b\u00104\u001a\u0004\u0018\u00010\u00142\u0006\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010;\u001a\u000207H\u0002J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010=\u001a\u00020:H\u0002J\u0010\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\u001fH\u0002J\u0016\u0010@\u001a\u00020\u00052\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00050BH\u0016J\b\u0010C\u001a\u00020DH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010 \u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/TccGeneratorNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "onTccPacketReady", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "streamInformation", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lkotlin/jvm/functions/Function1;Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "logger", "tccExtensionId", "", "Ljava/lang/Integer;", "currTccSeqNum", "lastTccSentTime", "Ljava/time/Instant;", "lock", "", "packetArrivalTimes", "Ljava/util/TreeMap;", "windowStartSeq", "tccFeedbackBitrate", "Lorg/jitsi/nlj/util/BitrateTracker;", "numTccSent", "numMultipleTccPackets", "<set-?>", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "enabled$delegate", "Lkotlin/properties/ReadWriteProperty;", "rfc3711IndexTracker", "Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "lossListeners", "", "Lorg/jitsi/nlj/rtp/LossListener;", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "addLossListener", "listener", "removeLossListener", "addPacket", "tccSeqNum", "timestamp", "isMarked", "ssrc", "", "buildFeedback", "", "Lorg/jitsi/rtp/rtcp/rtcpfb/transport_layer_fb/tcc/RtcpFbTccPacket;", "mediaSsrc", "sendTcc", "tccPacket", "isTccReadyToSend", "currentPacketMarked", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nTccGeneratorNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TccGeneratorNode.kt\norg/jitsi/nlj/transform/node/incoming/TccGeneratorNode\n+ 2 Delegates.kt\norg/jitsi/utils/DelegatesKt\n+ 3 Delegates.kt\nkotlin/properties/Delegates\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,255:1\n28#2:256\n30#2:260\n33#3,3:257\n1863#4,2:261\n1863#4,2:263\n1863#4,2:265\n1863#4,2:267\n216#5,2:269\n63#6,4:271\n*S KotlinDebug\n*F\n+ 1 TccGeneratorNode.kt\norg/jitsi/nlj/transform/node/incoming/TccGeneratorNode\n*L\n69#1:256\n69#1:260\n69#1:257,3\n133#1:261,2\n145#1:263,2\n155#1:265,2\n168#1:267,2\n189#1:269,2\n222#1:271,4\n*E\n"})
public final class TccGeneratorNode
extends ObserverNode {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Function1<RtcpPacket, Unit> onTccPacketReady;
    @NotNull
    private final ReadOnlyStreamInformationStore streamInformation;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @Nullable
    private Integer tccExtensionId;
    private int currTccSeqNum;
    @NotNull
    private Instant lastTccSentTime;
    @NotNull
    private final Object lock;
    @NotNull
    private final TreeMap<Integer, Instant> packetArrivalTimes;
    private int windowStartSeq;
    @NotNull
    private final BitrateTracker tccFeedbackBitrate;
    private int numTccSent;
    private int numMultipleTccPackets;
    @NotNull
    private final ReadWriteProperty enabled$delegate;
    @NotNull
    private final Rfc3711IndexTracker rfc3711IndexTracker;
    @NotNull
    private final List<LossListener> lossListeners;

    public TccGeneratorNode(@NotNull Function1<? super RtcpPacket, Unit> onTccPacketReady, @NotNull ReadOnlyStreamInformationStore streamInformation, @NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(onTccPacketReady, "onTccPacketReady");
        Intrinsics.checkNotNullParameter(streamInformation, "streamInformation");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        super("TCC generator");
        this.onTccPacketReady = onTccPacketReady;
        this.streamInformation = streamInformation;
        this.clock = clock;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.lastTccSentTime = ClockUtils.NEVER;
        this.lock = new Object();
        this.packetArrivalTimes = new TreeMap();
        this.windowStartSeq = -1;
        this.tccFeedbackBitrate = new BitrateTracker(DurationKt.getSecs(1), DurationKt.getMs(10), null, 4, null);
        Boolean initialValue$iv = false;
        boolean $i$f$observableWhenChanged = false;
        Delegates this_$iv$iv = Delegates.INSTANCE;
        boolean $i$f$observable = false;
        this.enabled$delegate = new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ TccGeneratorNode this$0;
            {
                this.this$0 = tccGeneratorNode;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                void oldValue2;
                Intrinsics.checkNotNullParameter(property, "property");
                Object object = newValue;
                Object object2 = oldValue;
                KProperty property2 = property;
                boolean bl = false;
                if (!Intrinsics.areEqual(oldValue2, newValue2)) {
                    void newValue3;
                    boolean bl2 = (Boolean)newValue2;
                    ((Boolean)oldValue2).booleanValue();
                    boolean bl3 = false;
                    TccGeneratorNode.access$getLogger$p(this.this$0).debug("Setting enabled=" + (boolean)newValue3);
                }
            }
        };
        this.rfc3711IndexTracker = new Rfc3711IndexTracker();
        this.lossListeners = new ArrayList();
        this.streamInformation.onRtpExtensionMapping(RtpExtensionType.TRANSPORT_CC, arg_0 -> TccGeneratorNode._init_$lambda$2(this, arg_0));
        this.streamInformation.onRtpPayloadTypesChanged(arg_0 -> TccGeneratorNode._init_$lambda$3(this, arg_0));
    }

    public /* synthetic */ TccGeneratorNode(Function1 function1, ReadOnlyStreamInformationStore readOnlyStreamInformationStore, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            function1 = TccGeneratorNode::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            clock = Clock.systemDefaultZone();
        }
        this(function1, readOnlyStreamInformationStore, logger, clock);
    }

    private final boolean getEnabled() {
        return (Boolean)this.enabled$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setEnabled(boolean bl) {
        this.enabled$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        block2: {
            Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
            if (!this.getEnabled()) {
                return;
            }
            Integer n = this.tccExtensionId;
            if (n == null) break block2;
            int tccExtId = ((Number)n).intValue();
            boolean bl = false;
            RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
            RtpPacket.HeaderExtension headerExtension = rtpPacket.getHeaderExtension(tccExtId);
            if (headerExtension != null) {
                RtpPacket.HeaderExtension ext = headerExtension;
                boolean bl2 = false;
                int tccSeqNum = this.rfc3711IndexTracker.update(TccHeaderExtension.Companion.getSequenceNumber(ext));
                this.addPacket(tccSeqNum, packetInfo.getReceivedTime(), rtpPacket.isMarked(), rtpPacket.getSsrc());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.lossListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void removeLossListener(@NotNull LossListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.lossListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addPacket(int tccSeqNum, Instant timestamp, boolean isMarked, long ssrc) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.packetArrivalTimes.ceilingKey(this.windowStartSeq) == null) {
                this.packetArrivalTimes.clear();
            }
            Instant instant = timestamp;
            if (instant != null) {
                Instant $this$addPacket_u24lambda_u2413_u24lambda_u2411 = instant;
                boolean bl2 = false;
                if (this.packetArrivalTimes.isEmpty() && this.windowStartSeq == -1) {
                    Iterable $this$forEach$iv = this.lossListeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        LossListener it = (LossListener)element$iv;
                        boolean bl3 = false;
                        it.packetReceived(false);
                    }
                } else {
                    Integer oldMax;
                    Integer n = oldMax = !((Map)this.packetArrivalTimes).isEmpty() ? this.packetArrivalTimes.lastKey() : Integer.valueOf(this.windowStartSeq - 1);
                    if (tccSeqNum > oldMax) {
                        Intrinsics.checkNotNull(oldMax);
                        int numLost = tccSeqNum - oldMax - 1;
                        Iterable $this$forEach$iv = this.lossListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            LossListener it = (LossListener)element$iv;
                            boolean bl4 = false;
                            if (numLost > 0) {
                                it.packetLost(numLost);
                            }
                            it.packetReceived(false);
                        }
                    } else if (tccSeqNum < this.windowStartSeq || !this.packetArrivalTimes.containsKey(tccSeqNum)) {
                        Iterable $this$forEach$iv = this.lossListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            LossListener it = (LossListener)element$iv;
                            boolean bl5 = false;
                            it.packetReceived(true);
                        }
                    }
                }
                if (this.windowStartSeq == -1 || tccSeqNum < this.windowStartSeq) {
                    this.windowStartSeq = tccSeqNum;
                }
                this.packetArrivalTimes.putIfAbsent(tccSeqNum, timestamp);
            }
            if (this.isTccReadyToSend(isMarked)) {
                Iterable $this$forEach$iv = this.buildFeedback(ssrc);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RtcpFbTccPacket it = (RtcpFbTccPacket)element$iv;
                    boolean bl6 = false;
                    this.sendTcc(it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<RtcpFbTccPacket> buildFeedback(long mediaSsrc) {
        Object object = this.lock;
        synchronized (object) {
            Map.Entry<Integer, Instant> entry;
            block7: {
                boolean bl = false;
                if (this.packetArrivalTimes.ceilingEntry(this.windowStartSeq) != null) break block7;
                List<RtcpFbTccPacket> list = CollectionsKt.emptyList();
                return list;
            }
            Map.Entry<Integer, Instant> firstEntry = entry;
            List tccPackets = new ArrayList();
            Ref.ObjectRef currentTccPacket = new Ref.ObjectRef();
            int n = this.currTccSeqNum;
            this.currTccSeqNum = n + 1;
            currentTccPacket.element = new RtcpFbTccPacketBuilder(null, mediaSsrc, n, 1, null);
            RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder = (RtcpFbTccPacketBuilder)currentTccPacket.element;
            Instant instant = firstEntry.getValue();
            Intrinsics.checkNotNullExpressionValue(instant, "<get-value>(...)");
            rtcpFbTccPacketBuilder.SetBase(this.windowStartSeq, ClockUtils.toEpochMicro(instant));
            int nextSequenceNumber = 0;
            nextSequenceNumber = this.windowStartSeq;
            SortedMap<Integer, Instant> feedbackBlockPackets = this.packetArrivalTimes.tailMap(this.windowStartSeq);
            Intrinsics.checkNotNull(feedbackBlockPackets);
            Map $this$forEach$iv = feedbackBlockPackets;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry2 = element$iv = iterator2.next();
                boolean bl = false;
                Integer seq = (Integer)entry2.getKey();
                Instant timestamp = (Instant)entry2.getValue();
                Intrinsics.checkNotNull(timestamp);
                long timestampUs = ClockUtils.toEpochMicro(timestamp);
                RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder2 = (RtcpFbTccPacketBuilder)currentTccPacket.element;
                Intrinsics.checkNotNull(seq);
                if (!rtcpFbTccPacketBuilder2.AddReceivedPacket(seq, timestampUs)) {
                    void $this$buildFeedback_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
                    RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder3;
                    tccPackets.add(((RtcpFbTccPacketBuilder)currentTccPacket.element).build());
                    int n2 = this.currTccSeqNum;
                    this.currTccSeqNum = n2 + 1;
                    RtcpFbTccPacketBuilder rtcpFbTccPacketBuilder4 = rtcpFbTccPacketBuilder3 = new RtcpFbTccPacketBuilder(null, mediaSsrc, n2, 1, null);
                    Ref.ObjectRef objectRef = currentTccPacket;
                    boolean bl2 = false;
                    $this$buildFeedback_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.SetBase(seq, timestampUs);
                    $this$buildFeedback_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.AddReceivedPacket(seq, timestampUs);
                    objectRef.element = rtcpFbTccPacketBuilder3;
                }
                nextSequenceNumber = seq + 1;
            }
            tccPackets.add(((RtcpFbTccPacketBuilder)currentTccPacket.element).build());
            if (tccPackets.size() > 1) {
                int n3 = this.numMultipleTccPackets;
                this.numMultipleTccPackets = n3 + 1;
                this.logger.info("Sending TCC feedback in " + tccPackets.size() + " packets (" + feedbackBlockPackets.size() + " media packets)");
            }
            this.windowStartSeq = nextSequenceNumber;
            List list = tccPackets;
            return list;
        }
    }

    private final void sendTcc(RtcpFbTccPacket tccPacket) {
        this.onTccPacketReady.invoke(tccPacket);
        Logger $this$cdebug$iv = this.logger;
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug("sent TCC packet with seq num " + tccPacket.getFeedbackSeqNum());
        }
        int n = this.numTccSent;
        this.numTccSent = n + 1;
        this.lastTccSentTime = this.clock.instant();
        this.tccFeedbackBitrate.update(DataSizeKt.getBytes(tccPacket.length), this.clock.millis());
    }

    private final boolean isTccReadyToSend(boolean currentPacketMarked) {
        Instant now = this.clock.instant();
        if (Intrinsics.areEqual(this.lastTccSentTime, ClockUtils.NEVER)) {
            this.lastTccSentTime = now;
            return false;
        }
        Duration timeSinceLastTcc = Duration.between(this.lastTccSentTime, now);
        return timeSinceLastTcc.compareTo(DurationKt.getMs(100)) >= 0 || timeSinceLastTcc.compareTo(DurationKt.getMs(20)) >= 0 && currentPacketMarked;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2418 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2418.addNumber("num_tcc_packets_sent", this.numTccSent);
        $this$getNodeStats_u24lambda_u2418.addNumber("tcc_feedback_bitrate_bps", this.tccFeedbackBitrate.getRate-rlWvAKk());
        $this$getNodeStats_u24lambda_u2418.addString("tcc_extension_id", String.valueOf(this.tccExtensionId));
        $this$getNodeStats_u24lambda_u2418.addNumber("num_multiple_tcc_packets", this.numMultipleTccPackets);
        $this$getNodeStats_u24lambda_u2418.addBoolean("enabled", this.getEnabled());
        return nodeStatsBlock;
    }

    private static final Unit _init_$lambda$0(RtcpPacket it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TccGeneratorNode this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.tccExtensionId = it;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(TccGeneratorNode this$0, Map it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.setEnabled(this$0.streamInformation.getSupportsTcc());
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TccGeneratorNode $this) {
        return $this.logger;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(TccGeneratorNode.class, "enabled", "getEnabled()Z", 0))};
        $$delegatedProperties = kPropertyArray;
    }
}

