/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.conf;

import java.util.List;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.ldap.conf.DefaultLDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.EncryptionMethod;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPGuacamoleProperties;
import org.apache.guacamole.auth.ldap.conf.MemberAttributeType;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.GuacamoleProperty;

public class EnvironmentLDAPConfiguration
implements LDAPConfiguration {
    private final Environment environment;
    private static final LDAPConfiguration DEFAULT = new DefaultLDAPConfiguration();

    public EnvironmentLDAPConfiguration(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String appliesTo(String username) throws GuacamoleException {
        return username;
    }

    @Override
    public String getServerHostname() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_HOSTNAME, (Object)DEFAULT.getServerHostname());
    }

    @Override
    public int getServerPort() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_PORT, (Object)this.getEncryptionMethod().DEFAULT_PORT);
    }

    @Override
    public List<String> getUsernameAttributes() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USERNAME_ATTRIBUTE, DEFAULT.getUsernameAttributes());
    }

    @Override
    public Dn getUserBaseDN() throws GuacamoleException {
        return (Dn)this.environment.getRequiredProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USER_BASE_DN);
    }

    @Override
    public Dn getConfigurationBaseDN() throws GuacamoleException {
        return (Dn)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_CONFIG_BASE_DN, (Object)DEFAULT.getConfigurationBaseDN());
    }

    @Override
    public List<String> getGroupNameAttributes() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_GROUP_NAME_ATTRIBUTE, DEFAULT.getGroupNameAttributes());
    }

    @Override
    public Dn getGroupBaseDN() throws GuacamoleException {
        return (Dn)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_GROUP_BASE_DN, (Object)DEFAULT.getGroupBaseDN());
    }

    @Override
    public String getSearchBindDN() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_SEARCH_BIND_DN, (Object)DEFAULT.getSearchBindDN());
    }

    @Override
    public String getSearchBindPassword() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_SEARCH_BIND_PASSWORD, (Object)DEFAULT.getSearchBindPassword());
    }

    @Override
    public EncryptionMethod getEncryptionMethod() throws GuacamoleException {
        return (EncryptionMethod)((Object)this.environment.getProperty(LDAPGuacamoleProperties.LDAP_ENCRYPTION_METHOD, (Object)DEFAULT.getEncryptionMethod()));
    }

    @Override
    public int getMaxResults() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MAX_SEARCH_RESULTS, (Object)DEFAULT.getMaxResults());
    }

    @Override
    public AliasDerefMode getDereferenceAliases() throws GuacamoleException {
        return (AliasDerefMode)this.environment.getProperty(LDAPGuacamoleProperties.LDAP_DEREFERENCE_ALIASES, (Object)DEFAULT.getDereferenceAliases());
    }

    @Override
    public boolean getFollowReferrals() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_FOLLOW_REFERRALS, (Object)DEFAULT.getFollowReferrals());
    }

    @Override
    public int getMaxReferralHops() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MAX_REFERRAL_HOPS, (Object)DEFAULT.getMaxReferralHops());
    }

    @Override
    public ExprNode getUserSearchFilter() throws GuacamoleException {
        return (ExprNode)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USER_SEARCH_FILTER, (Object)DEFAULT.getUserSearchFilter());
    }

    @Override
    public ExprNode getGroupSearchFilter() throws GuacamoleException {
        return (ExprNode)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_GROUP_SEARCH_FILTER, (Object)DEFAULT.getGroupSearchFilter());
    }

    @Override
    public int getOperationTimeout() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_OPERATION_TIMEOUT, (Object)DEFAULT.getOperationTimeout());
    }

    @Override
    public int getNetworkTimeout() throws GuacamoleException {
        return (Integer)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_NETWORK_TIMEOUT, (Object)DEFAULT.getNetworkTimeout());
    }

    @Override
    public List<String> getAttributes() throws GuacamoleException {
        return (List)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_USER_ATTRIBUTES, DEFAULT.getAttributes());
    }

    @Override
    public String getMemberAttribute() throws GuacamoleException {
        return (String)this.environment.getProperty((GuacamoleProperty)LDAPGuacamoleProperties.LDAP_MEMBER_ATTRIBUTE, (Object)DEFAULT.getMemberAttribute());
    }

    @Override
    public MemberAttributeType getMemberAttributeType() throws GuacamoleException {
        return (MemberAttributeType)((Object)this.environment.getProperty(LDAPGuacamoleProperties.LDAP_MEMBER_ATTRIBUTE_TYPE, (Object)DEFAULT.getMemberAttributeType()));
    }
}

