/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTouchAction
extends org.w3c.css.properties.css.CssTouchAction {
    public static final CssIdent[] allowed_vertical_values;
    public static final CssIdent[] allowed_horizontal_values;
    public static final CssIdent[] allowed_values;
    public static final CssIdent pinch_zoom;

    public static CssIdent getAllowedHorizontalIdent(CssIdent ident) {
        for (CssIdent id : allowed_horizontal_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getAllowedVerticalIdent(CssIdent ident) {
        for (CssIdent id : allowed_vertical_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssTouchAction() {
        this.value = initial;
    }

    public CssTouchAction(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        boolean got_vertical = false;
        boolean got_horizontal = false;
        boolean got_pinch_zoom = false;
        this.setByUser();
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.valueOf(op), this.getPropertyName(), ac);
            }
            if (val.getType() != 0) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
            CssIdent id = val.getIdent();
            if (CssIdent.isCssWide(id)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
                expression.next();
                continue;
            }
            CssIdent ident = CssTouchAction.getAllowedIdent(id);
            if (ident != null) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                values.add(val);
                expression.next();
                continue;
            }
            ident = CssTouchAction.getAllowedHorizontalIdent(id);
            if (ident != null) {
                if (got_horizontal) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                got_horizontal = true;
                values.add(val);
                expression.next();
                continue;
            }
            ident = CssTouchAction.getAllowedVerticalIdent(id);
            if (ident != null) {
                if (got_vertical) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                got_vertical = true;
                values.add(val);
                expression.next();
                continue;
            }
            if (pinch_zoom.equals(id)) {
                if (got_pinch_zoom) {
                    throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
                }
                got_pinch_zoom = true;
                values.add(val);
                expression.next();
                continue;
            }
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssValueList(values);
    }

    public CssTouchAction(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _allowed_vertical_values = new String[]{"pan-x", "pan-left", "pan-right"};
        allowed_vertical_values = new CssIdent[_allowed_vertical_values.length];
        int i = 0;
        for (String s : _allowed_vertical_values) {
            CssTouchAction.allowed_vertical_values[i++] = CssIdent.getIdent(s);
        }
        String[] _allowed_horizontal_values = new String[]{"pan-y", "pan-up", "pan-down"};
        allowed_horizontal_values = new CssIdent[_allowed_horizontal_values.length];
        i = 0;
        for (String s : _allowed_horizontal_values) {
            CssTouchAction.allowed_horizontal_values[i++] = CssIdent.getIdent(s);
        }
        String[] _allowed_values = new String[]{"auto", "none", "manipulation"};
        allowed_values = new CssIdent[_allowed_values.length];
        i = 0;
        for (String s : _allowed_values) {
            CssTouchAction.allowed_values[i++] = CssIdent.getIdent(s);
        }
        pinch_zoom = CssIdent.getIdent("pinch-zoom");
    }
}

