/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.editor.markup.ExtendedBackendProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.FrontendHighlighterExtensionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u0000 92\u00020\u0001:\u00019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001cH\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0016J\u0016\u0010'\u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0016J\u001c\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020!0*2\u0006\u0010+\u001a\u00020,H\u0002J'\u0010-\u001a\u0004\u0018\u0001H.\"\b\b\u0000\u0010.*\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0016\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u000bH\u0016J\u0018\u00107\u001a\u00020!2\u0006\u00106\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u001fH\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "rdMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "(Lcom/jetbrains/rd/ide/model/RdMarkupModel;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;)V", "allHighlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getAllHighlighters", "()[Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "daemonModel", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "getDaemonModel", "()Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "listeners", "", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "addHighlighter", "element", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "addListener", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "listener", "bulkAddHighlighters", "elements", "bulkRemoveHighlighters", "highlighters", "changeAttributeAction", "Lkotlin/Function1;", "newModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "getExtension", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "getHighlighters", "offset", "", "removeHighlighter", "highlighter", "updateHighlighter", "newElement", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupAdapterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n53#2,4:131\n53#2,4:135\n53#2,4:139\n53#2,4:144\n11#2:169\n1#3:143\n1#3:164\n1549#4:148\n1620#4,3:149\n288#4,2:152\n11383#5,9:154\n13309#5:163\n13310#5:165\n11392#5:166\n37#6,2:167\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n*L\n37#1:131,4\n41#1:135,4\n58#1:139,4\n91#1:144,4\n30#1:169\n124#1:164\n104#1:148\n104#1:149,3\n120#1:152,2\n124#1:154,9\n124#1:163\n124#1:165\n124#1:166\n124#1:167,2\n*E\n"})
public class FrontendMarkupAdapterImpl
implements FrontendMarkupAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkupModelEx ideaMarkup;
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final List<FrontendMarkupAdapterListener> listeners;
    @NotNull
    private final List<MarkupModelExtension> extensions;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDaemonModel daemonModel;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupAdapterImpl(@NotNull RdMarkupModel rdMarkupModel, @NotNull MarkupModelEx ideaMarkup, @NotNull CompoundHighlighterModelsHandler compoundHandler) {
        Intrinsics.checkNotNullParameter((Object)rdMarkupModel, (String)"rdMarkupModel");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        this.ideaMarkup = ideaMarkup;
        this.compoundHandler = compoundHandler;
        this.listeners = new ArrayList();
        this.extensions = rdMarkupModel.getExtensions();
        Document document = this.ideaMarkup.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        this.daemonModel = rdMarkupModel.getDaemon();
    }

    @Override
    public void updateHighlighter(@NotNull RangeHighlighterEx highlighter2, @NotNull HighlighterElement newElement) {
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        if (!highlighter2.isValid()) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skipping update of invalid highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
            }
            return;
        }
        HighlighterModel newModel = newElement.getHighlighter();
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Updating highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
        }
        this.ideaMarkup.changeAttributesInBatch(highlighter2, arg_0 -> FrontendMarkupAdapterImpl.updateHighlighter$lambda$2(this.changeAttributeAction(newModel), arg_0));
        FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> FrontendMarkupAdapterImpl.updateHighlighter$lambda$3((Function1)new Function1<FrontendHighlighterExtensionHandler, Unit>(highlighter2, newModel, newElement){
            final /* synthetic */ RangeHighlighterEx $highlighter;
            final /* synthetic */ HighlighterModel $newModel;
            final /* synthetic */ HighlighterElement $newElement;
            {
                this.$highlighter = $highlighter;
                this.$newModel = $newModel;
                this.$newElement = $newElement;
                super(1);
            }

            public final void invoke(@NotNull FrontendHighlighterExtensionHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.processExtension(this.$highlighter, this.$newModel, this.$newElement.getExtensions());
            }
        }, arg_0));
        for (FrontendMarkupAdapterListener listener2 : this.listeners) {
            listener2.afterUpdated(highlighter2);
        }
    }

    @Override
    @NotNull
    public RangeHighlighterEx addHighlighter(@NotNull HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        HighlighterModel model = element.getHighlighter();
        int start = model.getStart();
        int end = model.getEnd();
        int layer = model.getLayer();
        HighlighterTargetArea targetArea = HighlightersUtilKt.toIdeaTargetArea(model);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Registering new highlighter '" + model.getProperties().getAttributeId() + "', model: " + HighlightersUtilKt.prettyPrint(model));
        }
        RangeHighlighterEx rangeHighlighterEx = this.ideaMarkup.addRangeHighlighterAndChangeAttributes(null, start, end, layer, targetArea, false, arg_0 -> FrontendMarkupAdapterImpl.addHighlighter$lambda$5(this.changeAttributeAction(model), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighterEx rangeHighlighter = rangeHighlighterEx;
        FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> FrontendMarkupAdapterImpl.addHighlighter$lambda$6((Function1)new Function1<FrontendHighlighterExtensionHandler, Unit>(rangeHighlighter, model, element){
            final /* synthetic */ RangeHighlighterEx $rangeHighlighter;
            final /* synthetic */ HighlighterModel $model;
            final /* synthetic */ HighlighterElement $element;
            {
                this.$rangeHighlighter = $rangeHighlighter;
                this.$model = $model;
                this.$element = $element;
                super(1);
            }

            public final void invoke(@NotNull FrontendHighlighterExtensionHandler it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.processExtension(this.$rangeHighlighter, this.$model, this.$element.getExtensions());
            }
        }, arg_0));
        return rangeHighlighter;
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> getHighlighters(int offset) {
        List result2 = new ArrayList();
        this.ideaMarkup.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> FrontendMarkupAdapterImpl.getHighlighters$lambda$7((Function1)new Function1<RangeHighlighterEx, Boolean>((List<RangeHighlighterEx>)result2){
            final /* synthetic */ List<RangeHighlighterEx> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx it) {
                Intrinsics.checkNotNull((Object)it);
                if (HighlightersUtilKt.isFromBackend((RangeHighlighter)it)) {
                    this.$result.add(it);
                }
                return true;
            }
        }, arg_0));
        return result2;
    }

    private final Function1<RangeHighlighterEx, Unit> changeAttributeAction(HighlighterModel newModel) {
        return (Function1)new Function1<RangeHighlighterEx, Unit>(newModel, this){
            final /* synthetic */ HighlighterModel $newModel;
            final /* synthetic */ FrontendMarkupAdapterImpl this$0;
            {
                this.$newModel = $newModel;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RangeHighlighterEx highlighter2) {
                Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
                highlighter2.setGreedyToLeft(this.$newModel.isGreedyToLeft());
                highlighter2.setGreedyToRight(this.$newModel.isGreedyToRight());
                highlighter2.setThinErrorStripeMark(this.$newModel.isThinErrorStripeMark());
                highlighter2.setVisibleIfFolded(this.$newModel.getProperties().isVisibleIfFolded());
                IProtocolHighlighterModelHandler handler2 = FrontendMarkupAdapterImpl.access$getCompoundHandler$p(this.this$0).getHandler(this.$newModel);
                handler2.initialize(this.$newModel, (RangeHighlighter)highlighter2);
                UtilKt.setExtendedBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter2), (ExtendedBackendProperties)new ExtendedBackendProperties(this.$newModel.getProperties(), this.$newModel.getId(), (Object)handler2));
            }
        };
    }

    @Override
    public void removeHighlighter(@NotNull RangeHighlighterEx highlighter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
        boolean bl2 = bl = HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)highlighter2) != null;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$22 = false;
            String $i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$22 = "Removing highlighter hasn't been registered by markup adapter";
            throw new AssertionError((Object)$i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$22);
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl3 = false;
            logger.trace("Removed highlighter from markup: " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter2));
        }
        Object object = UtilKt.getHandler((RangeHighlighter)((RangeHighlighter)highlighter2));
        IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler = object instanceof IProtocolHighlighterModelHandler ? (IProtocolHighlighterModelHandler)object : null;
        if (iProtocolHighlighterModelHandler != null) {
            iProtocolHighlighterModelHandler.deinitialize((RangeHighlighter)highlighter2);
        }
        this.ideaMarkup.removeHighlighter((RangeHighlighter)highlighter2);
    }

    @Override
    public void bulkRemoveHighlighters(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        for (FrontendMarkupAdapterListener frontendMarkupAdapterListener : this.listeners) {
            frontendMarkupAdapterListener.beforeBulkRemove(highlighters);
        }
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            this.removeHighlighter(rangeHighlighterEx);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RangeHighlighterEx> bulkAddHighlighters(@NotNull List<HighlighterElement> elements) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$map$iv = elements;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HighlighterElement highlighterElement = (HighlighterElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.addHighlighter((HighlighterElement)it));
        }
        List added = (List)destination$iv$iv;
        for (FrontendMarkupAdapterListener listener2 : this.listeners) {
            listener2.afterBulkAdd(added);
        }
        return added;
    }

    @Override
    public void addListener(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        CollectionExKt.addUnique((Collection)this.listeners, (Lifetime)lifetime, (Object)listener2);
        String string = Reflection.getOrCreateKotlinClass(FrontendMarkupAdapterListener.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)string);
        this.ideaMarkup.addMarkupModelListener(disposable, (MarkupModelListener)listener2);
    }

    @Override
    @Nullable
    public <T extends MarkupModelExtension> T getExtension(@NotNull Key<T> key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Iterable $this$firstOrNull$iv = this.extensions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MarkupModelExtension it = (MarkupModelExtension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key.toString())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return (T)(var2_8 instanceof MarkupModelExtension ? (MarkupModelExtension)var2_8 : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RangeHighlighterEx[] getAllHighlighters() {
        void $this$mapNotNullTo$iv$iv;
        RangeHighlighter[] rangeHighlighterArray = this.ideaMarkup.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$mapNotNull$iv = rangeHighlighterArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            RangeHighlighterEx it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((HighlightersUtilKt.isFromBackend(it) ? (it instanceof RangeHighlighterEx ? (RangeHighlighterEx)it : null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RangeHighlighterEx[0]);
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDaemonModel getDaemonModel() {
        return this.daemonModel;
    }

    private static final void updateHighlighter$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void updateHighlighter$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addHighlighter$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addHighlighter$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean getHighlighters$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CompoundHighlighterModelsHandler access$getCompoundHandler$p(FrontendMarkupAdapterImpl $this) {
        return $this.compoundHandler;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupAdapterImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupAdapterImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

