/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.SnapshotOpener;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProfilerHandlerUtils {
    public static final Logger LOG = Logger.getInstance(ProfilerHandlerUtils.class);
    private static final NotificationGroup GROUP = NotificationGroupManager.getInstance().getNotificationGroup("PerformancePlugin");

    public static void notify(@Nullable Project project, File snapshot) {
        Notification notification = GROUP.createNotification(PerformanceTestingBundle.message("profiling.capture.snapshot.success", snapshot.getName()), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PerformanceTestingBundle.message("profiling.capture.snapshot.action.showInFolder", RevealFileAction.getFileManagerName()), () -> RevealFileAction.openFile((File)snapshot)));
        SnapshotOpener opener = SnapshotOpener.findSnapshotOpener(snapshot);
        if (opener != null && project != null) {
            notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PerformanceTestingBundle.message("profiling.capture.snapshot.action.open", new Object[0]), () -> opener.open(snapshot, project)));
        }
        notification.notify(project);
    }

    public static void notifyCapturingError(@NotNull Throwable t, @Nullable Project project) {
        if (t == null) {
            ProfilerHandlerUtils.$$$reportNull$$$0(0);
        }
        LOG.warn(t);
        String text2 = PerformanceTestingBundle.message("profiling.capture.snapshot.error", t.getMessage());
        GROUP.createNotification(text2, NotificationType.ERROR).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/jetbrains/performancePlugin/profilers/ProfilerHandlerUtils", "notifyCapturingError"));
    }
}

