/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.lang.Language;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.SuggestingUtils;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.BreakpointAddedAction;
import training.featuresSuggester.actions.BreakpointRemovedAction;
import training.featuresSuggester.actions.DebugProcessStartedAction;
import training.featuresSuggester.actions.DebugProcessStoppedAction;
import training.featuresSuggester.actions.DebugSessionPausedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\t\u001a\u0012\u0012\u000e\u0012\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\f0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u0014\u0010\u0018\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\b\u00a8\u0006 "}, d2={"Ltraining/featuresSuggester/suggesters/MuteBreakpointsSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "()V", "countOfRemovedBreakpointsToGetSuggestion", "", "id", "", "getId", "()Ljava/lang/String;", "languages", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getLanguages", "()Ljava/util/List;", "message", "getMessage", "minSuggestingIntervalDays", "getMinSuggestingIntervalDays", "()I", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "suggestingActionId", "getSuggestingActionId", "suggestingDocUrl", "getSuggestingDocUrl", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "Companion", "State", "intellij.featuresTrainer"})
public final class MuteBreakpointsSuggester
extends AbstractFeatureSuggester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("mute.breakpoints.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("mute.breakpoints.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingDocUrl;
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages = CollectionsKt.listOf((Object)Language.ANY.getID());
    private final int countOfRemovedBreakpointsToGetSuggestion;
    public static final long MAX_TIME_MILLIS_BETWEEN_ACTIONS = 5000L;

    public MuteBreakpointsSuggester() {
        this.id = "Mute breakpoints";
        this.suggestingActionId = "XDebugger.MuteBreakpoints";
        this.suggestingDocUrl = "https://www.jetbrains.com/help/idea/using-breakpoints.html#mute";
        this.minSuggestingIntervalDays = 30;
        this.countOfRemovedBreakpointsToGetSuggestion = 3;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Action action3 = action2;
        if (action3 instanceof DebugSessionPausedAction) {
            XBreakpoint<?> breakpoint = SuggestingUtils.INSTANCE.findBreakpointOnPosition(((DebugSessionPausedAction)action2).getProject(), ((DebugSessionPausedAction)action2).getPosition());
            if (State.INSTANCE.getLastBreakpointPosition() == null && breakpoint != null) {
                State.INSTANCE.applyPausedOnBreakpoint(((DebugSessionPausedAction)action2).getPosition(), action2.getTimeMillis());
            } else {
                State.INSTANCE.reset();
            }
        } else if (action3 instanceof BreakpointRemovedAction) {
            if (XSourcePosition.isOnTheSameLine((XSourcePosition)((BreakpointRemovedAction)action2).getPosition(), (XSourcePosition)State.INSTANCE.getLastBreakpointPosition())) {
                State.INSTANCE.applyBreakpointRemoving(action2.getTimeMillis());
                if (State.INSTANCE.getCurCountOfRemovedBreakpoints() >= this.countOfRemovedBreakpointsToGetSuggestion) {
                    State.INSTANCE.reset();
                    return this.createSuggestion();
                }
            } else {
                State.INSTANCE.reset();
            }
        } else if ((action3 instanceof BreakpointAddedAction ? true : action3 instanceof DebugProcessStartedAction) ? true : action3 instanceof DebugProcessStoppedAction) {
            State.INSTANCE.reset();
        }
        return NoSuggestion.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltraining/featuresSuggester/suggesters/MuteBreakpointsSuggester$Companion;", "", "()V", "MAX_TIME_MILLIS_BETWEEN_ACTIONS", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013J\u0016\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0013J\u0006\u0010 \u001a\u00020\u001cR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006!"}, d2={"Ltraining/featuresSuggester/suggesters/MuteBreakpointsSuggester$State;", "", "()V", "curCountOfRemovedBreakpoints", "", "getCurCountOfRemovedBreakpoints", "()I", "setCurCountOfRemovedBreakpoints", "(I)V", "isOutOfDate", "", "()Z", "lastBreakpointPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getLastBreakpointPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "setLastBreakpointPosition", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "lastBreakpointRemovedTimeMillis", "", "getLastBreakpointRemovedTimeMillis", "()J", "setLastBreakpointRemovedTimeMillis", "(J)V", "lastPauseTimeMillis", "getLastPauseTimeMillis", "setLastPauseTimeMillis", "applyBreakpointRemoving", "", "timeMillis", "applyPausedOnBreakpoint", "position", "reset", "intellij.featuresTrainer"})
    private static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        @Nullable
        private static XSourcePosition lastBreakpointPosition;
        private static long lastPauseTimeMillis;
        private static long lastBreakpointRemovedTimeMillis;
        private static int curCountOfRemovedBreakpoints;

        private State() {
        }

        @Nullable
        public final XSourcePosition getLastBreakpointPosition() {
            return lastBreakpointPosition;
        }

        public final void setLastBreakpointPosition(@Nullable XSourcePosition xSourcePosition) {
            lastBreakpointPosition = xSourcePosition;
        }

        public final long getLastPauseTimeMillis() {
            return lastPauseTimeMillis;
        }

        public final void setLastPauseTimeMillis(long l) {
            lastPauseTimeMillis = l;
        }

        public final long getLastBreakpointRemovedTimeMillis() {
            return lastBreakpointRemovedTimeMillis;
        }

        public final void setLastBreakpointRemovedTimeMillis(long l) {
            lastBreakpointRemovedTimeMillis = l;
        }

        public final int getCurCountOfRemovedBreakpoints() {
            return curCountOfRemovedBreakpoints;
        }

        public final void setCurCountOfRemovedBreakpoints(int n) {
            curCountOfRemovedBreakpoints = n;
        }

        public final boolean isOutOfDate() {
            return lastPauseTimeMillis != 0L && lastBreakpointRemovedTimeMillis != 0L && Math.abs(lastBreakpointRemovedTimeMillis - lastPauseTimeMillis) > 5000L;
        }

        public final void applyPausedOnBreakpoint(@NotNull XSourcePosition position, long timeMillis) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            lastBreakpointPosition = position;
            lastPauseTimeMillis = timeMillis;
            if (this.isOutOfDate()) {
                this.reset();
            }
        }

        public final void applyBreakpointRemoving(long timeMillis) {
            lastBreakpointPosition = null;
            lastBreakpointRemovedTimeMillis = timeMillis;
            int n = curCountOfRemovedBreakpoints;
            curCountOfRemovedBreakpoints = n + 1;
            if (this.isOutOfDate()) {
                this.reset();
            }
        }

        public final void reset() {
            lastBreakpointPosition = null;
            lastPauseTimeMillis = 0L;
            lastBreakpointRemovedTimeMillis = 0L;
            curCountOfRemovedBreakpoints = 0;
        }
    }
}

