/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.impl;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.RuntimeModuleDescriptorImpl;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import com.intellij.platform.runtime.repository.serialization.RuntimeModuleRepositorySerialization;
import com.intellij.platform.runtime.repository.serialization.impl.JarFileSerializer;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeModuleRepositoryImpl
implements RuntimeModuleRepository {
    private final Map<RuntimeModuleId, RuntimeModuleRepository.ResolveResult> myResolveResults;
    private volatile RawRuntimeModuleRepositoryData myMainData;
    private volatile List<RawRuntimeModuleRepositoryData> myAdditionalData;
    private final Path myDescriptorsJarPath;
    private final Map<String, RuntimeModuleId> myInternedModuleIds;

    public RuntimeModuleRepositoryImpl(@NotNull Path descriptorsJarPath) {
        if (descriptorsJarPath == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(0);
        }
        this.myDescriptorsJarPath = descriptorsJarPath;
        this.myResolveResults = new ConcurrentHashMap<RuntimeModuleId, RuntimeModuleRepository.ResolveResult>();
        this.myInternedModuleIds = new ConcurrentHashMap<String, RuntimeModuleId>();
    }

    @Override
    @NotNull
    public RuntimeModuleRepository.ResolveResult resolveModule(@NotNull RuntimeModuleId moduleId) {
        RuntimeModuleRepository.ResolveResult result;
        if (moduleId == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(1);
        }
        if ((result = this.myResolveResults.get(moduleId)) == null) {
            result = this.resolveModule(moduleId, new LinkedHashMap<RuntimeModuleId, RuntimeModuleDescriptorImpl>());
        }
        RuntimeModuleRepository.ResolveResult resolveResult = result;
        if (resolveResult == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(2);
        }
        return resolveResult;
    }

    @NotNull
    private RuntimeModuleRepository.ResolveResult resolveModule(@NotNull RuntimeModuleId moduleId, @NotNull Map<RuntimeModuleId, RuntimeModuleDescriptorImpl> dependencyPath) {
        RuntimeModuleRepository.ResolveResult cached;
        if (moduleId == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(3);
        }
        if (dependencyPath == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(4);
        }
        if ((cached = this.myResolveResults.get(moduleId)) != null) {
            RuntimeModuleRepository.ResolveResult resolveResult = cached;
            if (resolveResult == null) {
                RuntimeModuleRepositoryImpl.$$$reportNull$$$0(5);
            }
            return resolveResult;
        }
        RawRuntimeModuleRepositoryData rawData = this.getMainData();
        RawRuntimeModuleDescriptor rawDescriptor = rawData.findDescriptor(moduleId.getStringId());
        if (rawDescriptor == null) {
            if (this.myAdditionalData != null) {
                for (RawRuntimeModuleRepositoryData data : this.myAdditionalData) {
                    rawDescriptor = data.findDescriptor(moduleId.getStringId());
                    if (rawDescriptor == null) continue;
                    rawData = data;
                    break;
                }
            }
            if (rawDescriptor == null) {
                ArrayList<RuntimeModuleId> failedPath = new ArrayList<RuntimeModuleId>(dependencyPath.size() + 1);
                failedPath.addAll(dependencyPath.keySet());
                failedPath.add(moduleId);
                return new FailedResolveResult(failedPath);
            }
        }
        List<String> rawDependencies = rawDescriptor.getDependencies();
        ArrayList<RuntimeModuleDescriptor> resolvedDependencies = new ArrayList<RuntimeModuleDescriptor>(rawDependencies.size());
        RuntimeModuleDescriptorImpl descriptor = new RuntimeModuleDescriptorImpl(moduleId, rawData.getBasePath(), rawDescriptor.getResourcePaths(), resolvedDependencies);
        dependencyPath.put(moduleId, descriptor);
        for (String dependency : rawDependencies) {
            RuntimeModuleId dependencyId = this.myInternedModuleIds.computeIfAbsent(dependency, RuntimeModuleId::raw);
            RuntimeModuleDescriptor circularDependency = dependencyPath.get(dependencyId);
            if (circularDependency != null) {
                resolvedDependencies.add(circularDependency);
                continue;
            }
            RuntimeModuleRepository.ResolveResult result = this.resolveModule(dependencyId, dependencyPath);
            RuntimeModuleDescriptor module = result.getResolvedModule();
            if (module != null) {
                resolvedDependencies.add(module);
                continue;
            }
            RuntimeModuleRepository.ResolveResult resolveResult = result;
            if (resolveResult == null) {
                RuntimeModuleRepositoryImpl.$$$reportNull$$$0(6);
            }
            return resolveResult;
        }
        dependencyPath.remove(moduleId);
        SuccessfulResolveResult result = new SuccessfulResolveResult(descriptor);
        this.myResolveResults.put(moduleId, result);
        SuccessfulResolveResult successfulResolveResult = result;
        if (successfulResolveResult == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(7);
        }
        return successfulResolveResult;
    }

    @Override
    @NotNull
    public RuntimeModuleDescriptor getModule(@NotNull RuntimeModuleId moduleId) {
        String message;
        RuntimeModuleRepository.ResolveResult result;
        RuntimeModuleDescriptor module;
        if (moduleId == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(8);
        }
        if ((module = (result = this.resolveModule(moduleId)).getResolvedModule()) != null) {
            RuntimeModuleDescriptor runtimeModuleDescriptor = module;
            if (runtimeModuleDescriptor == null) {
                RuntimeModuleRepositoryImpl.$$$reportNull$$$0(9);
            }
            return runtimeModuleDescriptor;
        }
        List<RuntimeModuleId> failedDependencyPath = result.getFailedDependencyPath();
        if (failedDependencyPath.size() == 1) {
            message = "Cannot find module '" + failedDependencyPath.get(0).getStringId() + "'";
        } else {
            ArrayList<RuntimeModuleId> reversed = new ArrayList<RuntimeModuleId>(failedDependencyPath.subList(0, failedDependencyPath.size() - 1));
            Collections.reverse(reversed);
            message = "Cannot resolve module '" + moduleId.getStringId() + "': module '" + failedDependencyPath.get(failedDependencyPath.size() - 1).getStringId() + "' (" + reversed.stream().map(id -> " <- '" + id.getStringId() + "'").collect(Collectors.joining()).trim() + ") is not found";
        }
        throw new MalformedRepositoryException(message);
    }

    @Override
    @NotNull
    public List<Path> getModuleResourcePaths(@NotNull RuntimeModuleId moduleId) {
        RawRuntimeModuleRepositoryData rawData;
        RawRuntimeModuleDescriptor rawDescriptor;
        if (moduleId == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(10);
        }
        if ((rawDescriptor = (rawData = this.getMainData()).findDescriptor(moduleId.getStringId())) == null) {
            if (this.myAdditionalData != null) {
                for (RawRuntimeModuleRepositoryData repository : this.myAdditionalData) {
                    rawDescriptor = repository.findDescriptor(moduleId.getStringId());
                    if (rawDescriptor == null) continue;
                    rawData = repository;
                    break;
                }
            }
            if (rawDescriptor == null) {
                throw new MalformedRepositoryException("Cannot find module '" + moduleId.getStringId() + "'");
            }
        }
        List<Path> list = new RuntimeModuleDescriptorImpl(moduleId, rawData.getBasePath(), rawDescriptor.getResourcePaths(), Collections.emptyList()).getResourceRootPaths();
        if (list == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Path> getBootstrapClasspath(@NotNull String bootstrapModuleName) {
        block7: {
            if (bootstrapModuleName == null) {
                RuntimeModuleRepositoryImpl.$$$reportNull$$$0(12);
            }
            if (this.myMainData == null) {
                ArrayList<Path> arrayList;
                try {
                    String[] bootstrapClasspath = JarFileSerializer.loadBootstrapClasspath(this.myDescriptorsJarPath, bootstrapModuleName);
                    if (bootstrapClasspath == null) break block7;
                    ArrayList<Path> result = new ArrayList<Path>(bootstrapClasspath.length);
                    for (String relativePath : bootstrapClasspath) {
                        result.add(this.myDescriptorsJarPath.getParent().resolve(relativePath));
                    }
                    arrayList = result;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (arrayList == null) {
                    RuntimeModuleRepositoryImpl.$$$reportNull$$$0(13);
                }
                return arrayList;
            }
        }
        List<Path> list = this.getModule(RuntimeModuleId.module(bootstrapModuleName)).getModuleClasspath();
        if (list == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void loadAdditionalRepositories(@NotNull @NotNull List<@NotNull RawRuntimeModuleRepositoryData> repositories) {
        if (repositories == null) {
            RuntimeModuleRepositoryImpl.$$$reportNull$$$0(15);
        }
        if (repositories.isEmpty()) {
            return;
        }
        if (this.myAdditionalData != null) {
            throw new IllegalStateException("additional repositories may be loaded only once");
        }
        this.myAdditionalData = repositories;
    }

    public String toString() {
        return "RuntimeModuleRepository{descriptorsJarPath=" + this.myDescriptorsJarPath + "}";
    }

    private RawRuntimeModuleRepositoryData getMainData() {
        if (this.myMainData == null) {
            this.myMainData = RuntimeModuleRepositorySerialization.loadFromJar(this.myDescriptorsJarPath);
        }
        return this.myMainData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsJarPath";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapModuleName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModule";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleResourcePaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootstrapClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModuleResourcePaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBootstrapClasspath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalRepositories";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FailedResolveResult
    implements RuntimeModuleRepository.ResolveResult {
        private final List<RuntimeModuleId> myFailedDependencyPath;

        private FailedResolveResult(@NotNull List<RuntimeModuleId> failedDependencyPath) {
            if (failedDependencyPath == null) {
                FailedResolveResult.$$$reportNull$$$0(0);
            }
            this.myFailedDependencyPath = failedDependencyPath;
        }

        @Override
        @Nullable
        public RuntimeModuleDescriptor getResolvedModule() {
            return null;
        }

        @Override
        @NotNull
        public List<RuntimeModuleId> getFailedDependencyPath() {
            List<RuntimeModuleId> list = this.myFailedDependencyPath;
            if (list == null) {
                FailedResolveResult.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failedDependencyPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl$FailedResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl$FailedResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailedDependencyPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SuccessfulResolveResult
    implements RuntimeModuleRepository.ResolveResult {
        private final RuntimeModuleDescriptor myResolved;

        private SuccessfulResolveResult(@NotNull RuntimeModuleDescriptor resolved) {
            if (resolved == null) {
                SuccessfulResolveResult.$$$reportNull$$$0(0);
            }
            this.myResolved = resolved;
        }

        @Override
        @NotNull
        public RuntimeModuleDescriptor getResolvedModule() {
            RuntimeModuleDescriptor runtimeModuleDescriptor = this.myResolved;
            if (runtimeModuleDescriptor == null) {
                SuccessfulResolveResult.$$$reportNull$$$0(1);
            }
            return runtimeModuleDescriptor;
        }

        @Override
        @NotNull
        public List<RuntimeModuleId> getFailedDependencyPath() {
            List<RuntimeModuleId> list = Collections.emptyList();
            if (list == null) {
                SuccessfulResolveResult.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolved";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl$SuccessfulResolveResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/runtime/repository/impl/RuntimeModuleRepositoryImpl$SuccessfulResolveResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResolvedModule";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailedDependencyPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

