/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.IllegalDataException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.EscapeStrategy;
import org.jdom.output.Format;

@Deprecated
public class XMLOutputter
implements Cloneable {
    private Format userFormat;
    private static final Format preserveFormat = Format.getRawFormat();
    protected Format currentFormat;

    public XMLOutputter() {
        this.currentFormat = this.userFormat = Format.getRawFormat();
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.currentFormat = this.userFormat = format.clone();
    }

    public XMLOutputter(XMLOutputter that) {
        this.currentFormat = this.userFormat = Format.getRawFormat();
        this.currentFormat = this.userFormat = that.userFormat.clone();
    }

    public void setFormat(Format newFormat) {
        this.currentFormat = this.userFormat = newFormat.clone();
    }

    public Format getFormat() {
        return this.userFormat.clone();
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    private Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return XMLOutputter.makeWriter(out, this.userFormat.encoding);
    }

    private static Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(out, this.userFormat.encoding);
        List<Content> content = doc.getContent();
        int size = content.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Content obj = content.get(i2);
            if (obj instanceof Element) {
                this.printElement(out, doc.getRootElement(), 0, new NamespaceStack());
            } else if (obj instanceof DocType) {
                this.printDocType(out, doc.getDocType());
                this.writeLineSeparator(out);
            }
            this.newline(out);
            this.indent(out, 0);
        }
        this.writeLineSeparator(out);
        out.flush();
    }

    private void writeLineSeparator(Writer out) throws IOException {
        if (this.currentFormat.lineSeparator != null) {
            out.write(this.currentFormat.lineSeparator);
        }
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(out, doctype);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(out, element, 0, new NamespaceStack());
        out.flush();
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATA(out, cdata);
        out.flush();
    }

    public void output(Text text, Writer out) throws IOException {
        this.printText(out, text);
        out.flush();
    }

    public void output(Comment comment, Writer out) throws IOException {
        XMLOutputter.printComment(out, comment);
        out.flush();
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
    }

    public void output(EntityRef entity, Writer out) throws IOException {
        XMLOutputter.printEntityRef(out, entity);
        out.flush();
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.printDocType(out, doctype);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.printElement(out, element, 0, new NamespaceStack());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(List list) {
        StringWriter out = new StringWriter();
        try {
            this.printContentRange(out, list, 0, list.size(), 0, new NamespaceStack());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.printCDATA(out, cdata);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Text text) {
        StringWriter out = new StringWriter();
        try {
            this.printText(out, text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static String outputString(EntityRef entity) {
        StringWriter out = new StringWriter();
        try {
            XMLOutputter.printEntityRef(out, entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    private void printDeclaration(Writer out, String encoding) throws IOException {
        if (!this.userFormat.omitDeclaration) {
            out.write("<?xml version=\"1.0\"");
            if (!this.userFormat.omitEncoding) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            this.writeLineSeparator(out);
        }
    }

    private void printDocType(Writer out, DocType docType) throws IOException {
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        String internalSubset = docType.getInternalSubset();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (internalSubset != null && !internalSubset.isEmpty()) {
            out.write(" [");
            this.writeLineSeparator(out);
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
    }

    private static void printComment(Writer out, Comment comment) throws IOException {
        out.write("<!--");
        out.write(comment.getText());
        out.write("-->");
    }

    private static void printEntityRef(Writer out, EntityRef entity) throws IOException {
        out.write("&");
        out.write(entity.getName());
        out.write(";");
    }

    private void printCDATA(Writer out, CDATA cdata) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? cdata.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? cdata.getText().trim() : cdata.getText());
        out.write("<![CDATA[");
        out.write(str);
        out.write("]]>");
    }

    protected void printText(Writer out, Text text) throws IOException {
        String str = this.currentFormat.mode == Format.TextMode.NORMALIZE ? text.getTextNormalize() : (this.currentFormat.mode == Format.TextMode.TRIM ? text.getText().trim() : text.getText());
        out.write(this.escapeElementEntities(str));
    }

    private void printString(Writer out, String str) throws IOException {
        if (this.currentFormat.mode == Format.TextMode.NORMALIZE) {
            str = Text.normalizeString(str);
        } else if (this.currentFormat.mode == Format.TextMode.TRIM) {
            str = str.trim();
        }
        out.write(this.escapeElementEntities(str));
    }

    private void printElement(Writer out, Element element, int level, NamespaceStack namespaces) throws IOException {
        int size;
        int start;
        List<Attribute> attributes = element.getAttributes();
        List<Content> content = element.getContent();
        String space = null;
        if (attributes != null) {
            space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format previousFormat = this.currentFormat;
        if ("default".equals(space)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(space)) {
            this.currentFormat = preserveFormat;
        }
        out.write("<");
        XMLOutputter.printQualifiedName(out, element);
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(out, element, namespaces);
        this.printAdditionalNamespaces(out, element, namespaces);
        if (attributes != null) {
            this.printAttributes(out, attributes, namespaces);
        }
        if ((start = this.skipLeadingWhite(content, 0)) >= (size = content.size())) {
            if (this.currentFormat.expandEmptyElements) {
                out.write("></");
                XMLOutputter.printQualifiedName(out, element);
                out.write(">");
            } else {
                out.write(" />");
            }
        } else {
            out.write(">");
            if (XMLOutputter.nextNonText(content, start) < size) {
                this.newline(out);
                this.printContentRange(out, content, start, size, level + 1, namespaces);
                this.newline(out);
                this.indent(out, level);
            } else {
                this.printTextRange(out, content, start, size);
            }
            out.write("</");
            XMLOutputter.printQualifiedName(out, element);
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
        this.currentFormat = previousFormat;
    }

    private void printContentRange(Writer out, List<Content> content, int start, int end, int level, NamespaceStack namespaces) throws IOException {
        int index = start;
        while (index < end) {
            boolean firstNode = index == start;
            Content next = content.get(index);
            if (next instanceof Text || next instanceof EntityRef) {
                int first2 = this.skipLeadingWhite(content, index);
                if (first2 >= (index = XMLOutputter.nextNonText(content, first2))) continue;
                if (!firstNode) {
                    this.newline(out);
                }
                this.indent(out, level);
                this.printTextRange(out, content, first2, index);
                continue;
            }
            if (!firstNode) {
                this.newline(out);
            }
            this.indent(out, level);
            if (next instanceof Element) {
                this.printElement(out, (Element)next, level, namespaces);
            }
            ++index;
        }
    }

    private void printTextRange(Writer out, List content, int start, int end) throws IOException {
        int size;
        String previous = null;
        if ((start = this.skipLeadingWhite(content, start)) < (size = content.size())) {
            end = this.skipTrailingWhite(content, end);
            for (int i2 = start; i2 < end; ++i2) {
                String next;
                Object node = content.get(i2);
                if (node instanceof Text) {
                    next = ((Text)node).getText();
                } else if (node instanceof EntityRef) {
                    next = "&" + ((EntityRef)node).getValue() + ";";
                } else {
                    throw new IllegalStateException("Should see only CDATA, Text, or EntityRef");
                }
                if (next == null || next.isEmpty()) continue;
                if (previous != null && (this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) && (XMLOutputter.endsWithWhite(previous) || XMLOutputter.startsWithWhite(next))) {
                    out.write(" ");
                }
                if (node instanceof CDATA) {
                    this.printCDATA(out, (CDATA)node);
                } else if (node instanceof EntityRef) {
                    XMLOutputter.printEntityRef(out, (EntityRef)node);
                } else {
                    this.printString(out, next);
                }
                previous = next;
            }
        }
    }

    private void printNamespace(Writer out, Namespace ns, NamespaceStack namespaces) throws IOException {
        String prefix = ns.getPrefix();
        String uri = ns.getURI();
        if (uri.equals(namespaces.getURI(prefix))) {
            return;
        }
        out.write(" xmlns");
        if (!prefix.isEmpty()) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(this.escapeAttributeEntities(uri));
        out.write("\"");
        namespaces.push(ns);
    }

    private void printAttributes(Writer out, List<? extends Attribute> attributes, NamespaceStack namespaces) throws IOException {
        for (int i2 = 0; i2 < attributes.size(); ++i2) {
            Attribute attribute = attributes.get(i2);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                this.printNamespace(out, ns, namespaces);
            }
            out.write(" ");
            XMLOutputter.printQualifiedName(out, attribute);
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
        }
    }

    private void printElementNamespace(Writer out, Element element, NamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns == Namespace.XML_NAMESPACE) {
            return;
        }
        if (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null) {
            this.printNamespace(out, ns, namespaces);
        }
    }

    private void printAdditionalNamespaces(Writer out, Element element, NamespaceStack namespaces) throws IOException {
        List<Namespace> list = element.getAdditionalNamespaces();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Namespace additional = list.get(i2);
                this.printNamespace(out, additional, namespaces);
            }
        }
    }

    private void newline(Writer out) throws IOException {
        if (this.currentFormat.indent != null) {
            this.writeLineSeparator(out);
        }
    }

    private void indent(Writer out, int level) throws IOException {
        if (this.currentFormat.indent == null || this.currentFormat.indent.isEmpty()) {
            return;
        }
        for (int i2 = 0; i2 < level; ++i2) {
            out.write(this.currentFormat.indent);
        }
    }

    private int skipLeadingWhite(List content, int start) {
        int index;
        if (start < 0) {
            start = 0;
        }
        int size = content.size();
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index = start; index < size; ++index) {
                if (XMLOutputter.isAllWhitespace(content.get(index))) continue;
                return index;
            }
        }
        return index;
    }

    private int skipTrailingWhite(List content, int start) {
        int index;
        int size = content.size();
        if (start > size) {
            start = size;
        }
        if (this.currentFormat.mode == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.mode == Format.TextMode.NORMALIZE || this.currentFormat.mode == Format.TextMode.TRIM) {
            for (index = start; index >= 0 && XMLOutputter.isAllWhitespace(content.get(index - 1)); --index) {
            }
        }
        return index;
    }

    private static int nextNonText(List content, int start) {
        if (start < 0) {
            start = 0;
        }
        int size = content.size();
        for (int index = start; index < size; ++index) {
            Object node = content.get(index);
            if (node instanceof Text || node instanceof EntityRef) continue;
            return index;
        }
        return size;
    }

    private static boolean isAllWhitespace(Object obj) {
        String str;
        if (obj instanceof String) {
            str = (String)obj;
        } else if (obj instanceof Text) {
            str = ((Text)obj).getText();
        } else {
            if (obj instanceof EntityRef) {
                return false;
            }
            return false;
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (Verifier.isXMLWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean startsWithWhite(String str) {
        return str != null && !str.isEmpty() && Verifier.isXMLWhitespace(str.charAt(0));
    }

    private static boolean endsWithWhite(String str) {
        return str != null && !str.isEmpty() && Verifier.isXMLWhitespace(str.charAt(str.length() - 1));
    }

    public String escapeAttributeEntities(String str) {
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String entity;
            int ch = str.charAt(i2);
            int pos = i2++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 34: {
                    entity = "&quot;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 9: {
                    entity = "&#x9;";
                    break;
                }
                case 10: {
                    entity = "&#xA;";
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i2 < str.length()) {
                                char low = str.charAt(i2);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, pos);
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public String escapeElementEntities(String str) {
        boolean escapeOutput = true;
        if (!escapeOutput) {
            return str;
        }
        EscapeStrategy strategy = this.currentFormat.escapeStrategy;
        StringBuilder buffer = null;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String entity;
            int ch = str.charAt(i2);
            int pos = i2++;
            switch (ch) {
                case 60: {
                    entity = "&lt;";
                    break;
                }
                case 62: {
                    entity = "&gt;";
                    break;
                }
                case 38: {
                    entity = "&amp;";
                    break;
                }
                case 13: {
                    entity = "&#xD;";
                    break;
                }
                case 10: {
                    entity = this.currentFormat.lineSeparator;
                    break;
                }
                default: {
                    if (strategy.shouldEscape((char)ch)) {
                        if (Verifier.isHighSurrogate((char)ch)) {
                            if (i2 < str.length()) {
                                char low = str.charAt(i2);
                                if (!Verifier.isLowSurrogate(low)) {
                                    throw new IllegalDataException("Could not decode surrogate pair 0x" + Integer.toHexString(ch) + " / 0x" + Integer.toHexString(low));
                                }
                                ch = Verifier.decodeSurrogatePair((char)ch, low);
                            } else {
                                throw new IllegalDataException("Surrogate pair 0x" + Integer.toHexString(ch) + " truncated");
                            }
                        }
                        entity = "&#x" + Integer.toHexString(ch) + ";";
                        break;
                    }
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str, 0, pos);
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append((char)ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.userFormat.lineSeparator != null) {
            block5: for (int i2 = 0; i2 < this.userFormat.lineSeparator.length(); ++i2) {
                char ch = this.userFormat.lineSeparator.charAt(i2);
                switch (ch) {
                    case '\r': {
                        buffer.append("\\r");
                        continue block5;
                    }
                    case '\n': {
                        buffer.append("\\n");
                        continue block5;
                    }
                    case '\t': {
                        buffer.append("\\t");
                        continue block5;
                    }
                    default: {
                        buffer.append("[").append((int)ch).append("]");
                    }
                }
            }
        } else {
            buffer.append("null");
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.omitDeclaration + ", encoding = " + this.userFormat.encoding + ", omitEncoding = " + this.userFormat.omitEncoding + ", indent = '" + this.userFormat.indent + "', expandEmptyElements = " + this.userFormat.expandEmptyElements + ", lineSeparator = '" + buffer + "', textMode = " + (Object)((Object)this.userFormat.mode) + "]";
    }

    private static void printQualifiedName(Writer out, Element e2) throws IOException {
        if (e2.getNamespace().getPrefix().isEmpty()) {
            out.write(e2.getName());
        } else {
            out.write(e2.getNamespace().getPrefix());
            out.write(58);
            out.write(e2.getName());
        }
    }

    private static void printQualifiedName(Writer out, Attribute a2) throws IOException {
        String prefix = a2.getNamespace().getPrefix();
        if (prefix != null && !prefix.isEmpty()) {
            out.write(prefix);
            out.write(58);
            out.write(a2.getName());
        } else {
            out.write(a2.getName());
        }
    }

    protected static final class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        protected NamespaceStack() {
        }
    }
}

