/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public final class EditDistance {
    private EditDistance() {
    }

    public static int levenshtein(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        if (str1 == null) {
            EditDistance.$$$reportNull$$$0(0);
        }
        if (str2 == null) {
            EditDistance.$$$reportNull$$$0(1);
        }
        int[][] d2 = EditDistance.prepare(str1.length(), str2.length());
        for (int i2 = 1; i2 <= str1.length(); ++i2) {
            for (int j2 = 1; j2 <= str2.length(); ++j2) {
                int cost = EditDistance.equal(str1.charAt(i2 - 1), str2.charAt(j2 - 1), caseSensitive) ? 0 : 1;
                d2[i2][j2] = EditDistance.min(d2[i2 - 1][j2] + 1, d2[i2][j2 - 1] + 1, d2[i2 - 1][j2 - 1] + cost);
            }
        }
        return d2[str1.length()][str2.length()];
    }

    public static int optimalAlignment(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        if (str1 == null) {
            EditDistance.$$$reportNull$$$0(2);
        }
        if (str2 == null) {
            EditDistance.$$$reportNull$$$0(3);
        }
        return EditDistance.optimalAlignment(str1, str2, caseSensitive, Integer.MAX_VALUE);
    }

    public static int optimalAlignment(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive, int limit2) {
        if (str1 == null) {
            EditDistance.$$$reportNull$$$0(4);
        }
        if (str2 == null) {
            EditDistance.$$$reportNull$$$0(5);
        }
        if (str1.length() > str2.length()) {
            CharSequence tmp = str1;
            str1 = str2;
            str2 = tmp;
        }
        int length1 = str1.length();
        int length2 = str2.length();
        if (length1 == 0) {
            return length2;
        }
        int[] v0 = new int[length1 + 1];
        int[] v1 = new int[length1 + 1];
        int[] v2 = new int[length1 + 1];
        for (int i2 = 1; i2 <= length1; ++i2) {
            v1[i2] = i2;
        }
        int minCost = limit2 + 1;
        for (int j2 = 0; j2 < length2; ++j2) {
            v2[0] = j2 + 1;
            for (int i3 = 0; i3 < length1; ++i3) {
                int currentCost;
                int cost = EditDistance.equal(str1.charAt(i3), str2.charAt(j2), caseSensitive) ? 0 : 1;
                v2[i3 + 1] = EditDistance.min(v2[i3] + 1, v1[i3 + 1] + 1, v1[i3] + cost);
                if (i3 > 0 && j2 > 0 && EditDistance.equal(str2.charAt(j2), str1.charAt(i3 - 1), caseSensitive) && EditDistance.equal(str1.charAt(i3), str2.charAt(j2 - 1), caseSensitive)) {
                    v2[i3 + 1] = Math.min(v2[i3 + 1], v0[i3 - 1] + cost);
                }
                if ((currentCost = v2[i3 + 1]) >= minCost) continue;
                minCost = currentCost;
            }
            if (minCost > limit2) {
                return minCost;
            }
            minCost = limit2 + 1;
            int[] temp = v0;
            v0 = v1;
            v1 = v2;
            v2 = temp;
        }
        return v1[length1];
    }

    private static int[][] prepare(int length1, int length2) {
        int[][] d2 = new int[length1 + 1][length2 + 1];
        for (int i2 = 0; i2 <= length1; ++i2) {
            d2[i2][0] = i2;
        }
        for (int j2 = 0; j2 <= length2; ++j2) {
            d2[0][j2] = j2;
        }
        return d2;
    }

    private static boolean equal(char c1, char c2, boolean caseSensitive) {
        return caseSensitive ? c1 == c2 : Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static int min(int a2, int b2, int c2) {
        return Math.min(Math.min(a2, b2), c2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str1";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/text/EditDistance";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "levenshtein";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "optimalAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

